/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.pln.blow.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bgerp.plugin.pln.blow.model.Board;
import org.bgerp.util.Log;
import ru.bgcrm.model.Pair;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.model.process.ProcessExecutor;
import ru.bgcrm.util.Utils;

public class Item {
    private static final Log log = Log.getLog();
    private final Board board;
    private final Process process;
    private final Map<String, Object> params;
    private final Set<Integer> filterIds = new HashSet<Integer>();
    private Item parent;
    private boolean childrenSorted = false;
    private final List<Item> children = new ArrayList<Item>();
    private Set<Integer> executorIds;

    public Item(Board board, Pair<Process, Map<String, Object>> pair) {
        this.board = board;
        this.process = pair != null ? pair.getFirst() : null;
        this.params = pair != null ? pair.getSecond() : null;
    }

    public Process getProcess() {
        return this.process;
    }

    public int getProcessId() {
        return this.process != null ? this.process.getId() : 0;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public Set<Integer> getFilterIds() {
        return this.filterIds;
    }

    public void addFilterId(int value) {
        this.filterIds.add(value);
    }

    public Item getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Item> getChildren() {
        List<Item> list = this.children;
        synchronized (list) {
            if (!this.childrenSorted) {
                Collections.sort(this.children, this.board.getConfig().getItemComparator());
                this.childrenSorted = true;
            }
        }
        return Collections.unmodifiableList(this.children);
    }

    public void addChild(Item item) {
        item.parent = this;
        this.children.add(item);
    }

    public int getExecutorId() {
        Set<Integer> executors = this.getExecutorIds();
        return executors.isEmpty() || executors.size() > 1 ? 0 : Utils.getFirst(executors);
    }

    public boolean hasExecutor(int executorId) {
        return this.getExecutorIds().contains(executorId);
    }

    private Set<Integer> getExecutorIds() {
        if (this.executorIds == null) {
            this.executorIds = new HashSet<Integer>(10);
            for (Item child : this.children) {
                if (child.getExecutorIds().isEmpty()) {
                    this.executorIds = Collections.emptySet();
                    return this.executorIds;
                }
                this.executorIds.addAll(child.getExecutorIds());
            }
            if (this.process != null) {
                if (this.board.isUserMode()) {
                    Set<Integer> groupIds = this.board.getConfig().getExecutorGroupIds();
                    if (groupIds.isEmpty()) {
                        this.executorIds.addAll(this.process.getExecutorIdsWithRoles(this.board.getConfig().getExecutorRoleIds()));
                    } else {
                        this.executorIds.addAll(this.process.getExecutors().stream().filter(pe -> pe.getRoleId() == 0 && groupIds.contains(pe.getGroupId())).map(ProcessExecutor::getUserId).collect(Collectors.toList()));
                    }
                } else {
                    this.executorIds.addAll(this.process.getGroupIdsWithRole(0));
                }
            }
        }
        return this.executorIds;
    }

    @Deprecated
    public int getPriority() {
        log.warndMethod("getPriority");
        if (this.process == null) {
            return 0;
        }
        if (this.process.getPriority() > 0) {
            return this.process.getPriority();
        }
        return 0;
    }
}

