<%@ page contentType="text/html; charset=UTF-8"%>
<%@ include file="/WEB-INF/jspf/taglibs.jsp"%>

<div class="center1020">
	<c:set var="tables" value="${frd.tables}"/>

	<div class="mt1">
		Tables: <b>${tables.size()}</b>
		Rows: <b>${frd.rows}</b>
		Size: <b>${fu.byteCountToDisplaySize(frd.size)}</b>

		<c:url var="url" value="/admin/plugin/dba/cleanup.do">
			<c:param name="returnUrl" value="${form.requestUrl}"/>
		</c:url>
		<p:check action="/admin/plugin/dba/cleanup:null">
			[<a href="#" onclick="$$.ajax.loadContent('${url}', this); return false;">cleanup</a>]
		</p:check>
	</div>

	<form action="/admin/plugin/dba/db.do">
		<input type="hidden" name="method" value="drop"/>

		<c:set var="dropEnabled" value="${not empty frd.dropStatus}"/>

		<table class="data hl mt1">
			<tr>
				<c:if test="${dropEnabled}">
					<td width="10" class="nowrap"><b>${frd.dropStatus}</b></td>
				</c:if>
				<td>Name</td>
				<td>Data Size</td>
				<td>Index Size</td>
				<td>Create Time</td>
				<td>Update Time</td>
			</tr>
			<c:forEach var="table" items="${tables}">
				<tr>
					<c:if test="${dropEnabled}">
						<td>
							<c:if test="${table.dropCandidate}">
								<input type="checkbox" name="table" value="${table.name}" checked="true"/>
							</c:if>
						</td>
					</c:if>
					<td>${table.name}</td>
					<td>${fu.byteCountToDisplaySize(table.dataLength)}</td>
					<td>${fu.byteCountToDisplaySize(table.indexLength)}</td>
					<td nowrap="1">${tu.format(table.createTime, 'ymdhms')}</td>
					<td nowrap="1">${tu.format(table.updateTime, 'ymdhms')}</td>
				</tr>
				<c:forEach var="column" items="${table.unusedColumns}">
					<tr>
						<c:if test="${dropEnabled}">
							<td>
								<c:if test="${column.dropCandidate}">
									<span class="pl1"><input type="checkbox" name="column" value="${table.name}:${column.name}" checked="true"/></span>
								</c:if>
							</td>
						</c:if>
						<td>
							<span class="pl1">${column.name}</span>
						</td>
						<td colspan="4"></td>
					</tr>
				</c:forEach>
			</c:forEach>
		</table>

		<c:if test="${dropEnabled}">
			<button type="button" class="btn-grey mt1" onclick="
				if (confirm('${l.l('Do you really want to drop selected tables and columns?')}'))
					$$.ajax.post(this).done(() =>
						$$.ajax.loadContent('${form.requestUrl}', this)
					)
			">${l.l('Drop selected')}</button>
		</c:if>
	</form>
</div>

<shell:title text="Database"/>
<shell:state help="plugin/svc/dba/index.html#usage-db"/>
