/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.struts.action.admin;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionForward;
import org.bgerp.action.base.BaseAction;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.event.EventProcessor;
import org.bgerp.app.exception.BGException;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.cache.UserCache;
import org.bgerp.model.Pageable;
import org.bgerp.util.sql.LikePattern;
import ru.bgcrm.dao.user.UserDAO;
import ru.bgcrm.dao.user.UserGroupDAO;
import ru.bgcrm.dao.user.UserPermsetDAO;
import ru.bgcrm.event.user.UserChangedEvent;
import ru.bgcrm.model.user.Group;
import ru.bgcrm.model.user.PermissionNode;
import ru.bgcrm.model.user.Permset;
import ru.bgcrm.model.user.User;
import ru.bgcrm.model.user.UserGroup;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.PswdUtil;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.SingleConnectionSet;

@ActionServlet.Action(path="/admin/user")
public class UserAction
extends BaseAction {
    private static final String PATH_JSP = "/WEB-INF/jspf/admin/user";

    public ActionForward permsetList(DynActionForm form, Connection con) {
        new UserPermsetDAO(con).searchPermset(new Pageable<Permset>(form), LikePattern.SUB.get(form.getParam("filter")));
        return this.html(con, form, "/WEB-INF/jspf/admin/user/permset/list.jsp");
    }

    public ActionForward permsetGet(DynActionForm form, Connection con) {
        Permset permset = new UserPermsetDAO(con).getPermsetById(form.getId());
        if (permset != null) {
            UserPermsetDAO permsetDao = new UserPermsetDAO(con);
            form.setResponseData("permset", permset);
            form.setResponseData("grantedPermission", PermissionNode.primaryActions(permsetDao.getPermissions(permset.getId())));
        }
        form.setRequestAttribute("permTrees", PermissionNode.getPermissionTrees());
        return this.html(con, form, "/WEB-INF/jspf/admin/user/permset/update.jsp");
    }

    public ActionForward permsetUpdate(DynActionForm form, Connection con) throws Exception {
        UserPermsetDAO permsetDAO = new UserPermsetDAO(con);
        int id = form.getId();
        Permset permset = new Permset();
        if (id > 0) {
            permset = permsetDAO.getPermsetById(id);
        }
        if (permset == null) {
            throw new BGMessageException("\u0413\u0440\u0443\u043f\u043f\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430.", new Object[0]);
        }
        permset.setTitle(form.getParam("title", Utils::notBlankString));
        permset.setComment(form.getParam("comment", ""));
        permset.setConfig(form.getParam("permsetConfig", ""));
        permsetDAO.updatePermset(permset);
        Set<String> config = form.getParamValuesStr("permConfig");
        permsetDAO.updatePermissions(form.getParamValuesStr("permAction"), config, permset.getId());
        UserCache.flush(con);
        return this.json(con, form);
    }

    public ActionForward permsetDelete(DynActionForm form, Connection con) throws Exception {
        new UserPermsetDAO(con).deletePermset(form.getId());
        UserCache.flush(con);
        return this.json(con, form);
    }

    public ActionForward permsetReplacePermissions(DynActionForm form, Connection con) {
        new UserPermsetDAO(con).replacePermissions(form.getParamInt("fromId"), form.getId());
        UserCache.flush(con);
        return this.json(con, form);
    }

    public ActionForward groupList(DynActionForm form, Connection con) throws SQLException {
        Group group;
        int parentId = form.getParamInt("parentGroupId", 0);
        HttpServletRequest request = form.getHttpRequest();
        request.setAttribute("groupPath", UserCache.getGroupPath(parentId));
        new UserGroupDAO(con).searchGroup(new Pageable<Group>(form), parentId, LikePattern.SUB.get(form.getParam("filter")));
        int id = form.getParamInt("markGroup", -1);
        if (id > 0 && (group = new UserGroupDAO(con).getGroupById(id)) != null) {
            request.setAttribute("markGroupString", (Object)group.getTitle());
        }
        return this.html(con, form, "/WEB-INF/jspf/admin/user/group/list.jsp");
    }

    public ActionForward groupGet(DynActionForm form, Connection con) throws Exception {
        UserGroupDAO groupDAO = new UserGroupDAO(con);
        Group group = groupDAO.getGroupById(form.getId());
        if (group != null) {
            group.setQueueIds(groupDAO.getGroupQueueIds(form.getId()));
            group.setPermsetIds(groupDAO.getGroupPermsetIds(form.getId()));
            form.setResponseData("group", group);
        }
        return this.html(con, form, "/WEB-INF/jspf/admin/user/group/update.jsp");
    }

    public ActionForward groupUpdate(DynActionForm form, Connection con) throws Exception {
        UserGroupDAO groupDAO = new UserGroupDAO(con);
        int id = form.getId();
        boolean archive = Utils.parseBoolean(form.getParam("archive"), false);
        Group group = new Group();
        if (id > 0) {
            group = groupDAO.getGroupById(id);
        }
        if (group == null) {
            throw new BGMessageException("\u0413\u0440\u0443\u043f\u043f\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430.", new Object[0]);
        }
        group.setTitle(form.getParam("title").replace("\"", ""));
        group.setComment(form.getParam("comment"));
        group.setQueueIds(form.getParamValues("queue"));
        group.setPermsetIds(form.getParamValuesList("permset"));
        group.setParentId(Utils.parseInt(form.getParam("parentGroupId")));
        group.setArchive(archive ? 1 : 0);
        group.setConfig(form.getParam("groupConfig"));
        if (Utils.isBlankString(group.getTitle())) {
            throw new BGMessageException("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435.", new Object[0]);
        }
        groupDAO.updateGroup(group);
        UserCache.flush(con);
        return this.json(con, form);
    }

    public ActionForward groupDelete(DynActionForm form, Connection con) throws Exception {
        List<User> userInGroupList = new UserDAO(con).getUserList(Collections.singleton(form.getId()));
        if (!userInGroupList.isEmpty()) {
            throw new BGMessageException("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0433\u0440\u0443\u043f\u043f\u044b \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e. \u0412 \u0433\u0440\u0443\u043f\u043f\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u0441\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0438.", new Object[0]);
        }
        new UserGroupDAO(con).deleteGroup(form.getId());
        UserCache.flush(con);
        return this.json(con, form);
    }

    public ActionForward groupInsertMark(DynActionForm form, Connection con) throws Exception {
        int parentId = form.getParamInt("parentGroupId", 0);
        int id = form.getParamInt("markGroup", -1);
        if (id != -1) {
            UserGroupDAO groupDAO = new UserGroupDAO(con);
            Group group = groupDAO.getGroupById(id);
            if (!groupDAO.checkGroup(0, parentId, group.getTitle())) {
                throw new BGMessageException("\u0422\u0430\u043a\u043e\u0435 \u0438\u043c\u044f \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u0434\u0430\u043d\u043d\u043e\u0439 \u0432\u0435\u0442\u043a\u0435.", new Object[0]);
            }
            if (parentId == id) {
                throw new BGMessageException("\u041d\u0435\u043b\u044c\u0437\u044f \u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0432 \u0441\u0430\u043c\u043e\u0433\u043e \u0441\u0435\u0431\u044f.", new Object[0]);
            }
            group.setParentId(parentId);
            groupDAO.updateGroup(group);
            UserCache.flush(con);
            form.setParam("markGroup", "0");
        }
        return this.json(con, form);
    }

    public ActionForward userList(DynActionForm form, Connection con) throws Exception {
        Date actualDate = form.getParamDate("date", new Date());
        ConfigMap perm = form.getPermission();
        Set<Integer> groups = form.getParamValues("group");
        String allowOnlyGroups = perm.get("allowOnlyGroups", "");
        Set<Integer> permsets = form.getParamValues("permset");
        int status = form.getParamInt("status", 0);
        if ((groups == null || groups.size() <= 0) && Utils.notBlankString(allowOnlyGroups)) {
            groups = Utils.toIntegerSet(allowOnlyGroups);
        }
        new UserDAO(con).searchUser(new Pageable<User>(form), LikePattern.SUB.get(form.getParam("filter")), groups, null, actualDate, permsets, status);
        return this.html(con, form, "/WEB-INF/jspf/admin/user/user/list.jsp");
    }

    public ActionForward userGet(DynActionForm form, Connection con) throws Exception {
        UserDAO userDAO = new UserDAO(con);
        User user = userDAO.getUser(form.getId());
        if (user != null) {
            form.setResponseData("user", user);
            form.setResponseData("grantedPermission", PermissionNode.primaryActions(userDAO.getPermissions(user.getId())));
            form.setRequestAttribute("userGroupList", userDAO.getUserGroupList(user.getId(), form.getParamDate("date")));
        }
        form.setRequestAttribute("permTrees", PermissionNode.getPermissionTrees());
        return this.html(con, form, "/WEB-INF/jspf/admin/user/user/update.jsp");
    }

    public ActionForward userUpdate(DynActionForm form, Connection con) throws Exception {
        User existingUser;
        String queueSet;
        String groupSet;
        String permsetSet;
        UserDAO userDAO = new UserDAO(con);
        int id = form.getId();
        User user = new User();
        if (id > 0 && (user = userDAO.getUser(id)) == null) {
            throw new BGMessageException("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d.", new Object[0]);
        }
        ConfigMap perm = form.getPermission();
        user.setTitle(form.getParam("title", Utils::notBlankString));
        user.setLogin(form.getParam("login", Utils::notBlankString));
        user.setPassword(form.getParam("pswd", ""));
        user.setStatus(form.getParamInt("status", 0));
        if (!perm.getBoolean("configDisable", false)) {
            user.setConfig(form.getParam("userConfig", ""));
        }
        user.setDescription(form.getParam("description", ""));
        String setConfVars = perm.get("setConfigVars");
        if (Utils.notBlankString(setConfVars)) {
            user.setConfig(user.getConfig() + "\n" + setConfVars.replace(';', '\n'));
        }
        if (Utils.notBlankString(permsetSet = perm.get("permsetSet", ""))) {
            if (id <= 0) {
                user.setPermsetIds(Utils.toIntegerList(permsetSet));
            }
        } else {
            user.setPermsetIds(form.getParamValuesList("permset"));
        }
        if (Utils.notBlankString(groupSet = perm.get("groupSet", "")) && id <= 0) {
            user.setGroupIds(Utils.toIntegerSet(groupSet));
        }
        if (Utils.notBlankString(queueSet = perm.get("queueSet", ""))) {
            if (id <= 0) {
                user.setQueueIds(Utils.toIntegerSet(queueSet));
            }
        } else {
            user.setQueueIds(form.getParamValues("queue"));
        }
        if ((existingUser = userDAO.getUserByLogin(user.getLogin())) != null && id != existingUser.getId()) {
            throw new BGMessageException("\u041b\u043e\u0433\u0438\u043d \u0437\u0430\u043d\u044f\u0442 \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u043c \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u043c!", new Object[0]);
        }
        new PswdUtil.UserPswdUtil(this.setup).checkPassword(user.getPassword());
        userDAO.updateUser(user);
        if (!perm.getBoolean("permDisable", false)) {
            userDAO.updatePermissions(form.getParamValuesStr("permAction"), form.getParamValuesStr("permConfig"), user.getId());
        }
        UserCache.flush(con);
        EventProcessor.processEvent(new UserChangedEvent(form, user), new SingleConnectionSet(con));
        form.setResponseData("newUserId", user.getId());
        return this.json(con, form);
    }

    public ActionForward userDelete(DynActionForm form, Connection con) throws Exception {
        UserDAO userDAO = new UserDAO(con);
        userDAO.deleteUser(form.getId());
        UserCache.flush(con);
        return this.json(con, form);
    }

    public ActionForward userGroupList(DynActionForm form, Connection con) throws Exception {
        ConfigMap perm = form.getPermission();
        String allowOnlyGroups = perm.get("allowOnlyGroups", "");
        if (Utils.notBlankString(allowOnlyGroups)) {
            boolean contains = false;
            Set<Integer> allowOnlyGroupsSet = Utils.toIntegerSet(allowOnlyGroups);
            for (Integer allowGroup : allowOnlyGroupsSet) {
                if (!UserCache.getUser(form.getId()).getGroupIds().contains(allowGroup)) continue;
                contains = true;
                break;
            }
            if (!contains) {
                throw new BGException("\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440 \u0433\u0440\u0443\u043f\u043f \u044d\u0442\u043e\u0433\u043e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d!", new Object[0]);
            }
        }
        form.setRequestAttribute("userGroupList", UserCache.getUserGroupList(form.getId(), form.getParamDate("date")));
        return this.html(con, form, "/WEB-INF/jspf/admin/user/user/update_usergroup.jsp");
    }

    public ActionForward userAddGroup(DynActionForm form, Connection con) throws Exception {
        Date fromDate = form.getParamDate("fromDate");
        Date toDate = form.getParamDate("toDate");
        int groupId = form.getParamInt("group");
        int userId = form.getParamInt("userId", 0);
        if (userId == 0) {
            userId = form.getId();
        }
        this.addGroup(form, con, fromDate, toDate, groupId, userId);
        return this.json(con, form);
    }

    public void addGroup(DynActionForm form, Connection con, Date fromDate, Date toDate, int groupId, int userId) throws Exception {
        Set<Integer> allowOnlyGroupsSet;
        if (groupId <= 0) {
            throw new BGMessageException("\u0413\u0440\u0443\u043f\u043f\u0430 \u043d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u0430!", new Object[0]);
        }
        if (UserCache.getUserGroup(groupId) == null) {
            throw new BGMessageException("\u0413\u0440\u0443\u043f\u043f\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430!", new Object[0]);
        }
        ConfigMap perm = form.getPermission();
        String allowOnlyGroups = perm.get("allowOnlyGroups", "");
        if (Utils.notBlankString(allowOnlyGroups) && !(allowOnlyGroupsSet = Utils.toIntegerSet(allowOnlyGroups)).contains(groupId)) {
            throw new BGMessageException("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u044d\u0442\u043e\u0439 \u0433\u0440\u0443\u043f\u043f\u044b \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e!", new Object[0]);
        }
        UserGroup group = new UserGroup(groupId, fromDate, toDate);
        new UserDAO(con).addUserGroup(userId, group);
        UserCache.flush(con);
    }

    public ActionForward userRemoveGroup(DynActionForm form, Connection con) throws Exception {
        Set<Integer> allowOnlyGroupsSet;
        int userId = form.getParamInt("userId", -1);
        int groupId = form.getParamInt("groupId", -1);
        Date dateFrom = form.getParamDate("dateFrom");
        Date dateTo = form.getParamDate("dateTo");
        ConfigMap perm = form.getPermission();
        String allowOnlyGroups = perm.get("allowOnlyGroups", "");
        if (Utils.notBlankString(allowOnlyGroups) && !(allowOnlyGroupsSet = Utils.toIntegerSet(allowOnlyGroups)).contains(groupId)) {
            throw new BGMessageException("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u044d\u0442\u043e\u0439 \u0433\u0440\u0443\u043f\u043f\u044b \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e!", new Object[0]);
        }
        new UserDAO(con).removeUserGroup(userId, groupId, dateFrom, dateTo);
        UserCache.flush(con);
        return this.json(con, form);
    }

    public ActionForward userClosePeriodGroup(DynActionForm form, Connection con) throws Exception {
        int userId = form.getParamInt("userId", -1);
        int groupId = form.getParamInt("groupId", -1);
        Date date = form.getParamDate("date");
        Date dateFrom = form.getParamDate("dateFrom");
        Date dateTo = form.getParamDate("dateTo");
        this.closeGroup(form, con, userId, groupId, date, dateFrom, dateTo);
        UserCache.flush(con);
        return this.json(con, form);
    }

    public void closeGroup(DynActionForm form, Connection con, int userId, int groupId, Date date, Date dateFrom, Date dateTo) throws Exception {
        Set<Integer> allowOnlyGroupsSet;
        if (date == null) {
            throw new BGException("\u0414\u0430\u0442\u0430 \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u043f\u0443\u0441\u0442\u043e\u0439!", new Object[0]);
        }
        ConfigMap perm = form.getPermission();
        String allowOnlyGroups = perm.get("allowOnlyGroups", "");
        if (Utils.notBlankString(allowOnlyGroups) && !(allowOnlyGroupsSet = Utils.toIntegerSet(allowOnlyGroups)).contains(groupId)) {
            throw new BGException("\u0417\u0430\u043a\u0440\u044b\u0442\u0438\u0435 \u043f\u0435\u0440\u0438\u043e\u0434\u0430 \u0434\u043b\u044f \u044d\u0442\u043e\u0439 \u0433\u0440\u0443\u043f\u043f\u044b \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e!", new Object[0]);
        }
        new UserDAO(con).closeUserGroupPeriod(userId, groupId, date, dateFrom, dateTo);
    }
}

