/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.struts.action;

import java.io.OutputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.struts.action.ActionForward;
import org.bgerp.app.cfg.Preferences;
import org.bgerp.app.exception.BGException;
import org.bgerp.app.exception.BGIllegalArgumentException;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.cache.ProcessQueueCache;
import org.bgerp.cache.ProcessTypeCache;
import org.bgerp.dao.process.ProcessQueueDAO;
import org.bgerp.model.Pageable;
import org.bgerp.model.process.ProcessCreateType;
import org.bgerp.model.process.queue.JasperReport;
import org.bgerp.util.Log;
import ru.bgcrm.dao.process.SavedFilterDAO;
import ru.bgcrm.dao.user.UserDAO;
import ru.bgcrm.event.ProcessMarkedActionEvent;
import ru.bgcrm.model.Page;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.model.process.queue.MediaColumn;
import ru.bgcrm.model.process.queue.Processor;
import ru.bgcrm.model.process.queue.Queue;
import ru.bgcrm.model.process.queue.config.PrintQueueConfig;
import ru.bgcrm.model.process.queue.config.SavedCommonFiltersConfig;
import ru.bgcrm.model.process.queue.config.SavedFilter;
import ru.bgcrm.model.process.queue.config.SavedFiltersConfig;
import ru.bgcrm.model.process.queue.config.SavedPanelConfig;
import ru.bgcrm.model.user.User;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.action.ProcessAction;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;

@ActionServlet.Action(path="/user/process/queue")
public class ProcessQueueAction
extends ProcessAction {
    private static final Log log = Log.getLog();
    private static final String PATH_JSP = "/WEB-INF/jspf/user/process";
    private static final String QUEUE_FULL_FILTER_SELECTED_FILTERS = "queueSelectedFilters";
    private static final String QUEUE_FULL_FILTER_PARAMS = "queueCurrentSavedFiltersParam.";

    public ActionForward queue(DynActionForm form, ConnectionSet conSet) throws Exception {
        form.setResponseData("list", ProcessQueueCache.getUserQueueList(form.getUser()));
        return this.html(conSet, form, "/WEB-INF/jspf/user/process/queue/queue.jsp");
    }

    public ActionForward typeTree(DynActionForm form, Connection con) throws Exception {
        int queueId = Utils.parseInt(form.getParam("queueId"));
        Queue queue = ProcessQueueCache.getQueue(queueId, form.getUser());
        if (queue != null) {
            form.setRequestAttribute("typeTreeRoot", ProcessCreateType.treeRoot(form, "queue", queue.getProcessTypeIds()));
        }
        return this.html(con, form, "/WEB-INF/jspf/user/process/tree/process_type_tree.jsp");
    }

    public ActionForward processor(DynActionForm form, ConnectionSet conSet) throws Exception {
        Queue queue = ProcessQueueCache.getQueue(form.getParamInt("queueId"), form.getUser());
        if (queue != null) {
            Processor processor = queue.getProcessor(form.getParamInt("processorId"));
            List<Integer> processIds = Utils.toIntegerList(form.getParam("processIds"));
            ProcessMarkedActionEvent event = new ProcessMarkedActionEvent(form, processor, processIds);
            processor.process(event, conSet);
            if (event.isStreamResponse()) {
                return null;
            }
            return this.json(conSet, form);
        }
        throw new BGException("Queue not found.", new Object[0]);
    }

    public ActionForward queueSavedFilterSet(DynActionForm form, Connection con) throws Exception {
        Preferences personalizationMap = form.getUser().getPersonalizationMap();
        SavedFiltersConfig config = personalizationMap.getConfig(SavedFiltersConfig.class);
        String persConfigBefore = personalizationMap.getDataString();
        String command = form.getParam("command");
        int queueId = form.getParamInt("queueId");
        if (Utils.isBlankString(command) || queueId <= 0) {
            throw new BGIllegalArgumentException();
        }
        ArrayList<SavedFilter> commonFilters = new SavedFilterDAO(con).getFilters(queueId);
        SavedCommonFiltersConfig commonConfig = new SavedCommonFiltersConfig(commonFilters);
        if (command.equals("delete")) {
            config.removeSavedFilterSet(queueId, form.getId());
            personalizationMap.removeSub("queueCurrentSavedFilterSet." + queueId);
        } else if (command.equals("add")) {
            String title = form.getParam("title");
            String url = form.getParam("url");
            if (Utils.isBlankString(title) || Utils.isBlankString(url)) {
                throw new BGIllegalArgumentException();
            }
            int createdSetId = config.addSavedFilterSet(queueId, title, url);
            personalizationMap.put("queueCurrentSavedFilterSet." + queueId, String.valueOf(createdSetId));
        } else if (command.equals("select")) {
            if (form.getId() < 0) {
                throw new BGIllegalArgumentException();
            }
            personalizationMap.put("queueCurrentSavedFilterSet." + queueId, String.valueOf(form.getId()));
        } else if (command.equals("toFullFilter")) {
            SavedFiltersConfig.SavedFilterSet filter = config.getSavedFilterSetMap().get(form.getId());
            DynActionForm savedFiltersForm = filter != null ? new DynActionForm(filter.getUrl()) : new DynActionForm();
            this.saveFormFilters(queueId, savedFiltersForm, personalizationMap);
            personalizationMap.remove(QUEUE_FULL_FILTER_SELECTED_FILTERS + queueId);
        } else if (command.equals("updateFiltersOrder")) {
            config.reorderSavedFilterSets(queueId, form.getParamValuesList("setId"));
        } else if (command.equals("setRareStatus")) {
            int filterId = form.getParamInt("filterId");
            Boolean value = form.getParamBoolean("rare", false);
            log.debug("set rare status: " + value + " " + filterId, new Object[0]);
            config.setRareStatus(queueId, filterId, value);
        } else if (command.equals("setStatusCounterOnPanel")) {
            int filterId = form.getParamInt("filterId");
            Boolean value = form.getParamBoolean("statusCounterOnPanel", false);
            String color = form.getParam("color");
            String title = form.getParam("title");
            String queueName = form.getParam("queueName");
            log.debug("set counter on panel status: " + value + " " + filterId, new Object[0]);
            config.setStatusCounterOnPanel(queueId, filterId, color, value, title, queueName);
        } else if (command.equals("addCommon")) {
            String title = form.getParam("title");
            String url = form.getParam("url");
            log.debug("Adding common filter " + title + " " + url, new Object[0]);
            if (Utils.isBlankString(title) || Utils.isBlankString(url)) {
                throw new BGIllegalArgumentException();
            }
            commonConfig.addSavedCommonFilter(queueId, title, url);
            new SavedFilterDAO(con).updateFilter(commonConfig, queueId);
        } else if (command.equals("importCommon")) {
            String title = form.getParam("title");
            int id = form.getParamInt("id");
            String url = new SavedFilterDAO(con).getFilterUrlById(id);
            log.debug("Importing common filter " + title + " " + url, new Object[0]);
            if (Utils.isBlankString(title) || Utils.isBlankString(url)) {
                throw new BGIllegalArgumentException();
            }
            int createdSetId = config.addSavedFilterSet(queueId, title, url);
            personalizationMap.put("queueCurrentSavedFilterSet." + queueId, String.valueOf(createdSetId));
        } else if (command.equals("deleteCommon")) {
            String title = form.getParam("title");
            int id = form.getParamInt("id");
            String url = new SavedFilterDAO(con).getFilterUrlById(id);
            log.debug("Deleting common filter " + title + " " + url, new Object[0]);
            if (Utils.isBlankString(title) || Utils.isBlankString(url)) {
                throw new BGIllegalArgumentException();
            }
            commonConfig.deleteSavedCommonFilter(queueId, title, url);
            new SavedFilterDAO(con).deleteFilter(id);
        }
        config.updateConfig(personalizationMap);
        new UserDAO(con).updatePersonalization(persConfigBefore, form.getUser());
        return this.json(con, form);
    }

    public ActionForward queueSavedPanelSet(DynActionForm form, Connection con) throws Exception {
        Preferences map = form.getUser().getPersonalizationMap();
        SavedPanelConfig config = map.getConfig(SavedPanelConfig.class);
        String mapDataBefore = map.getDataString();
        String command = form.getParam("command");
        Integer queueId = form.getParamInt("queueId");
        log.debug(command + " " + queueId, new Object[0]);
        if (Utils.isBlankString(command) || queueId <= 0) {
            throw new BGIllegalArgumentException();
        }
        if (command.equals("add")) {
            config.addSavedPanelSet(queueId);
        } else if (command.equals("delete")) {
            config.removeSavedPanelSet(queueId);
        } else if (command.equals("updateSelected")) {
            config.changeCurrentSelected(queueId);
        }
        config.updateConfig(map);
        new UserDAO(con).updatePersonalization(mapDataBefore, form.getUser());
        return this.json(con, form);
    }

    public ActionForward queueGet(DynActionForm form, Connection con) throws Exception {
        User user = form.getUser();
        HttpServletRequest request = form.getHttpRequest();
        Queue queue = ProcessQueueCache.getQueue(form.getId(), user);
        if (queue != null && form.getUser().getQueueIds().contains(queue.getId())) {
            ArrayList<SavedFilter> commonFilters = new SavedFilterDAO(con).getFilters(queue.getId());
            SavedCommonFiltersConfig commonConfig = new SavedCommonFiltersConfig(commonFilters);
            request.setAttribute("commonConfig", (Object)commonConfig);
            form.setResponseData("queue", queue);
            List types = ProcessTypeCache.getTypeList().stream().filter(type -> queue.getProcessTypeIds().contains(type.getId())).collect(Collectors.toList());
            form.setResponseData("typeList", types);
            Preferences personalizationMap = user.getPersonalizationMap();
            String persConfigBefore = personalizationMap.getDataString();
            personalizationMap.put("queueLastSelected", String.valueOf(queue.getId()));
            String filtersValues = personalizationMap.get(QUEUE_FULL_FILTER_PARAMS + form.getId());
            if (!Utils.isEmptyString(filtersValues)) {
                DynActionForm savedParamsFilters = new DynActionForm(filtersValues);
                request.setAttribute("savedParamsFilters", (Object)savedParamsFilters);
            }
            new UserDAO(con).updatePersonalization(persConfigBefore, user);
        }
        return this.html(con, form, "/WEB-INF/jspf/user/process/queue/filter.jsp");
    }

    public ActionForward queueShow(DynActionForm form, ConnectionSet connectionSet) throws Exception {
        Preferences personalizationMap = form.getUser().getPersonalizationMap();
        String configBefore = personalizationMap.getDataString();
        int savedFilterSetId = form.getParamInt("savedFilterSetId");
        String selectedFilters = form.getParam("selectedFilters");
        personalizationMap.put("queueCurrentSavedFilterSet." + form.getId(), String.valueOf(savedFilterSetId));
        if (selectedFilters != null) {
            personalizationMap.put(QUEUE_FULL_FILTER_SELECTED_FILTERS + form.getId(), selectedFilters);
        }
        if (savedFilterSetId == 0) {
            this.saveFormFilters(form.getId(), form, personalizationMap);
        }
        new UserDAO(connectionSet.getConnection()).updatePersonalization(configBefore, form.getUser());
        if (!form.getUser().getQueueIds().contains(form.getId())) {
            throw new BGMessageException("\u0412\u0430\u043c \u043d\u0435 \u0440\u0430\u0437\u0440\u0435\u0448\u0451\u043d \u0434\u043e\u0441\u0442\u0443\u043f \u043a \u043e\u0447\u0435\u0440\u0435\u0434\u0438 \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u043e\u0432 \u0441 ID={}", form.getId());
        }
        Queue queue = ProcessQueueCache.getQueue(form.getId(), form.getUser());
        if (queue != null) {
            boolean noHtmlMedia;
            Pageable<Object[]> searchResult = new Pageable<Object[]>(form);
            ArrayList<String> aggregateValues = new ArrayList<String>();
            String media = this.getMedia(form);
            boolean bl = noHtmlMedia = !"html".equals(media);
            if (noHtmlMedia) {
                searchResult.getPage().setPageIndex(Page.PAGE_INDEX_NO_PAGING);
            }
            new ProcessQueueDAO(connectionSet.getSlaveConnection(), form).searchProcess(searchResult, aggregateValues, queue, form);
            List<Object[]> list = searchResult.getList();
            if (noHtmlMedia) {
                this.processNoHtmlResult(media, form, queue, connectionSet, list);
                return null;
            }
            HttpServletRequest request = form.getHttpRequest();
            request.setAttribute("columnList", queue.getMediaColumnList("html"));
            queue.replaceRowsForMedia(form, "html", list);
            request.setAttribute("queue", (Object)queue);
            if (aggregateValues.size() > 0) {
                form.setResponseData("aggregateValues", aggregateValues);
            }
        } else {
            throw new BGMessageException("\u041e\u0447\u0435\u0440\u0435\u0434\u044c \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u043e\u0432 \u0441 ID={} \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430", form.getId());
        }
        return this.html(connectionSet, form, "/WEB-INF/jspf/user/process/queue/show.jsp");
    }

    private void saveFormFilters(int queueId, DynActionForm form, Preferences personalizationMap) {
        personalizationMap.put(QUEUE_FULL_FILTER_PARAMS + queueId, form.paramsToQueryString());
    }

    private String getMedia(DynActionForm form) {
        if (Utils.notBlankString(form.getParam("print"))) {
            return "print";
        }
        if (Utils.notBlankString(form.getParam("xls"))) {
            return "xls";
        }
        return "html";
    }

    private void processNoHtmlResult(String media, DynActionForm form, Queue queue, ConnectionSet connectionSet, List<Object[]> list) throws Exception {
        Set<Integer> processIds = Utils.toIntegerSet(form.getParam("processIds"));
        if (processIds.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                Process process = ((Process[])list.get(i)[0])[0];
                if (processIds.contains(process.getId())) continue;
                list.remove(i--);
            }
        }
        if ("print".equals(media)) {
            int printTypeId = form.getParamInt("printTypeId");
            if (printTypeId > 0) {
                PrintQueueConfig config = queue.getConfigMap().getConfig(PrintQueueConfig.class);
                PrintQueueConfig.PrintType printType = config.getPrintType(printTypeId);
                queue.replaceRowsForMediaColumns(form, list, queue.getMediaColumnList(printType.getColumnIds()), false);
                this.printQueue(form, list, queue, printType);
            } else {
                queue.replaceRowsForMedia(form, media, list);
                this.printQueue(form, list, queue, null);
            }
        } else if ("xls".equals(media)) {
            queue.replaceRowsForMedia(form, media, list);
            try (HSSFWorkbook workbook = new HSSFWorkbook();){
                HSSFSheet sheet = workbook.createSheet("BGERP processes");
                List<MediaColumn> columnList = queue.getMediaColumnList(media);
                HSSFRow titleRow = sheet.createRow(0);
                for (int i = 0; i < columnList.size(); ++i) {
                    Cell titleCell = titleRow.createCell(i);
                    titleCell.setCellValue(columnList.get(i).getColumn().getTitle());
                }
                for (int k = 0; k < list.size(); ++k) {
                    HSSFRow row = sheet.createRow(k + 1);
                    Object[] dataRow = list.get(k);
                    for (int i = 0; i < dataRow.length; ++i) {
                        if (dataRow[i].equals("null")) continue;
                        Cell cell = row.createCell(i);
                        cell.setCellValue(dataRow[i].toString());
                    }
                }
                HttpServletResponse response = form.getHttpResponse();
                response.setContentType("application/vnd.ms-excel");
                response.setHeader("Content-Disposition", "attachment; filename=bgerp_process_queue.xls");
                workbook.write((OutputStream)response.getOutputStream());
            }
        }
    }

    private void printQueue(DynActionForm form, List<Object[]> data, Queue queue, PrintQueueConfig.PrintType printType) throws Exception {
        HttpServletResponse response = form.getHttpResponse();
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment;filename=" + (printType == null ? "queue.pdf" : printType.getFileName()));
        JasperReport.addPrintQueueDocumentToOutputStream(form, data, queue, printType, (OutputStream)response.getOutputStream());
    }
}

