/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.struts.action;

import com.google.common.base.Functions;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForward;
import org.bgerp.action.base.BaseAction;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.event.EventProcessor;
import org.bgerp.app.exception.BGException;
import org.bgerp.app.exception.BGIllegalArgumentException;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.cache.ParameterCache;
import org.bgerp.cache.ProcessTypeCache;
import org.bgerp.cache.UserCache;
import org.bgerp.cache.UserGroupRoleCache;
import org.bgerp.dao.message.process.MessagePossibleProcessSearch;
import org.bgerp.dao.param.ParamValueDAO;
import org.bgerp.dao.process.Order;
import org.bgerp.dao.process.ProcessCloneDAO;
import org.bgerp.dao.process.ProcessLogDAO;
import org.bgerp.dao.process.ProcessMessageDAO;
import org.bgerp.dao.process.ProcessSearchDAO;
import org.bgerp.event.base.UserEvent;
import org.bgerp.model.Pageable;
import org.bgerp.model.base.IdStringTitle;
import org.bgerp.model.base.IdTitle;
import org.bgerp.model.msg.Message;
import org.bgerp.model.msg.config.MessageTypeConfig;
import org.bgerp.model.param.Parameter;
import org.bgerp.model.process.ProcessCreateType;
import org.bgerp.model.process.ProcessGroups;
import org.bgerp.model.process.config.IsolationConfig;
import org.bgerp.model.process.config.ProcessPriorityConfig;
import org.bgerp.model.process.link.ProcessLink;
import org.bgerp.util.Log;
import org.bgerp.util.text.PatternFormatter;
import ru.bgcrm.dao.IfaceStateDAO;
import ru.bgcrm.dao.message.MessageDAO;
import ru.bgcrm.dao.message.MessageTypeNote;
import ru.bgcrm.dao.process.ProcessDAO;
import ru.bgcrm.dao.process.StatusChangeDAO;
import ru.bgcrm.event.listener.TemporaryObjectOpenListener;
import ru.bgcrm.event.process.ProcessChangedEvent;
import ru.bgcrm.event.process.ProcessChangingEvent;
import ru.bgcrm.event.process.ProcessMessageAddedEvent;
import ru.bgcrm.event.process.ProcessRemovedEvent;
import ru.bgcrm.model.EntityLogItem;
import ru.bgcrm.model.Pair;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.model.process.ProcessExecutor;
import ru.bgcrm.model.process.ProcessGroup;
import ru.bgcrm.model.process.ProcessType;
import ru.bgcrm.model.process.StatusChange;
import ru.bgcrm.model.process.TransactionProperties;
import ru.bgcrm.model.process.TypeProperties;
import ru.bgcrm.model.process.Wizard;
import ru.bgcrm.model.process.wizard.base.WizardData;
import ru.bgcrm.model.user.Group;
import ru.bgcrm.model.user.User;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.action.ProcessCommandExecutor;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;
import ru.bgcrm.util.sql.SingleConnectionSet;

@ActionServlet.Action(path="/user/process")
public class ProcessAction
extends BaseAction {
    private static final Log log = Log.getLog();
    private static final String PATH_JSP = "/WEB-INF/jspf/user/process";

    @Override
    public ActionForward unspecified(DynActionForm form, ConnectionSet conSet) throws Exception {
        return this.process(form, conSet);
    }

    public ActionForward process(DynActionForm form, ConnectionSet conSet) throws Exception {
        Connection con = conSet.getConnection();
        Connection conSlave = conSet.getSlaveConnection();
        Process process = new ProcessDAO(con, form).getProcess(form.getId());
        if (process == null) {
            process = new Process(form.getId());
            process.setTitle(this.l.l("\u041f\u0420\u041e\u0426\u0415\u0421\u0421 \u0414\u041b\u042f \u0412\u0410\u0421 \u041d\u0415 \u0421\u0423\u0429\u0415\u0421\u0422\u0412\u0423\u0415\u0422", new Object[0]));
            form.setResponseData("process", process);
        } else {
            Wizard wizard;
            ProcessType type = ProcessTypeCache.getProcessType(process.getTypeId());
            form.setResponseData("process", process);
            form.setRequestAttribute("processType", type);
            form.setRequestAttribute("ifaceStateMap", new IfaceStateDAO(conSlave).getIfaceStates("process", process.getId()));
            if ((Utils.notBlankString(form.getParam("wizard")) || form.getId() < 0) && (wizard = type.getProperties().getWizard()) != null) {
                form.setRequestAttribute("wizardData", new WizardData(con, form, wizard, process, form.getId() < 0 ? wizard.getCreateStepList() : wizard.getStepList()));
            }
        }
        return this.html(conSet, form, "/WEB-INF/jspf/user/process/process/process.jsp");
    }

    public static List<ProcessCreateType> processCreateTypes(DynActionForm form, String area, Set<Integer> ids) {
        List<ProcessType> types = ProcessTypeCache.getTypeList();
        ArrayList<ProcessCreateType> result = new ArrayList<ProcessCreateType>(types.size());
        for (ProcessType type : types) {
            ProcessCreateType createType = new ProcessCreateType(type, area);
            if (!createType.check() || ids != null && !ids.contains(type.getId())) continue;
            result.add(createType);
        }
        log.debug("processCreateTypes area: {}, ids: {}, result: {}", area, ids, result);
        User user = form.getUser();
        IsolationConfig.IsolationProcess isolation = user.getConfigMap().getConfig(IsolationConfig.class).getIsolationProcess();
        if (isolation.getType() == IsolationConfig.IsolationProcess.Type.GROUP || form.getPermission().getBoolean("onlyPermittedTypes")) {
            Iterator iterator = result.iterator();
            while (iterator.hasNext()) {
                ProcessCreateType type = (ProcessCreateType)iterator.next();
                if (ProcessAction.isolationCheck(type.getType(), user)) continue;
                iterator.remove();
            }
            log.debug("after isolation: {}, result: {}", isolation, result);
        }
        return result;
    }

    private static boolean isolationCheck(ProcessType type, User user) {
        boolean result;
        boolean bl = result = !CollectionUtils.intersection(type.getProperties().getAllowedGroups().getGroupIds(), user.getGroupIds()).isEmpty() || !CollectionUtils.intersection((Iterable)type.getProperties().getGroups(), user.getGroupIds()).isEmpty();
        if (result) {
            return true;
        }
        for (ProcessType child : type.getChildren()) {
            if (!ProcessAction.isolationCheck(child, user)) continue;
            return true;
        }
        return false;
    }

    public ActionForward processCreateGroups(DynActionForm form, Connection con) {
        int typeId = form.getParamInt("typeId", 0);
        ProcessType type = ProcessTypeCache.getProcessType(typeId);
        if (type != null) {
            ArrayList<Group> groups = new ArrayList<Group>();
            for (int groupId : Utils.toIntegerSet(type.getProperties().getConfigMap().get("onCreateSelectGroup"))) {
                groups.add(UserCache.getUserGroup(groupId));
            }
            form.setResponseData("groups", groups);
        }
        return this.html(con, form, "/WEB-INF/jspf/user/process/tree/group_select.jsp");
    }

    public static Process processCreateAndGet(DynActionForm form, Connection con) throws Exception {
        Process process = new Process();
        process.setTypeId(Utils.parseInt(form.getParam("typeId")));
        process.setDescription(Utils.maskNull(form.getParam("description")));
        ProcessAction.processCreate(form, con, process, form.getParamInt("groupId", 0));
        return process;
    }

    public static void processCreate(DynActionForm form, Connection con, Process process) throws Exception {
        ProcessAction.processCreate(form, con, process, -1);
    }

    public static void processCreate(DynActionForm form, Connection con, Process process, int groupId) throws Exception {
        ProcessDAO processDAO = new ProcessDAO(con);
        StatusChangeDAO changeDao = new StatusChangeDAO(con);
        ProcessType type = ProcessTypeCache.getProcessTypeOrThrow(process.getTypeId());
        TypeProperties typeProperties = type.getProperties();
        process.setStatusId(0);
        process.setCreateUserId(form.getUser().getId());
        processDAO.updateProcess(process);
        StatusChange change = new StatusChange();
        change.setDate(new Date());
        change.setProcessId(process.getId());
        change.setUserId(form.getUserId());
        change.setComment(form.l.l("\u041f\u0440\u043e\u0446\u0435\u0441\u0441 \u0441\u043e\u0437\u0434\u0430\u043d", new Object[0]));
        change.setStatusId(type.getProperties().getCreateStatusId());
        if (!ProcessTypeCache.getStatusMap().containsKey(change.getStatusId())) {
            throw new BGException("No initial status defined for the process type", new Object[0]);
        }
        changeDao.changeStatus(process, type, change);
        if (groupId > 0) {
            ProcessGroups processGroups = new ProcessGroups();
            processGroups.add(new ProcessGroup(groupId, 0));
            process.setGroups(processGroups);
        } else {
            process.setGroups(new ProcessGroups(typeProperties.getGroups()));
        }
        processDAO.updateProcessGroups(process.getGroups(), process.getId());
        if (form.getParamBoolean("wizard", true).booleanValue()) {
            ProcessAction.doCreateWizard(form, con, process, type);
        }
        EventProcessor.processEvent(new ProcessChangedEvent(form, process, 1), new SingleConnectionSet(con));
        form.setResponseData("process", process);
    }

    protected static void doCreateWizard(DynActionForm form, Connection con, Process process, ProcessType type) throws SQLException {
        Wizard wizard = type.getProperties().getWizard();
        if (wizard != null && !wizard.getCreateStepList().isEmpty()) {
            new ProcessDAO(con).processIdInvert(process);
            TemporaryObjectOpenListener.flushUserData(form.getUserId());
        }
    }

    public ActionForward processCreate(DynActionForm form, Connection con) throws Exception {
        ProcessAction.processCreateAndGet(form, con);
        return this.json(con, form);
    }

    public ActionForward processClone(DynActionForm form, Connection con) throws Exception {
        Process process = new ProcessCloneDAO(con, form).withParams(true).clone(form.getId());
        form.setResponseData("process", process);
        return this.json(con, form);
    }

    public ActionForward processDeleteTmp(DynActionForm form, Connection con) throws Exception {
        ProcessDAO processDao = new ProcessDAO(con);
        if (form.getId() > 0) {
            throw new BGIllegalArgumentException();
        }
        Process process = this.getProcess(processDao, form.getId());
        processDao.deleteProcess(process.getId());
        TemporaryObjectOpenListener.flushUserData(form.getUserId());
        return this.json(con, form);
    }

    public ActionForward processDelete(DynActionForm form, Connection con) throws Exception {
        Process process = this.getProcess(new ProcessDAO(con), form.getId());
        ProcessAction.processDelete(form, con, process);
        return this.json(con, form);
    }

    public static void processDelete(DynActionForm form, Connection con, Process process) throws Exception {
        new ProcessDAO(con).deleteProcess(process.getId());
        ProcessAction.processDoEvent(form, process, new ProcessRemovedEvent(form, process), con);
    }

    public ActionForward processFinishCreateTmp(DynActionForm form, Connection con) throws Exception {
        ProcessDAO processDao = new ProcessDAO(con);
        Process process = this.getProcess(processDao, form.getId());
        processDao.processIdInvert(process);
        EventProcessor.processEvent(new ProcessChangedEvent(form, process, 10), new SingleConnectionSet(con));
        TemporaryObjectOpenListener.flushUserData(form.getUserId());
        return this.json(con, form);
    }

    public ActionForward processDoCommands(DynActionForm form, Connection con) throws Exception {
        Process process = this.getProcess(new ProcessDAO(con), form.getId());
        List<String> commands = Utils.toList(form.getParam("commands"), ";");
        if (commands.size() == 0) {
            throw new BGException("\u041f\u0443\u0441\u0442\u043e\u0439 \u0441\u043f\u0438\u0441\u043e\u043a \u043a\u043e\u043c\u0430\u043d\u0434", new Object[0]);
        }
        ProcessCommandExecutor.processDoCommands(con, form, process, null, commands);
        return this.json(con, form);
    }

    public ActionForward processStatusEdit(DynActionForm form, Connection con) throws Exception {
        Process process = this.getProcess(new ProcessDAO(con), form.getId());
        form.setResponseData("process", process);
        return this.html(con, form, "/WEB-INF/jspf/user/process/process/editor_status.jsp");
    }

    public ActionForward processStatusUpdate(DynActionForm form, Connection con) throws Exception {
        Process process = this.getProcess(new ProcessDAO(con), form.getId());
        int statusId = Utils.parseInt(form.getParam("statusId"));
        if ("prev".equals(form.getParam("statusId"))) {
            Pageable<StatusChange> searchResult = new Pageable<StatusChange>();
            new StatusChangeDAO(con).searchProcessStatus(searchResult, process.getId(), null);
            if (searchResult.getList().size() < 2) {
                throw new BGMessageException("\u0423 \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u0430 \u043d\u0435 \u0431\u044b\u043b\u043e \u043f\u0440\u0435\u0434\u044b\u0434\u0443\u0449\u0435\u0433\u043e \u0441\u0442\u0430\u0442\u0443\u0441\u0430.", new Object[0]);
            }
            statusId = searchResult.getList().get(1).getStatusId();
        }
        StatusChange change = new StatusChange();
        change.setDate(new Date());
        change.setProcessId(process.getId());
        change.setStatusId(statusId);
        change.setUserId(form.getUserId());
        change.setComment(form.getParam("comment", ""));
        ProcessAction.processStatusUpdate(form, con, process, change);
        return this.json(con, form);
    }

    public static void processStatusUpdate(DynActionForm form, Connection con, Process process, StatusChange change) throws Exception {
        Set<Integer> requireStatusChangeComment;
        StatusChangeDAO changeDao = new StatusChangeDAO(con, form);
        ProcessType type = ProcessAction.getProcessType(process.getTypeId());
        String requireParamName = "requireFillParamIdsBeforeStatusSet." + change.getStatusId();
        if (Utils.isBlankString(change.getComment()) && (requireStatusChangeComment = Utils.toIntegerSet(type.getProperties().getConfigMap().get("requireChangeCommentStatusIds", ""))).contains(change.getStatusId())) {
            throw new BGMessageException("\u041f\u0435\u0440\u0435\u0432\u043e\u0434 \u0432 \u0434\u0430\u043d\u043d\u044b\u0439 \u0441\u0442\u0430\u0442\u0443\u0441 \u043e\u0431\u044f\u0437\u0430\u043d \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u043a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439.", new Object[0]);
        }
        ParamValueDAO paramValueDao = new ParamValueDAO(con);
        Set<Integer> requireBeforeParams = Utils.toIntegerSet(type.getProperties().getConfigMap().get(requireParamName, ""));
        for (int requireParamId : requireBeforeParams) {
            Parameter requireParam = ParameterCache.getParameter(requireParamId);
            if (requireParam == null) {
                throw new BGMessageException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0441 \u043a\u043e\u0434\u043e\u043c " + requireParamId + " \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442.\n\u0423\u043a\u0430\u0437\u0430\u043d \u0432 " + requireParamName + " \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u0442\u0438\u043f\u0430 \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u0430.", new Object[0]);
            }
            if (!paramValueDao.isParameterFilled(process.getId(), requireParam)) {
                throw new BGMessageException("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 '" + requireParam.getTitle() + "' \u043d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d.", new Object[0]);
            }
            EventProcessor.processEvent(new ProcessChangingEvent(form, process, change, 1), new SingleConnectionSet(con));
        }
        ProcessAction.processDoEvent(form, process, new ProcessChangingEvent(form, process, change, 1), con);
        TransactionProperties transactionProperties = type.getProperties().getTransactionProperties(process.getStatusId(), change.getStatusId());
        if (process.getStatusId() != 0 && !transactionProperties.isEnable()) {
            throw new BGMessageException("\u041f\u0435\u0440\u0435\u0445\u043e\u0434 \u0441\u043e \u0441\u0442\u0430\u0442\u0443\u0441\u0430 {} \u043d\u0430 \u0441\u0442\u0430\u0442\u0443\u0441 {} \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d", process.getStatusId(), change.getStatusId());
        }
        changeDao.changeStatus(process, type, change);
        process.setStatusChange(change);
        ProcessAction.processDoEvent(form, process, new ProcessChangedEvent(form, process, 2), con);
    }

    public ActionForward processStatusHistory(DynActionForm form, Connection con) throws Exception {
        new StatusChangeDAO(con).searchProcessStatus(new Pageable<StatusChange>(form), form.getId(), form.getParamValues("statusId"));
        return this.html(con, form, "/WEB-INF/jspf/user/process/process/status_history.jsp");
    }

    public ActionForward processPriorityEdit(DynActionForm form, ConnectionSet conSet) {
        form.setRequestAttribute("config", this.setup.getConfig(ProcessPriorityConfig.class));
        return this.html(conSet, form, "/WEB-INF/jspf/user/process/process/editor_priority.jsp");
    }

    public ActionForward processPriorityUpdate(DynActionForm form, Connection con) throws Exception {
        ProcessDAO processDAO = new ProcessDAO(con, form);
        Process process = this.getProcess(processDAO, form.getId());
        int priority = Utils.parseInt(form.getParam("priority"));
        ProcessAction.processPriorityUpdate(form, process, con, priority);
        return this.json(con, form);
    }

    public static void processPriorityUpdate(DynActionForm form, Process process, Connection con, Integer priority) throws Exception {
        ProcessDAO processDAO = new ProcessDAO(con, form);
        ProcessAction.processDoEvent(form, process, new ProcessChangingEvent(form, process, priority, 4), con);
        process.setPriority(priority);
        processDAO.updateProcess(process);
        ProcessAction.processDoEvent(form, process, new ProcessChangedEvent(form, process, 5), con);
    }

    public ActionForward processTypeEdit(DynActionForm form, Connection con) {
        form.setRequestAttribute("typeTreeRoot", ProcessTypeCache.getTypeTreeRoot());
        return this.html(con, form, "/WEB-INF/jspf/user/process/process/editor_type.jsp");
    }

    public ActionForward processTypeUpdate(DynActionForm form, Connection con) throws Exception {
        ProcessDAO processDAO = new ProcessDAO(con, form);
        Process process = this.getProcess(processDAO, form.getId());
        int typeId = form.getParamInt("typeId", Utils::isPositive);
        ProcessAction.processTypeUpdate(form, process, con, typeId);
        return this.json(con, form);
    }

    private static void processTypeUpdate(DynActionForm form, Process process, Connection con, Integer typeId) throws Exception {
        ProcessDAO processDAO = new ProcessDAO(con, form);
        ProcessAction.processDoEvent(form, process, new ProcessChangingEvent(form, process, typeId, 7), con);
        process.setTypeId(typeId);
        processDAO.updateProcess(process);
        ProcessAction.processDoEvent(form, process, new ProcessChangedEvent(form, process, 9), con);
    }

    public ActionForward processDescriptionUpdate(DynActionForm form, Connection con) throws Exception {
        ProcessDAO processDAO = new ProcessDAO(con, form);
        Process process = this.getProcess(processDAO, form.getId());
        String description = form.getParam("description");
        ProcessAction.processDoEvent(form, process, new ProcessChangingEvent(form, process, description, 2), con);
        process.setDescription(description);
        processDAO.updateProcess(process);
        ProcessAction.processDoEvent(form, process, new ProcessChangedEvent(form, process, 3), con);
        return this.json(con, form);
    }

    public ActionForward processDescriptionAdd(DynActionForm form, Connection con) throws Exception {
        ProcessDAO processDAO = new ProcessDAO(con, form);
        Process process = this.getProcess(processDAO, form.getId());
        String description = form.getParam("description");
        if (Utils.isBlankString(description)) {
            throw new BGIllegalArgumentException();
        }
        ProcessType type = ProcessAction.getProcessType(process.getTypeId());
        Object pattern = type.getProperties().getConfigMap().get("descriptionAddPattern", "(${description}\n)(${text})\t[(${time}) (${user})]");
        String timePattern = type.getProperties().getConfigMap().get("descriptionAddPattern.timePattern", "ymdhms");
        if (!((String)pattern).contains("${description}")) {
            pattern = "(${description}\n)" + (String)pattern;
        }
        pattern = ((String)pattern).replaceAll("\\\\n", "\n").replaceAll("\\\\t", "\t");
        String newDescription = PatternFormatter.processPattern((String)pattern, variable -> {
            if ("time".equals(variable)) {
                return TimeUtils.format(new Date(), timePattern);
            }
            if ("user".equals(variable)) {
                return form.getUser().getTitle();
            }
            if ("text".equals(variable)) {
                return description;
            }
            if ("description".equals(variable)) {
                return process.getDescription();
            }
            return "";
        });
        ProcessAction.processDoEvent(form, process, new ProcessChangingEvent(form, process, description, 6), con);
        process.setDescription(newDescription);
        processDAO.updateProcess(process);
        ProcessAction.processDoEvent(form, process, new ProcessChangedEvent(form, process, 8), con);
        return this.json(con, form);
    }

    public ActionForward processGroupsEdit(DynActionForm form, Connection con) throws Exception {
        form.setResponseData("process", this.getProcess(new ProcessDAO(con), form.getId()));
        return this.html(con, form, "/WEB-INF/jspf/user/process/process/editor_groups_with_roles.jsp");
    }

    public ActionForward processGroupsUpdate(DynActionForm form, Connection con) throws Exception {
        ProcessDAO processDao = new ProcessDAO(con, form);
        Process process = this.getProcess(processDao, form.getId());
        ProcessGroups allowedGroups = ProcessTypeCache.getProcessType(process.getTypeId()).getProperties().getAllowedGroups();
        Set<String> groupRoleSet = form.getParamValuesStr("groupRole");
        LinkedHashSet<ProcessGroup> processGroupList = new LinkedHashSet<ProcessGroup>();
        for (String string : groupRoleSet) {
            ProcessGroup processGroup = new ProcessGroup();
            if (string.indexOf(":") > -1) {
                processGroup.setGroupId(Utils.parseInt(StringUtils.substringBefore((String)string, (String)":")));
                processGroup.setRoleId(Utils.parseInt(StringUtils.substringAfter((String)string, (String)":")));
            } else {
                processGroup.setGroupId(Integer.parseInt(string));
            }
            processGroupList.add(processGroup);
        }
        if (allowedGroups.size() > 0) {
            for (ProcessGroup processGroup : processGroupList) {
                boolean exist = false;
                for (ProcessGroup allowedItem : allowedGroups) {
                    if (processGroup.getGroupId() != allowedItem.getGroupId() || processGroup.getRoleId() != allowedItem.getRoleId()) continue;
                    exist = true;
                    break;
                }
                if (exist) continue;
                throw new BGMessageException("Forbidden to add group {} with role {}", UserCache.getUserGroup(processGroup.getGroupId()).getTitle(), processGroup.getRoleId());
            }
        }
        ProcessAction.processGroupsUpdate(form, con, process, processGroupList);
        return this.json(con, form);
    }

    public static void processGroupsUpdate(DynActionForm form, Connection con, Process process, Set<ProcessGroup> processGroups) throws Exception {
        ProcessDAO processDao = new ProcessDAO(con, form);
        ProcessAction.processDoEvent(form, process, new ProcessChangingEvent(form, process, processGroups, 5), con);
        process.setGroups(new ProcessGroups(processGroups));
        processDao.updateProcessGroups(processGroups, process.getId());
        boolean updated = false;
        Set<ProcessExecutor> processExecutors = process.getExecutors();
        Iterator<ProcessExecutor> processExecutorsIt = processExecutors.iterator();
        Log log = Log.getLog(ProcessAction.class);
        while (processExecutorsIt.hasNext()) {
            ProcessExecutor executor = processExecutorsIt.next();
            if (processGroups.contains(new ProcessGroup(executor.getGroupId(), executor.getRoleId()))) continue;
            log.debug("Removing executorId: " + executor.getUserId() + "; groupId:" + executor.getGroupId() + "; roleId: " + executor.getRoleId(), new Object[0]);
            processExecutorsIt.remove();
            updated = true;
        }
        if (updated) {
            processDao.updateProcessExecutors(processExecutors, process.getId());
        }
        ProcessAction.processDoEvent(form, process, new ProcessChangedEvent(form, process, 7), con);
    }

    public ActionForward processExecutorsEdit(DynActionForm form, ConnectionSet conSet) throws Exception {
        Process process = this.getProcess(new ProcessDAO(conSet.getConnection()), form.getId());
        ArrayList<Pair<IdStringTitle, Object[]>> groupsWithRoles = new ArrayList<Pair<IdStringTitle, Object[]>>();
        form.setResponseData("groupsWithRoles", groupsWithRoles);
        Set<Integer> allowedGroups = Utils.toIntegerSet(form.getPermission().get("allowOnlyGroups"));
        for (IdTitle role : UserGroupRoleCache.getUserGroupRoleList()) {
            Set<Integer> groupIdsWithRole = process.getGroupIdsWithRole(role.getId());
            if (groupIdsWithRole.isEmpty()) continue;
            for (Group group : UserCache.getUserGroupFullTitledList()) {
                ArrayList<IdStringTitle> list;
                if (!groupIdsWithRole.contains(group.getId()) || !allowedGroups.isEmpty() && !allowedGroups.contains(group.getId())) continue;
                Object[] listAndValues = new Object[2];
                groupsWithRoles.add(new Pair<IdStringTitle, Object[]>(new IdStringTitle(group.getId() + ":" + role.getId(), group.getTitle() + (String)(role.getId() != 0 ? " (" + role.getTitle() + ")" : "")), listAndValues));
                listAndValues[0] = list = new ArrayList<IdStringTitle>();
                IdStringTitle meItem = null;
                for (User user : UserCache.getUserList()) {
                    if (!user.getGroupIds().contains(group.getId()) || user.getStatus() != 0) continue;
                    String userGroupAndRole = user.getId() + ":" + group.getId() + ":" + role.getId();
                    if (user.getId().intValue() == form.getUserId()) {
                        meItem = new IdStringTitle(userGroupAndRole, user.getTitle() + " " + this.l.l("[you]", new Object[0]));
                        continue;
                    }
                    list.add(new IdStringTitle(userGroupAndRole, user.getTitle()));
                }
                if (meItem != null) {
                    list.add(0, meItem);
                }
                listAndValues[1] = process.getExecutors().stream().map(pe -> pe.getUserId() + ":" + pe.getGroupId() + ":" + pe.getRoleId()).collect(Collectors.toSet());
            }
        }
        return this.html(conSet, form, "/WEB-INF/jspf/user/process/process/editor_executors.jsp");
    }

    public ActionForward processExecutorsUpdate(DynActionForm form, Connection con) throws Exception {
        Process process = this.getProcess(new ProcessDAO(con, form), form.getId());
        Set<ProcessGroup> updateGroups = ProcessGroup.parseFromStringSet(form.getParamValuesStr("group"));
        Set<ProcessExecutor> executors = ProcessExecutor.parseUnsafe(form.getParamValuesStr("executor"), updateGroups);
        ProcessAction.processExecutorsUpdate(form, con, process, updateGroups, executors);
        return this.json(con, form);
    }

    public ActionForward processExecutorsSwap(DynActionForm form, Connection con) throws Exception {
        ProcessDAO dao = new ProcessDAO(con, form);
        Process process = this.getProcess(dao, form.getId());
        ProcessGroups groups = process.getGroups();
        if (groups.size() != 2) {
            throw new BGMessageException("Swap operation is possible only with two groups", new Object[0]);
        }
        Iterator it = groups.iterator();
        ProcessGroup groupId1 = (ProcessGroup)it.next();
        ProcessGroup groupId2 = (ProcessGroup)it.next();
        for (ProcessExecutor pe : process.getExecutors()) {
            if (pe.getGroupId() == groupId1.getGroupId() && pe.getRoleId() == groupId1.getRoleId()) {
                pe.setGroupId(groupId2.getGroupId());
                pe.setRoleId(groupId2.getRoleId());
                continue;
            }
            pe.setGroupId(groupId1.getGroupId());
            pe.setRoleId(groupId1.getRoleId());
        }
        dao.updateProcessExecutors(process.getExecutors(), form.getId());
        return this.json(con, form);
    }

    public static void processExecutorsUpdate(DynActionForm form, Connection con, Process process, Set<ProcessGroup> processGroups, Set<ProcessExecutor> processExecutors) throws Exception {
        Collection changingExecutorIds;
        Object denyUserIds;
        Collection denyGroupIds;
        ProcessDAO processDao = new ProcessDAO(con, form);
        ConfigMap perm = form.getPermission();
        Set<Integer> allowOnlyGroupIds = Utils.toIntegerSet(perm.get("allowOnlyGroups"));
        if (allowOnlyGroupIds.size() != 0 && (denyGroupIds = CollectionUtils.subtract(ProcessGroup.toGroupSet(processGroups), allowOnlyGroupIds)).size() > 0) {
            throw new BGMessageException("\u0417\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u0430 \u043f\u0440\u0430\u0432\u043a\u0430 \u0438\u0441\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u0435\u0439 \u0432 \u0433\u0440\u0443\u043f\u043f\u0430\u0445:\n" + String.valueOf(Utils.getObjectList(UserCache.getUserGroupList(), new HashSet<Integer>(denyGroupIds))), new Object[0]);
        }
        ProcessAction.checkExecutorRestriction(process);
        Set<Integer> allowOnlyUsers = Utils.toIntegerSet(perm.get("allowOnlyUsers"));
        if (allowOnlyUsers.size() > 0 && (denyUserIds = CollectionUtils.subtract((Iterable)(changingExecutorIds = CollectionUtils.disjunction(process.getExecutorIds(), ProcessExecutor.toExecutorSet(processExecutors))), allowOnlyUsers)).size() > 0) {
            throw new BGMessageException("\u0417\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u0430 \u043f\u0440\u0430\u0432\u043a\u0430 \u0438\u0441\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u0435\u0439:\n" + String.valueOf(Utils.getObjectList(UserCache.getUserList(), new HashSet<Integer>((Collection<Integer>)denyUserIds))), new Object[0]);
        }
        Set<Integer> allowOnlyProcessTypeIds = Utils.toIntegerSet(perm.get("allowOnlyProcessTypeIds"));
        if (allowOnlyProcessTypeIds.size() > 0 && !CollectionUtils.containsAny(allowOnlyProcessTypeIds, Arrays.asList(process.getTypeId()))) {
            throw new BGMessageException("\u0417\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u0430 \u043f\u0440\u0430\u0432\u043a\u0430 \u0438\u0441\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u0435\u0439 \u0443 \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u0442\u0438\u043f\u0430 \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u0430!", new Object[0]);
        }
        for (ProcessGroup processGroup : processGroups) {
            if (processGroup.getGroupId() <= 0) continue;
            Group group = UserCache.getUserGroup(processGroup.getGroupId());
            if (group == null) {
                throw new BGException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0433\u0440\u0443\u043f\u043f\u0430 \u0441 \u043a\u043e\u0434\u043e\u043c: " + processGroup.getGroupId(), new Object[0]);
            }
            if (process.getGroups().contains(processGroup)) continue;
            throw new BGMessageException("\u0413\u0440\u0443\u043f\u043f\u0430: " + group.getTitle() + " \u0441 \u0440\u043e\u043b\u044c\u044e: " + processGroup.getRoleId() + " \u043d\u0435 \u0443\u0447\u0430\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u0435.", new Object[0]);
        }
        LinkedHashSet<ProcessExecutor> executors = new LinkedHashSet<ProcessExecutor>(process.getExecutors());
        Iterator currentExecutorsIt = executors.iterator();
        while (currentExecutorsIt.hasNext()) {
            ProcessExecutor executor = (ProcessExecutor)currentExecutorsIt.next();
            if (!processGroups.contains(new ProcessGroup(executor.getGroupId(), executor.getRoleId()))) continue;
            currentExecutorsIt.remove();
        }
        executors.addAll(processExecutors);
        ProcessAction.processDoEvent(form, process, new ProcessChangingEvent(form, process, executors, 3), con);
        process.setExecutors(executors);
        processDao.updateProcessExecutors(executors, process.getId());
        ProcessAction.processDoEvent(form, process, new ProcessChangedEvent(form, process, 4), con);
    }

    private static void checkExecutorRestriction(Process process) throws BGMessageException {
        Set<Integer> executorIds = process.getExecutorIds();
        ProcessType processType = ProcessTypeCache.getProcessType(process.getTypeId());
        for (Map.Entry<Integer, ConfigMap> entry : processType.getProperties().getConfigMap().subIndexed("executorRestriction.").entrySet()) {
            ConfigMap paramMap = entry.getValue();
            int groupId = paramMap.getInt("groupId", 0);
            int maxCount = paramMap.getInt("maxCount", 0);
            if (groupId <= 0 || maxCount <= 0) continue;
            int count = 0;
            List<User> userList = UserCache.getUserList(new HashSet<Integer>(Arrays.asList(groupId)));
            for (Integer executorId : executorIds) {
                User executor = UserCache.getUser(executorId);
                if (!userList.contains(executor) || ++count <= maxCount) continue;
                Group group = UserCache.getUserGroup(groupId);
                StringBuilder sb = new StringBuilder();
                sb.append("\u041c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0438\u0441\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u0435\u0439 \u0434\u043b\u044f \u0433\u0440\u0443\u043f\u043f\u044b\"");
                sb.append(group.getTitle());
                sb.append("\" \u0440\u0430\u0432\u043d\u043e ");
                sb.append(maxCount);
                sb.append(".");
                throw new BGMessageException(sb.toString(), new Object[0]);
            }
        }
    }

    private static void processDoEvent(DynActionForm form, Process process, UserEvent event, Connection con) throws Exception {
        ProcessType type = ProcessTypeCache.getProcessType(process.getTypeId());
        if (type != null) {
            EventProcessor.processEvent(event, new SingleConnectionSet(con));
        }
    }

    protected Process getProcess(ProcessDAO processDao, int id) throws SQLException, BGMessageException {
        Process process = processDao.getProcess(id);
        if (process == null) {
            throw new BGMessageException("\u041f\u0440\u043e\u0446\u0435\u0441\u0441 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d.", new Object[0]);
        }
        return process;
    }

    public static ProcessType getProcessType(int typeId) throws BGMessageException {
        ProcessType type = ProcessTypeCache.getProcessType(typeId);
        if (type == null) {
            throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0442\u0438\u043f \u043f\u0440\u043e\u0446\u0435\u0441\u0441\u0430: {}", typeId);
        }
        return type;
    }

    public ActionForward messagePossibleProcessList(DynActionForm form, ConnectionSet conSet) throws Exception {
        this.restoreRequestParams(conSet.getConnection(), form, true, true, "open");
        String addressFrom = form.getParam("from");
        Boolean open = form.getParamBoolean("open", null);
        Iterator<String> linkObjectTypeIt = form.getParamValuesListStr("linkObjectType").iterator();
        Iterator<Integer> linkObjectIdIt = form.getParamValuesList("linkObjectId").iterator();
        ArrayList<ProcessLink> objects = new ArrayList<ProcessLink>();
        while (linkObjectTypeIt.hasNext()) {
            objects.add(new ProcessLink(0, linkObjectTypeIt.next(), linkObjectIdIt.next(), ""));
        }
        Pageable<Pair<Process, MessagePossibleProcessSearch>> processSearchResult = new Pageable<Pair<Process, MessagePossibleProcessSearch>>(form);
        new ProcessMessageDAO(conSet.getConnection(), form).searchProcessListForMessage(processSearchResult, addressFrom, objects, open);
        return this.html(conSet, form, "/WEB-INF/jspf/user/process/message_possible_process_list.jsp");
    }

    public ActionForward unionLog(DynActionForm form, Connection con) throws Exception {
        new ProcessLogDAO(con).searchProcessLog(form.l, ProcessAction.getProcessType(this.getProcess(new ProcessDAO(con), form.getId()).getTypeId()), form.getId(), new Pageable<EntityLogItem>(form));
        return this.html(con, form, "/WEB-INF/jspf/union_log.jsp");
    }

    public ActionForward userProcessList(DynActionForm form, ConnectionSet conSet) throws Exception {
        this.restoreRequestParams(conSet.getConnection(), form, true, true, "open");
        ((ProcessSearchDAO)((ProcessSearchDAO)new ProcessSearchDAO(conSet.getSlaveConnection(), form).withOpen(form.getParamBoolean("open", null)).withType((Set)form.getParamValues("typeId"))).withExecutor((Set)Set.of(Integer.valueOf(form.getUserId())))).order(Order.CREATE_DT_DESC).search(new Pageable<Process>(form));
        Pageable<Process> processes = new Pageable().withoutPagination();
        ((ProcessSearchDAO)new ProcessSearchDAO(conSet.getSlaveConnection(), form).withExecutor((Set)Set.of(Integer.valueOf(form.getUserId())))).search(processes);
        form.setResponseData("types", this.processTypes(processes.getList()));
        return this.html(conSet, form, "/WEB-INF/jspf/user/process/user_process_list.jsp");
    }

    protected List<IdTitle> processTypes(Collection<Process> processes) {
        return processes.stream().map(Process::getTypeId).collect(Collectors.groupingBy(Functions.identity(), Collectors.counting())).entrySet().stream().sorted((me1, me2) -> ((Long)me2.getValue()).compareTo((Long)me1.getValue())).map(me -> new IdTitle((Integer)me.getKey(), ProcessTypeCache.getProcessTypeSafe((Integer)me.getKey()).getTypeTitle() + " (" + String.valueOf(me.getValue()) + ")")).toList();
    }

    public ActionForward processMergeEdit(DynActionForm form, ConnectionSet conSet) throws Exception {
        return this.html(conSet, form, "/WEB-INF/jspf/user/process/process/editor_merge.jsp");
    }

    public ActionForward processMerge(DynActionForm form, Connection con) throws Exception {
        ProcessDAO processDao = new ProcessDAO(con);
        MessageDAO messageDao = new MessageDAO(con);
        Process process = this.getProcess(processDao, form.getId());
        Process processTo = this.getProcess(processDao, form.getParamInt("processId"));
        String mergeText = this.l.l("Merged from: {}\n", process.getId());
        for (Message m : messageDao.getProcessMessageList(process.getId(), 0)) {
            m.setText(mergeText + m.getText());
            m.setProcessId(processTo.getId());
            messageDao.updateMessage(m);
        }
        MessageTypeConfig typeConfig = this.setup.getConfig(MessageTypeConfig.class);
        MessageTypeNote noteMessage = typeConfig.getMessageType(MessageTypeNote.class);
        if (noteMessage != null) {
            Message m = new Message();
            m.setTypeId(noteMessage.getId());
            m.setProcessId(processTo.getId());
            m.setText(mergeText + process.getDescription());
            m.setFromTime(new Date());
            m.setUserId(form.getUserId());
            m.setToTime(new Date());
            m.setFrom("");
            m.setTo("");
            messageDao.updateMessage(m);
            ProcessAction.processDoEvent(form, processTo, new ProcessMessageAddedEvent(form, m, processTo), con);
        }
        processDao.deleteProcess(process.getId());
        ProcessAction.processDoEvent(form, process, new ProcessRemovedEvent(form, process), con);
        return this.json(con, form);
    }
}

