/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling.proto.struts.action;

import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import org.apache.struts.action.ActionForward;
import org.bgerp.app.exception.BGException;
import org.bgerp.app.exception.BGIllegalArgumentException;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.app.exception.BGMessageExceptionWithoutL10n;
import org.bgerp.model.Pageable;
import org.bgerp.model.base.Id;
import org.bgerp.model.base.IdTitle;
import ru.bgcrm.dao.AddressDAO;
import ru.bgcrm.model.Pair;
import ru.bgcrm.model.ParamList;
import ru.bgcrm.model.param.ParameterAddressValue;
import ru.bgcrm.model.param.ParameterEmailValue;
import ru.bgcrm.model.param.ParameterPhoneValue;
import ru.bgcrm.model.param.ParameterPhoneValueItem;
import ru.bgcrm.model.param.ParameterSearchedObject;
import ru.bgcrm.model.param.address.AddressHouse;
import ru.bgcrm.model.user.User;
import ru.bgcrm.plugin.bgbilling.proto.dao.ContractDAO;
import ru.bgcrm.plugin.bgbilling.proto.dao.ContractHierarchyDAO;
import ru.bgcrm.plugin.bgbilling.proto.dao.ContractNoteDAO;
import ru.bgcrm.plugin.bgbilling.proto.dao.ContractObjectDAO;
import ru.bgcrm.plugin.bgbilling.proto.dao.ContractObjectParamDAO;
import ru.bgcrm.plugin.bgbilling.proto.dao.ContractParamDAO;
import ru.bgcrm.plugin.bgbilling.proto.dao.ContractScriptDAO;
import ru.bgcrm.plugin.bgbilling.proto.dao.ContractServiceDAO;
import ru.bgcrm.plugin.bgbilling.proto.dao.ContractStatusDAO;
import ru.bgcrm.plugin.bgbilling.proto.dao.DirectoryDAO;
import ru.bgcrm.plugin.bgbilling.proto.model.Contract;
import ru.bgcrm.plugin.bgbilling.proto.model.ContractFace;
import ru.bgcrm.plugin.bgbilling.proto.model.ContractMode;
import ru.bgcrm.plugin.bgbilling.proto.model.ContractObjectParameter;
import ru.bgcrm.plugin.bgbilling.proto.model.ContractParameter;
import ru.bgcrm.plugin.bgbilling.proto.model.ContractService;
import ru.bgcrm.plugin.bgbilling.proto.model.ParamAddressValue;
import ru.bgcrm.plugin.bgbilling.proto.model.limit.LimitChangeTask;
import ru.bgcrm.plugin.bgbilling.proto.model.limit.LimitLogItem;
import ru.bgcrm.plugin.bgbilling.proto.model.script.ContractScriptLogItem;
import ru.bgcrm.plugin.bgbilling.struts.action.BaseAction;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.struts.form.Response;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;

@ActionServlet.Action(path="/user/plugin/bgbilling/proto/contract")
public class ContractAction
extends BaseAction {
    private static final String PATH_JSP = "/WEB-INF/jspf/user/plugin/bgbilling";
    private static final String PATH_JSP_CONTRACT = "/WEB-INF/jspf/user/plugin/bgbilling/contract";

    public ActionForward searchContract(DynActionForm form, ConnectionSet conSet) throws Exception {
        Object searchBy = form.getParam("searchBy");
        String billingId = form.getParam("billingId");
        String searchBySuffix = form.getParam("searchBySuffix");
        if (Utils.notBlankString(searchBySuffix)) {
            searchBy = (String)searchBy + searchBySuffix;
        }
        boolean showClosed = form.getParamBoolean("show_closed", false);
        boolean showSub = form.getParamBoolean("show_sub", false);
        boolean showHidden = form.getParamBoolean("show_invisible", false);
        ContractDAO.SearchOptions searchOptions = new ContractDAO.SearchOptions(showHidden, showClosed, showSub);
        User user = form.getUser();
        if (Utils.notBlankString((String)searchBy)) {
            ContractDAO contractDAO = new ContractDAO(user, billingId);
            if ("address".equals(searchBy)) {
                Set<Integer> addressParamIds = Utils.toIntegerSet(this.setup.get("bgbilling:search.contract.param.address.paramIds"));
                Pageable<ParameterSearchedObject<Contract>> res = new Pageable<ParameterSearchedObject<Contract>>(form);
                contractDAO.searchContractByAddressParam(res, searchOptions, addressParamIds, form.getParamInt("streetId"), form.getParamInt("houseId"), form.getParam("house"), form.getParam("flat"), form.getParam("room"));
            } else if ("addressObject".equals(searchBy)) {
                Pageable<ParameterSearchedObject<Contract>> result = new Pageable<ParameterSearchedObject<Contract>>(form);
                contractDAO.searchContractByObjectAddressParam(result, searchOptions, null, form.getParamInt("streetId"), form.getParam("house"), form.getParam("flat"), form.getParam("room"));
            } else if ("id".equals(searchBy)) {
                Pageable result = new Pageable(form);
                Contract contract = contractDAO.getContractById(form.getParamInt("id"));
                if (contract != null) {
                    result.getList().add(new IdTitle(contract.getId(), contract.getTitle()));
                }
            } else if ("title".equals(searchBy) || "comment".equals(searchBy)) {
                Pageable<IdTitle> result = new Pageable<IdTitle>(form);
                contractDAO.searchContractByTitleComment(result, form.getParam("title"), form.getParam("comment"), searchOptions);
            } else if (((String)searchBy).equals("parameter_text")) {
                Pageable<Contract> result = new Pageable<Contract>(form);
                contractDAO.searchContractByTextParam(result, searchOptions, this.getParasmIdsSet(form), form.getParam("value"));
            } else if (((String)searchBy).equals("parameter_date")) {
                Pageable<Contract> result = new Pageable<Contract>(form);
                contractDAO.searchContractByDateParam(result, searchOptions, this.getParasmIdsSet(form), form.getParamDate("date_from"), form.getParamDate("date_to"));
            } else if (((String)searchBy).equals("parameter_phone")) {
                Pageable<Contract> result = new Pageable<Contract>(form);
                contractDAO.searchContractByPhoneParam(result, searchOptions, this.getParasmIdsSet(form), form.getParam("value"));
            }
        }
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/bgbilling/search_contract_result.jsp");
    }

    private Set<Integer> getParasmIdsSet(DynActionForm form) throws BGMessageException {
        String[] vals = form.getParam().getArray("paramIds");
        if (vals == null) {
            return this.getParamListImpl(form).stream().map(i -> i.getId()).collect(Collectors.toSet());
        }
        return Arrays.stream(vals).map(i -> Utils.parseInt(i, -1)).collect(Collectors.toSet());
    }

    public ActionForward parameterList(DynActionForm form, ConnectionSet conSet) throws Exception {
        String billingId = form.getParam("billingId");
        Integer contractId = form.getParamInt("contractId");
        ContractParamDAO paramDAO = new ContractParamDAO(form.getUser(), billingId);
        Pair<ParamList, List<ContractParameter>> parameterListWithDir = paramDAO.getParameterListWithDir(contractId, true, form.getParamBoolean("onlyFromGroup", false));
        Set<Integer> allowedParamIds = Utils.toIntegerSet(form.getPermission().get("parameterIds"));
        if (!allowedParamIds.isEmpty()) {
            parameterListWithDir.getSecond().removeIf(cp -> !allowedParamIds.contains(cp.getParamId()));
        }
        form.setResponseData("group", parameterListWithDir.getFirst());
        form.setResponseData("contractParameterList", parameterListWithDir.getSecond());
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/bgbilling/contract/parameter_list.jsp");
    }

    public ActionForward parameterGet(DynActionForm form, ConnectionSet conSet) throws Exception {
        String billingId = form.getParam("billingId");
        Integer contractId = form.getParamInt("contractId");
        Integer paramId = form.getParamInt("paramId");
        int paramType = form.getParamInt("paramType");
        ContractParamDAO paramDAO = new ContractParamDAO(form.getUser(), billingId);
        Response resp = form.getResponse();
        if (paramType <= 0) {
            throw new BGMessageExceptionWithoutL10n("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f", new Object[0]);
        }
        switch (paramType) {
            case 1: {
                break;
            }
            case 2: {
                ParameterAddressValue addressValue = ContractParamDAO.toCrmObject(paramDAO.getAddressParam(contractId, paramId), conSet.getConnection());
                if (addressValue != null) {
                    int houseId = addressValue.getHouseId();
                    AddressHouse house = new AddressDAO(conSet.getConnection()).getAddressHouse(houseId, true, true, true);
                    if (house != null) {
                        resp.setData("house", house);
                    }
                }
                resp.setData("address", addressValue);
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                resp.setData("value", paramDAO.getListParamValue(contractId, paramId));
                break;
            }
            case 9: {
                form.setResponseData("value", paramDAO.getPhoneParam(contractId, paramId));
                break;
            }
            case 3: {
                resp.setData("emails", paramDAO.getEmailParam(contractId, paramId));
                break;
            }
        }
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/bgbilling/contract/parameter_editor.jsp");
    }

    public ActionForward parameterUpdate(DynActionForm form, ConnectionSet conSet) throws BGMessageException {
        String billingId = form.getParam("billingId");
        int contractId = form.getParamInt("contractId");
        int paramBillingId = form.getParamInt("paramId");
        int parameterType = form.getParamInt("paramType");
        Set<Integer> allowedParamIds = Utils.toIntegerSet(form.getPermission().get("parameterIds"));
        if (!allowedParamIds.isEmpty() && !allowedParamIds.contains(paramBillingId)) {
            throw new BGMessageExceptionWithoutL10n("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0441 \u043a\u043e\u0434\u043e\u043c " + paramBillingId + " \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d \u0434\u043b\u044f \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f.", new Object[0]);
        }
        ContractParamDAO paramDAO = new ContractParamDAO(form.getUser(), billingId);
        switch (parameterType) {
            case 5: {
                paramDAO.updateFlagParameter(contractId, paramBillingId, form.getParamBoolean("value", false));
                break;
            }
            case 1: {
                paramDAO.updateTextParameter(contractId, paramBillingId, form.getParam("value"));
                break;
            }
            case 2: {
                ParamAddressValue address = new ParamAddressValue();
                address.setStreetId(form.getParamInt("streetId "));
                address.setHouseId(form.getParamInt("houseId"));
                address.setStreetTitle(form.getParam("streetTitle"));
                address.setHouse(form.getParam("house"));
                address.setFlat(form.getParam("flat"));
                address.setRoom(form.getParam("room "));
                address.setPod(form.getParam("pod"));
                address.setFloor(form.getParam("floor"));
                address.setComment(form.getParam("comment"));
                paramDAO.updateAddressParameter(contractId, paramBillingId, address);
                break;
            }
            case 6: {
                paramDAO.updateDateParameter(contractId, paramBillingId, form.getParam("value"));
                break;
            }
            case 7: {
                paramDAO.updateListParameter(contractId, paramBillingId, form.getParam("value"));
                break;
            }
            case 9: {
                ParameterPhoneValue phoneValue = new ParameterPhoneValue();
                Iterator<String> phones = form.getParamValuesListStr("phone").iterator();
                Iterator<String> comments = form.getParamValuesListStr("comment").iterator();
                while (phones.hasNext()) {
                    phoneValue.addItem(new ParameterPhoneValueItem(phones.next(), comments.next()));
                }
                paramDAO.updatePhoneParameter(contractId, paramBillingId, phoneValue);
                break;
            }
            case 3: {
                ArrayList<ParameterEmailValue> emails = new ArrayList<ParameterEmailValue>();
                List<String> strings = Utils.toList(form.getParam("emails"), "\n");
                if (strings.isEmpty()) {
                    Iterator<String> address = form.getParamValuesListStr("address").iterator();
                    Iterator<String> name = form.getParamValuesListStr("name").iterator();
                    while (address.hasNext()) {
                        emails.add(new ParameterEmailValue(address.next(), name.next()));
                    }
                } else {
                    for (String mail : strings) {
                        try {
                            InternetAddress addr = InternetAddress.parse((String)mail)[0];
                            emails.add(new ParameterEmailValue(addr.getAddress(), addr.getPersonal()));
                        }
                        catch (AddressException e) {
                            throw new BGException("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u0430\u0434\u0440\u0435\u0441: " + mail, e);
                        }
                    }
                }
                paramDAO.updateEmailParameter(contractId, paramBillingId, emails);
                break;
            }
        }
        return this.json(conSet, form);
    }

    public ActionForward parameterGroupUpdate(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        Integer contractId = form.getParamInt("contractId");
        int paramGroupId = form.getParamInt("paramGroupId");
        new ContractParamDAO(form.getUser(), billingId).updateParameterGroup(contractId, paramGroupId);
        return this.json(conSet, form);
    }

    public ActionForward additionalActionList(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        Integer contractId = form.getParamInt("contractId");
        ContractDAO crmDAO = new ContractDAO(form.getUser(), billingId);
        form.setResponseData("additionalActionList", crmDAO.additionalActionList(contractId));
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/bgbilling/contract/additional_action_list.jsp");
    }

    public ActionForward executeAdditionalAction(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        Integer contractId = form.getParamInt("contractId");
        Integer actionId = form.getParamInt("actionId");
        ContractDAO crmDAO = new ContractDAO(form.getUser(), billingId);
        form.setResponseData("executeResult", crmDAO.executeAdditionalAction(contractId, actionId));
        form.setResponseData("additionalActionList", crmDAO.additionalActionList(contractId));
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/bgbilling/contract/additional_action_list.jsp");
    }

    public ActionForward groupList(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        Integer contractId = form.getParamInt("contractId");
        Pair<List<IdTitle>, Set<Integer>> groupsGet = new ContractDAO(form.getUser(), billingId).groupsGet(contractId);
        form.setResponseData("groupList", groupsGet.getFirst());
        form.setResponseData("selectedGroupIds", groupsGet.getSecond());
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/bgbilling/contract/group_list.jsp");
    }

    public ActionForward updateGroups(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        Integer contractId = form.getParamInt("contractId");
        Set<Integer> groupIds = form.getParamValues("groupId");
        ContractDAO contractDao = new ContractDAO(form.getUser(), billingId);
        contractDao.updateLabels(contractId, groupIds);
        return this.json(conSet, form);
    }

    public ActionForward memoList(DynActionForm form, ConnectionSet conSet) throws Exception {
        String billingId = form.getParam("billingId");
        Integer contractId = form.getParamInt("contractId");
        form.setResponseData("list", new ContractNoteDAO(form.getUser(), billingId).list(contractId));
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/bgbilling/contract/note/list.jsp");
    }

    public ActionForward getMemo(DynActionForm form, ConnectionSet conSet) throws Exception {
        String billingId = form.getParam("billingId");
        Integer contractId = form.getParamInt("contractId");
        if (form.getId() > 0) {
            form.setResponseData("note", new ContractNoteDAO(form.getUser(), billingId).get(contractId, form.getId()));
        }
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/bgbilling/contract/note/edit.jsp");
    }

    public ActionForward updateMemo(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        Integer contractId = form.getParamInt("contractId");
        Integer memoId = form.getParamInt("id", 0);
        String memoTitle = form.getParam("title");
        String memoText = form.getParam("text");
        new ContractNoteDAO(form.getUser(), billingId).update(contractId, memoId, memoTitle, memoText);
        return this.json(conSet, form);
    }

    public ActionForward deleteMemo(DynActionForm form, ConnectionSet conSet) throws BGMessageException {
        String billingId = form.getParam("billingId");
        Integer contractId = form.getParamInt("contractId");
        Integer memoId = form.getParamInt("id", 0);
        if (memoId <= 0) {
            throw new BGIllegalArgumentException();
        }
        new ContractNoteDAO(form.getUser(), billingId).delete(contractId, memoId);
        return this.json(conSet, form);
    }

    public ActionForward contractObjectList(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        Integer contractId = form.getParamInt("contractId");
        ContractObjectDAO contractObjectDAO = new ContractObjectDAO(form.getUser(), billingId);
        form.setResponseData("objectList", contractObjectDAO.getContractObjects(contractId));
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/bgbilling/contract/object/object_list.jsp");
    }

    public ActionForward getContractObject(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        Integer contractId = form.getParamInt("contractId");
        Integer objectId = form.getParamInt("objectId");
        ContractObjectDAO contractObjectDAO = new ContractObjectDAO(form.getUser(), billingId);
        form.setResponseData("object", contractObjectDAO.getContractObject(contractId, objectId));
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/bgbilling/contract/object/object_editor.jsp");
    }

    public ActionForward deleteContractObject(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        Integer contractId = form.getParamInt("contractId");
        Integer objectId = form.getParamInt("objectId");
        ContractObjectDAO contractObjectDAO = new ContractObjectDAO(form.getUser(), billingId);
        contractObjectDAO.deleteContractObject(contractId, objectId);
        return this.json(conSet, form);
    }

    public ActionForward updateContractObject(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        int contractId = form.getParamInt("contractId");
        int objectId = form.getParamInt("objectId");
        int typeId = form.getParamInt("typeId");
        String title = form.getParam("title");
        Date dateFrom = form.getParamDate("dateFrom");
        Date dateTo = form.getParamDate("dateTo");
        ContractObjectDAO contractObjectDAO = new ContractObjectDAO(form.getUser(), billingId);
        contractObjectDAO.updateContractObject(contractId, objectId, typeId, title, dateFrom, dateTo);
        return this.json(conSet, form);
    }

    public ActionForward contractObjectParameterList(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        int contractId = form.getParamInt("contractId");
        Integer objectId = form.getParamInt("objectId");
        ContractObjectParamDAO paramDAO = new ContractObjectParamDAO(form.getUser(), billingId);
        form.setResponseData("parameterList", paramDAO.getParameterList(contractId, objectId));
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/bgbilling/contract/object/object_parameter_list.jsp");
    }

    public ActionForward getObjectParameter(DynActionForm form, ConnectionSet conSet) throws Exception {
        String billingId = form.getParam("billingId");
        int contractId = form.getParamInt("contractId");
        Integer objectId = form.getParamInt("objectId");
        Integer paramId = form.getParamInt("paramId");
        ContractObjectParamDAO paramDAO = new ContractObjectParamDAO(form.getUser(), billingId);
        ContractObjectParameter parameter = paramDAO.getParameter(contractId, objectId, paramId);
        form.setResponseData("parameter", parameter);
        int paramType = parameter.getTypeId();
        if (paramType <= 0) {
            throw new BGMessageExceptionWithoutL10n("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u043d\u0435 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f", new Object[0]);
        }
        switch (paramType) {
            case 1: {
                break;
            }
            case 4: {
                ParameterAddressValue addressValue = paramDAO.getAddressParam(objectId, paramId).toParameterAddressValue(conSet.getConnection());
                if (addressValue != null) {
                    int houseId = addressValue.getHouseId();
                    AddressHouse house = new AddressDAO(conSet.getConnection()).getAddressHouse(houseId, true, true, true);
                    if (house != null) {
                        form.setResponseData("house", house);
                    }
                }
                form.setResponseData("address", addressValue);
                break;
            }
            case 3: {
                if (!Utils.notBlankString(parameter.getValue())) break;
                form.setResponseData("dateValue", new SimpleDateFormat("yyyy-MM-dd").format(TimeUtils.parse(parameter.getValue(), "dd.MM.yyyy")));
                break;
            }
            case 2: {
                form.setResponseData("valueList", paramDAO.getListParam(objectId, paramId));
            }
        }
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/bgbilling/contract/object/object_parameter_editor.jsp");
    }

    public ActionForward updateObjectParameter(DynActionForm form, ConnectionSet conSet) throws Exception {
        String billingId = form.getParam("billingId");
        Integer objectId = form.getParamInt("objectId");
        Integer paramBillingId = form.getParamInt("paramId");
        Integer parameterType = form.getParamInt("paramType");
        Integer contractId = form.getParamInt("contractId");
        ContractObjectParamDAO paramDAO = new ContractObjectParamDAO(form.getUser(), billingId);
        switch (parameterType) {
            case 1: {
                paramDAO.updateTextParameter(contractId, objectId, paramBillingId, form.getParam("textValue"));
                break;
            }
            case 4: {
                ParamAddressValue address = new ParamAddressValue();
                address.setStreetId(form.getParamInt("streetId "));
                address.setHouseId(form.getParamInt("houseId"));
                address.setStreetTitle(form.getParam("streetTitle"));
                address.setHouse(form.getParam("house"));
                address.setFlat(form.getParam("flat"));
                address.setRoom(form.getParam("room "));
                address.setPod(form.getParam("pod"));
                address.setFloor(form.getParam("floor"));
                address.setComment(form.getParam("comment"));
                paramDAO.updateAddressParameter(contractId, objectId, paramBillingId, address);
                break;
            }
            case 3: {
                paramDAO.updateDateParameter(contractId, objectId, paramBillingId, form.getParam("dateValue"));
                break;
            }
            case 2: {
                paramDAO.updateListParameter(contractId, objectId, paramBillingId, form.getParam("listValueId"));
                break;
            }
        }
        return this.json(conSet, form);
    }

    public ActionForward contractObjectModuleInfo(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        Integer objectId = form.getParamInt("objectId");
        ContractObjectDAO dao = new ContractObjectDAO(form.getUser(), billingId);
        form.setResponseData("moduleInfo", dao.contractObjectModuleList(objectId));
        return this.json(conSet, form);
    }

    public ActionForward contractObjectModuleSummaryTable(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        Integer objectId = form.getParamInt("objectId");
        ContractObjectDAO dao = new ContractObjectDAO(form.getUser(), billingId);
        form.setResponseData("moduleInfo", dao.contractObjectModuleList(objectId));
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/bgbilling/contract/object/object_module_summary_table.jsp");
    }

    public ActionForward contractSubcontractList(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        Integer contractId = form.getParamInt("contractId");
        ContractHierarchyDAO crmDAO = new ContractHierarchyDAO(form.getUser(), billingId);
        form.setResponseData("subContractList", crmDAO.contractSubcontractList(contractId));
        form.setResponseData("superContract", crmDAO.contractSupercontract(contractId));
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/bgbilling/contract/subcontract_list.jsp");
    }

    public ActionForward scriptList(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        Integer contractId = form.getParamInt("contractId");
        form.setResponseData("scriptList", new ContractScriptDAO(form.getUser(), billingId).contractScriptList(contractId));
        form.setRequestAttribute("contractInfo", new ContractDAO(form.getUser(), billingId).getContractInfo(contractId));
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/bgbilling/contract/script/script_list.jsp");
    }

    public ActionForward getScript(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        Integer scriptId = form.getParamInt("scriptId");
        ContractScriptDAO crmDAO = new ContractScriptDAO(form.getUser(), billingId);
        form.setResponseData("script", crmDAO.contractScriptGet(scriptId));
        form.setResponseData("scriptTypeList", new DirectoryDAO(form.getUser(), billingId).scriptTypeList());
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/bgbilling/contract/script/script_editor.jsp");
    }

    public ActionForward scriptLog(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        Integer contractId = form.getParamInt("contractId");
        String dateFrom = form.getParam("dateFrom");
        String dateTo = form.getParam("dateTo");
        Pageable<ContractScriptLogItem> result = new Pageable<ContractScriptLogItem>(form);
        ContractScriptDAO crmDAO = new ContractScriptDAO(form.getUser(), billingId);
        crmDAO.contractScriptLogList(result, contractId, dateFrom, dateTo);
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/bgbilling/contract/script/script_log.jsp");
    }

    public ActionForward deleteScript(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        Integer scriptId = form.getParamInt("scriptId");
        ContractScriptDAO crmDAO = new ContractScriptDAO(form.getUser(), billingId);
        crmDAO.deleteContractScript(scriptId);
        return this.json(conSet, form);
    }

    public ActionForward updateScript(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        Integer contractId = form.getParamInt("contractId");
        Integer scriptId = form.getParamInt("scriptId");
        Integer scriptTypeId = form.getParamInt("scriptTypeId");
        String comment = form.getParam("comment");
        String dateFrom = form.getParam("dateFrom");
        String dateTo = form.getParam("dateTo");
        ContractScriptDAO crmDAO = new ContractScriptDAO(form.getUser(), billingId);
        crmDAO.updateContractScript(contractId, scriptId, scriptTypeId, comment, dateFrom, dateTo);
        return this.json(conSet, form);
    }

    public ActionForward faceLog(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        Integer contractId = form.getParamInt("contractId");
        ContractDAO contractDao = new ContractDAO(form.getUser(), billingId);
        contractDao.faceLog(new Pageable<ContractFace>(form), contractId);
        form.setResponseData("contractInfo", new ContractDAO(form.getUser(), billingId).getContractInfo(contractId));
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/bgbilling/contract/face_log.jsp");
    }

    public ActionForward updateFace(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        Integer contractId = form.getParamInt("contractId");
        new ContractDAO(form.getUser(), billingId).updateFace(contractId, form.getParamInt("value"));
        return this.json(conSet, form);
    }

    public ActionForward modeLog(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        Integer contractId = form.getParamInt("contractId");
        ContractDAO contractDao = new ContractDAO(form.getUser(), billingId);
        contractDao.modeLog(new Pageable<ContractMode>(form), contractId);
        form.setResponseData("contractInfo", contractDao.getContractInfo(contractId));
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/bgbilling/contract/mode_log.jsp");
    }

    public ActionForward updateMode(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        Integer contractId = form.getParamInt("contractId");
        new ContractDAO(form.getUser(), billingId).updateMode(contractId, form.getParamInt("value"));
        return this.json(conSet, form);
    }

    public ActionForward moduleList(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        Integer contractId = form.getParamInt("contractId");
        Pair<List<IdTitle>, List<IdTitle>> pair = new ContractDAO(form.getUser(), billingId).moduleList(contractId);
        form.setResponseData("selectedList", pair.getFirst());
        form.setResponseData("availableList", pair.getSecond());
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/bgbilling/contract/module_list.jsp");
    }

    public ActionForward updateModules(DynActionForm form, ConnectionSet conSet) throws BGMessageException {
        String billingId = form.getParam("billingId");
        Integer contractId = form.getParamInt("contractId");
        Set<Integer> moduleIds = form.getParamValues("moduleId");
        String command = form.getParam("command");
        if (Utils.notBlankString(command)) {
            ContractDAO contractDao = new ContractDAO(form.getUser(), billingId);
            for (Integer moduleId : moduleIds) {
                contractDao.updateModule(contractId, moduleId, command);
            }
        }
        return this.json(conSet, form);
    }

    public ActionForward status(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        Integer contractId = form.getParamInt("contractId");
        DirectoryDAO directoryDAO = new DirectoryDAO(form.getUser(), billingId);
        Map<Integer, String> statusTitleMap = directoryDAO.getContractStatusList(false).stream().collect(Collectors.toMap(Id::getId, IdTitle::getTitle));
        ContractStatusDAO statusDao = new ContractStatusDAO(form.getUser(), billingId);
        form.setResponseData("statusList", statusDao.statusList(contractId, statusTitleMap));
        form.setResponseData("statusLog", statusDao.statusLog(contractId, statusTitleMap));
        form.setResponseData("availableStatusList", directoryDAO.getContractStatusList(true));
        form.setRequestAttribute("contractInfo", new ContractDAO(form.getUser(), billingId).getContractInfo(contractId));
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/bgbilling/contract/status.jsp");
    }

    public ActionForward updateStatus(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        Integer contractId = form.getParamInt("contractId");
        new ContractStatusDAO(form.getUser(), billingId).updateStatus(contractId, form.getParamInt("statusId"), form.getParamDate("dateFrom"), form.getParamDate("dateTo"), form.getParam("comment"));
        return this.json(conSet, form);
    }

    public ActionForward limit(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        Integer contractId = form.getParamInt("contractId");
        Pageable<LimitLogItem> limitList = new Pageable<LimitLogItem>(form);
        ArrayList<LimitChangeTask> taskList = new ArrayList<LimitChangeTask>();
        BigDecimal limit = new ContractDAO(form.getUser(), billingId).limit(contractId, limitList, taskList);
        form.setResponseData("limit", limit);
        form.setResponseData("taskList", taskList);
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/bgbilling/contract/limit.jsp");
    }

    public ActionForward updateLimit(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        Integer contractId = form.getParamInt("contractId");
        new ContractDAO(form.getUser(), billingId).updateLimit(contractId, Utils.parseBigDecimal(form.getParam("value")), form.getParamInt("period"), form.getParam("comment", ""));
        return this.json(conSet, form);
    }

    public ActionForward deleteLimitTask(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        Integer contractId = form.getParamInt("contractId");
        new ContractDAO(form.getUser(), billingId).deleteLimitTask(contractId, form.getId());
        return this.json(conSet, form);
    }

    public ActionForward contractCards(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        Integer contractId = form.getParamInt("contractId");
        ContractDAO contractDao = new ContractDAO(form.getUser(), billingId);
        form.setResponseData("cardTypeList", contractDao.getContractCardTypes(contractId));
        form.setResponseData("fullCard", contractDao.getContractFullCard(contractId));
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/bgbilling/contract/cards.jsp");
    }

    public ActionForward getContractCard(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        int contractId = form.getParamInt("contractId");
        String cardType = form.getParam("cardType");
        try {
            ServletOutputStream out = form.getHttpResponse().getOutputStream();
            Utils.setFileNameHeaders(form.getHttpResponse(), "card.pdf");
            out.write(new ContractDAO(form.getUser(), billingId).getContractCard2Pdf(contractId, cardType));
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
        return null;
    }

    public ActionForward serviceList(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        int contractId = form.getParamInt("contractId");
        int moduleId = form.getParamInt("moduleId");
        form.setResponseData("list", new ContractServiceDAO(form.getUser(), billingId).getContractServiceList(contractId, moduleId));
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/bgbilling/contract/service/list.jsp");
    }

    public ActionForward serviceEdit(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        int contractId = form.getParamInt("contractId");
        int moduleId = form.getParamInt("moduleId");
        form.setResponseData("pair", new ContractServiceDAO(form.getUser(), billingId).getContractService(contractId, moduleId, form.getId(), form.getId() > 0 ? false : form.getParamBoolean("onlyUsing", true)));
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/bgbilling/contract/service/edit.jsp");
    }

    public ActionForward serviceUpdate(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        int contractId = form.getParamInt("contractId");
        ContractServiceDAO serviceDAO = new ContractServiceDAO(form.getUser(), billingId);
        for (int serviceId : form.getParamValuesList("serviceId")) {
            ContractService service = new ContractService();
            service.setId(form.getId());
            service.setContractId(contractId);
            service.setServiceId(serviceId);
            service.setDateFrom(form.getParamDate("dateFrom"));
            service.setDateTo(form.getParamDate("dateTo"));
            service.setComment(form.getParam("comment"));
            serviceDAO.updateContractService(service);
        }
        return this.json(conSet, form);
    }

    public ActionForward serviceDelete(DynActionForm form, ConnectionSet conSet) {
        String billingId = form.getParam("billingId");
        int contractId = form.getParamInt("contractId");
        new ContractServiceDAO(form.getUser(), billingId).deleteContractService(contractId, form.getId());
        return this.json(conSet, form);
    }

    public ActionForward getContractStatisticPassword(DynActionForm form, ConnectionSet conSet) throws Exception {
        String billingId = form.getParam("billingId");
        Integer contractId = form.getParamInt("contractId");
        ContractDAO contractDAO = new ContractDAO(form.getUser(), billingId);
        form.setResponseData("password", contractDAO.getContractStatisticPassword(contractId));
        return this.json(conSet, form);
    }

    public ActionForward addressList(DynActionForm form, ConnectionSet conSet) throws Exception {
        String billingId = form.getParam("billingId");
        Integer contractId = form.getParamInt("contractId");
        ContractDAO contractDAO = new ContractDAO(form.getUser(), billingId);
        form.setResponseData("contractAddressList", contractDAO.getContractAddress(contractId));
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/bgbilling/crm/contract_address_list.jsp");
    }

    public ActionForward bgbillingOpenContract(DynActionForm form, ConnectionSet conSet) throws Exception {
        String billingId = form.getParam("billingId");
        Integer contractId = form.getParamInt("contractId");
        ContractDAO contractDAO = new ContractDAO(form.getUser(), billingId);
        contractDAO.bgbillingOpenContract(contractId);
        return this.json(conSet, form);
    }

    public ActionForward bgbillingUpdateContractTitleAndComment(DynActionForm form, ConnectionSet conSet) throws Exception {
        String billingId = form.getParam("billingId");
        Integer contractId = form.getParamInt("contractId");
        String comment = form.getParam("comment");
        ContractDAO contractDAO = new ContractDAO(form.getUser(), billingId);
        contractDAO.bgbillingUpdateContractTitleAndComment(contractId, comment, 0);
        return this.json(conSet, form);
    }

    public ActionForward bgbillingGetContractPatternList(DynActionForm form, ConnectionSet conSet) throws Exception {
        String billingId = form.getParam("billingId");
        ContractDAO contractDAO = new ContractDAO(form.getUser(), billingId);
        form.setResponseData("patterns", contractDAO.bgbillingGetContractPatternList());
        return this.json(conSet, form);
    }

    public ActionForward getSubContractList(DynActionForm form, ConnectionSet conSet) throws Exception {
        String billingId = form.getParam("billingId");
        int contractId = form.getParamInt("contractId");
        ContractHierarchyDAO contractDAO = new ContractHierarchyDAO(form.getUser(), billingId);
        form.setResponseData("subContractList", contractDAO.getSubContracts(contractId));
        return this.json(conSet, form);
    }

    public ActionForward openContract(DynActionForm form, ConnectionSet conSet) throws Exception {
        String billingId = form.getParam("billingId");
        if (billingId == null) {
            throw new BGMessageExceptionWithoutL10n("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 billingId", new Object[0]);
        }
        if (billingId.length() == 0) {
            throw new BGMessageExceptionWithoutL10n("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 billingId", new Object[0]);
        }
        form.setResponseData("openContract", new ContractDAO(form.getUser(), billingId).openContract());
        return this.json(conSet, form);
    }

    public ActionForward getStreetsByCity(DynActionForm form, ConnectionSet conSet) throws Exception {
        String billingId = form.getParam("billingId");
        if (billingId == null) {
            throw new BGMessageExceptionWithoutL10n("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 billingId", new Object[0]);
        }
        if (billingId.length() == 0) {
            throw new BGMessageExceptionWithoutL10n("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 billingId", new Object[0]);
        }
        int cityId = form.getParamInt("cityId");
        if (cityId == 0) {
            throw new BGMessageExceptionWithoutL10n("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 cityId", new Object[0]);
        }
        form.setResponseData("streets", new ContractDAO(form.getUser(), billingId).getStreetsByCity(cityId));
        return this.json(conSet, form);
    }

    public ActionForward getParamList(DynActionForm form, ConnectionSet conSet) throws BGMessageException {
        form.setResponseData("paramType", form.getParamInt("paramType"));
        List<IdTitle> list = this.getParamListImpl(form);
        form.setResponseData("paramList", list);
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/bgbilling/search_param_list.jsp");
    }

    private List<IdTitle> getParamListImpl(DynActionForm form) throws BGMessageException {
        int type = form.getParamInt("paramType");
        String billingId = form.getParam("billingId");
        if (billingId == null) {
            throw new BGMessageExceptionWithoutL10n("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 billingId", new Object[0]);
        }
        return new ContractDAO(form.getUser(), billingId).getParameterList(type);
    }
}

