/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling.proto.dao.directory;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bgerp.model.base.Id;
import ru.bgcrm.model.user.User;
import ru.bgcrm.plugin.bgbilling.DBInfo;
import ru.bgcrm.plugin.bgbilling.proto.dao.DirectoryDAO;

public abstract class Directory<T extends Id> {
    protected final DBInfo dbInfo;
    protected final int moduleId;
    protected final String directoryItemClass;
    private final AtomicLong lastLoadTime = new AtomicLong();
    private final AtomicLong lastLoadVersion = new AtomicLong();
    private final Map<Integer, T> values = new ConcurrentHashMap<Integer, T>();

    protected Directory(DBInfo dbInfo, int moduleId, String directoryItemClass) {
        this.dbInfo = dbInfo;
        this.moduleId = moduleId;
        this.directoryItemClass = directoryItemClass;
    }

    public T get(User user, int id) {
        this.loadIfNeeded(user);
        return (T)this.values.computeIfAbsent(id, this::missingValue);
    }

    public Map<Integer, T> getValues(User user) {
        this.loadIfNeeded(user);
        return this.values;
    }

    private void loadIfNeeded(User user) {
        if (this.lastLoadVersion.get() > 0L && System.currentTimeMillis() - this.lastLoadTime.get() < 10000L) {
            return;
        }
        long version = new DirectoryDAO(user, this.dbInfo).getDirectoryVersion(this.directoryItemClass, this.moduleId);
        if (this.lastLoadVersion.get() == version) {
            return;
        }
        List<T> values = this.list(user);
        this.values.clear();
        this.values.putAll(values.stream().collect(Collectors.toMap(Id::getId, Function.identity())));
        this.lastLoadTime.set(System.currentTimeMillis());
        this.lastLoadVersion.set(version);
    }

    protected abstract List<T> list(User var1);

    protected abstract T missingValue(int var1);
}

