/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling.proto.dao;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.bgerp.app.exception.BGException;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.app.exception.BGMessageExceptionWithoutL10n;
import org.bgerp.cache.ParameterCache;
import org.bgerp.dao.customer.CustomerDAO;
import org.bgerp.dao.param.ParamValueDAO;
import org.bgerp.model.Pageable;
import org.bgerp.model.base.IdStringTitle;
import org.bgerp.model.base.IdTitle;
import org.bgerp.model.param.Parameter;
import org.bgerp.util.Log;
import org.bgerp.util.xml.XMLUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.bgcrm.dao.CustomerLinkDAO;
import ru.bgcrm.model.CommonObjectLink;
import ru.bgcrm.model.Page;
import ru.bgcrm.model.Pair;
import ru.bgcrm.model.customer.Customer;
import ru.bgcrm.model.param.ParameterAddressValue;
import ru.bgcrm.model.param.ParameterPhoneValue;
import ru.bgcrm.model.param.ParameterSearchedObject;
import ru.bgcrm.model.param.address.AddressHouse;
import ru.bgcrm.model.user.User;
import ru.bgcrm.plugin.bgbilling.DBInfo;
import ru.bgcrm.plugin.bgbilling.Request;
import ru.bgcrm.plugin.bgbilling.RequestJsonRpc;
import ru.bgcrm.plugin.bgbilling.dao.BillingDAO;
import ru.bgcrm.plugin.bgbilling.proto.dao.ContractHierarchyDAO;
import ru.bgcrm.plugin.bgbilling.proto.dao.ContractParamDAO;
import ru.bgcrm.plugin.bgbilling.proto.model.Contract;
import ru.bgcrm.plugin.bgbilling.proto.model.ContractFace;
import ru.bgcrm.plugin.bgbilling.proto.model.ContractGroup;
import ru.bgcrm.plugin.bgbilling.proto.model.ContractInfo;
import ru.bgcrm.plugin.bgbilling.proto.model.ContractMode;
import ru.bgcrm.plugin.bgbilling.proto.model.OpenContract;
import ru.bgcrm.plugin.bgbilling.proto.model.contract.ContractCreateData;
import ru.bgcrm.plugin.bgbilling.proto.model.limit.LimitChangeTask;
import ru.bgcrm.plugin.bgbilling.proto.model.limit.LimitLogItem;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.Utils;

public class ContractDAO
extends BillingDAO {
    private static final Log log = Log.getLog();
    public static final String KERNEL_CONTRACT_API = "ru.bitel.bgbilling.kernel.contract.api";
    public static final String KERNEL_CONTRACT_LIMIT = "ru.bitel.bgbilling.kernel.contract.limit";
    private static final String KERNEL_CONTRACT_LABEL = "ru.bitel.bgbilling.kernel.contract.label";

    public ContractDAO(User user, String billingId) {
        super(user, billingId);
    }

    private ContractDAO(User user, DBInfo dbInfo) {
        super(user, dbInfo);
    }

    @Deprecated
    public static ContractDAO getInstance(User user, String billingId) {
        log.warnd("Deprecated method '{}' was called. Create a new instance using 'new' instead.", "getInstance");
        return new ContractDAO(user, billingId);
    }

    public Contract getContractById(int contractId) {
        Contract result = null;
        if (this.dbInfo.versionCompare("8.0") > 0) {
            RequestJsonRpc req = new RequestJsonRpc(KERNEL_CONTRACT_API, "ContractService", "contractList0");
            req.setParamContractId(contractId);
            req.setParam("fc", -1);
            req.setParam("subContracts", true);
            req.setParam("closed", true);
            req.setParam("hidden", true);
            req.setParam("inAllLabels", true);
            JsonNode ret = this.transferData.postData(req, this.user);
            List contractList = (List)this.readJsonValue(ret.findValue("return").traverse(), (JavaType)this.jsonTypeFactory.constructCollectionType(List.class, Contract.class));
            result = contractList.stream().findFirst().orElse(null);
        } else {
            Request req = new Request();
            req.setModule("contract");
            req.setAction("FindContractByID");
            req.setAttribute("id", contractId);
            Document doc = this.transferData.postData(req, this.user);
            for (Element contract : XMLUtils.selectElements(doc, "/data/contracts/item")) {
                String title = contract.getAttribute("title");
                result = new Contract(this.dbInfo.getId(), contractId, StringUtils.substringBefore((String)title, (String)"[").trim(), StringUtils.substringBetween((String)title, (String)"[", (String)"]").trim());
            }
        }
        return result;
    }

    public void searchContractByTitleComment(Pageable<IdTitle> searchResult, String title, String comment, SearchOptions searchOptions) {
        if (searchResult != null) {
            if (this.dbInfo.versionCompare("8.0") > 0) {
                RequestJsonRpc req = new RequestJsonRpc(KERNEL_CONTRACT_API, "ContractService", "contractList");
                req.setParam("title", title);
                req.setParam("comment", comment);
                req.setParam("fc", -1);
                req.setParam("groupMask", 0);
                req.setParam("entityFilter", null);
                req.setParam("subContracts", searchOptions.showSub);
                req.setParam("closed", !searchOptions.showClosed);
                req.setParam("hidden", searchOptions.showHidden);
                req.setParam("page", searchResult.getPage());
                JsonNode ret = this.transferData.postData(req, this.user);
                List contractList = (List)this.readJsonValue(ret.findValue("return").traverse(), (JavaType)this.jsonTypeFactory.constructCollectionType(List.class, Contract.class));
                searchResult.getList().addAll(contractList.stream().map(c -> new IdTitle(c.getId(), c.getTitle() + " [ " + c.getComment() + " ] ")).collect(Collectors.toList()));
                searchResult.getPage().setData((Page)this.jsonMapper.convertValue((Object)ret.findValue("page"), Page.class));
            } else {
                Page page = searchResult.getPage();
                List<IdTitle> contractList = searchResult.getList();
                int pageIndex = page.getPageIndex();
                int pageSize = page.getPageSize();
                Request req = new Request();
                req.setModule("contract");
                req.setAction("FilterContract");
                req.setAttribute("filter", 0);
                this.applySearchOptions(searchOptions, req);
                req.setAttribute("contractComment", comment);
                req.setAttribute("type", -1);
                req.setAttribute("contractMask", title);
                req.setAttribute("pageSize", pageSize);
                req.setAttribute("pageIndex", pageIndex);
                Document document = this.transferData.postData(req, this.user);
                Element dataElement = document.getDocumentElement();
                NodeList nodeList = dataElement.getElementsByTagName("item");
                for (int index = 0; index < nodeList.getLength(); ++index) {
                    Element rowElement = (Element)nodeList.item(index);
                    contractList.add(new IdTitle(Utils.parseInt(rowElement.getAttribute("id")), rowElement.getAttribute("title")));
                }
                NodeList table = dataElement.getElementsByTagName("contracts");
                if (table.getLength() > 0) {
                    page.setRecordCount(Utils.parseInt(((Element)table.item(0)).getAttribute("recordCount")));
                    page.setPageCount(Utils.parseInt(((Element)table.item(0)).getAttribute("pageCount")));
                }
            }
        }
    }

    public void updateContractDateTo(int contractId, Date date) {
        Request request = new Request();
        request.setAction("UpdateContractDate2");
        request.setModule("contract");
        request.setContractId(contractId);
        request.setAttribute("id", contractId);
        request.setAttribute("value", TimeUtils.format(date, "dd.MM.yyyy"));
        this.transferData.postData(request, this.user);
    }

    public void searchContractByObjectAddressParam(Pageable<ParameterSearchedObject<Contract>> result, SearchOptions options, Set<Integer> paramIds, int streetId, String house, String flat, String room) {
        Page page = result.getPage();
        Request req = new Request();
        req.setPage(page);
        req.setModule("contract");
        this.applySearchOptions(options, req);
        req.setAction("FindContract");
        if (this.dbInfo.versionCompare("7.0") >= 0) {
            req.setAttribute("type", "o4");
        } else {
            req.setAttribute("type", 14);
        }
        req.setAttribute("street", streetId);
        AddressHouse houseFrac = new AddressHouse().withHouseAndFrac(house);
        req.setAttribute("house", houseFrac.getHouse());
        req.setAttribute("frac", houseFrac.getFrac());
        req.setAttribute("flat", flat);
        req.setAttribute("room", room);
        if (paramIds != null && !paramIds.isEmpty()) {
            req.setAttribute("parameters", Utils.toString(paramIds));
        }
        this.setPage(req, page);
        Document doc = this.transferData.postData(req, this.user);
        Element contracts = XMLUtils.selectElement(doc, "/data/contracts");
        if (contracts != null) {
            this.getPage(page, contracts);
            List<ParameterSearchedObject<Contract>> list = result.getList();
            for (Element item : XMLUtils.selectElements(contracts, "item")) {
                String fullTitle = item.getAttribute("title");
                Contract contract = new Contract(this.dbInfo.getId(), Utils.parseInt(item.getAttribute("id")), StringUtils.substringBefore((String)fullTitle, (String)"[").trim(), StringUtils.substringBetween((String)fullTitle, (String)"[", (String)"]").trim());
                list.add(new ParameterSearchedObject<Contract>(contract, 0, StringUtils.substringAfterLast((String)fullTitle, (String)"]").trim()));
            }
        }
    }

    public void searchContractByAddressParam(Pageable<ParameterSearchedObject<Contract>> result, SearchOptions options, Set<Integer> paramIds, int streetId, int houseId, String house, String flat, String room) {
        Page page = result.getPage();
        Request req = new Request();
        req.setPage(page);
        req.setModule("contract");
        this.applySearchOptions(options, req);
        req.setAction("FindContract");
        if (this.dbInfo.versionCompare("9.2") >= 0) {
            req.setAttribute("type", "c8");
        } else if (this.dbInfo.versionCompare("7.0") >= 0) {
            req.setAttribute("type", "c2");
        } else {
            req.setAttribute("type", 2);
        }
        req.setAttribute("street", streetId);
        AddressHouse houseFrac = new AddressHouse().withHouseAndFrac(house);
        if (houseId > 0) {
            req.setAttribute("houseId", houseId);
        }
        req.setAttribute("house", houseFrac.getHouse());
        req.setAttribute("frac", houseFrac.getFrac());
        req.setAttribute("flat", flat);
        req.setAttribute("room", room);
        if (paramIds != null && !paramIds.isEmpty()) {
            req.setAttribute("parameters", Utils.toString(paramIds));
        }
        this.setPage(req, page);
        Document doc = this.transferData.postData(req, this.user);
        Element contracts = XMLUtils.selectElement(doc, "/data/contracts");
        if (contracts != null) {
            this.getPage(page, contracts);
            List<ParameterSearchedObject<Contract>> list = result.getList();
            for (Element item : XMLUtils.selectElements(contracts, "item")) {
                Contract contract;
                if (this.dbInfo.versionCompare("9.2407") >= 0) {
                    String comment = item.getAttribute("comment");
                    contract = new Contract(this.dbInfo.getId(), Utils.parseInt(item.getAttribute("id")), item.getAttribute("title"), comment);
                    list.add(new ParameterSearchedObject<Contract>(contract, 0, StringUtils.substringBetween((String)comment, (String)"[", (String)"]").trim()));
                    continue;
                }
                String fullTitle = item.getAttribute("title");
                contract = new Contract(this.dbInfo.getId(), Utils.parseInt(item.getAttribute("id")), StringUtils.substringBefore((String)fullTitle, (String)"[").trim(), StringUtils.substringBetween((String)fullTitle, (String)"[", (String)"]").trim());
                list.add(new ParameterSearchedObject<Contract>(contract, 0, StringUtils.substringAfterLast((String)fullTitle, (String)"]").trim()));
            }
        }
    }

    public void searchContractByTextParam(Pageable<Contract> result, SearchOptions options, Set<Integer> paramIds, String value) {
        Page page = result.getPage();
        Request req = new Request();
        req.setPage(page);
        req.setModule("contract");
        this.applySearchOptions(options, req);
        req.setAction("FindContract");
        if (this.dbInfo.versionCompare("7.0") >= 0) {
            req.setAttribute("type", "c1");
        } else {
            req.setAttribute("type", 1);
        }
        req.setAttribute("parameters", Utils.toString(paramIds));
        req.setAttribute("parameter", value);
        this.addSearchResult(result, page, req);
    }

    public void searchContractByPhoneParam(Pageable<Contract> result, SearchOptions options, Set<Integer> paramIds, String phone) {
        Page page = result.getPage();
        if (this.dbInfo.versionCompare("9.2") >= 0) {
            RequestJsonRpc req = new RequestJsonRpc(KERNEL_CONTRACT_API, "ContractService", "contractList0");
            req.setParam("contractId", 0);
            req.setParam("fc", -1);
            req.setParam("entityFilter", List.of(Map.of("type", "Phone", "entitySpecAttrIds", Utils.toString(paramIds), "mode", 2, "value", phone)));
            req.setParam("subContracts", false);
            req.setParam("closed", true);
            req.setParam("hidden", true);
            req.setParam("page", page);
            req.setParam("inAllLabels", true);
            JsonNode ret = this.transferData.postData(req, this.user);
            List<Contract> list = result.getList();
            list.addAll((Collection)this.readJsonValue(ret.findValue("return").traverse(), (JavaType)this.jsonTypeFactory.constructCollectionType(List.class, Contract.class)));
            for (Contract contract : list) {
                contract.setBillingId(this.dbInfo.getId());
            }
            page.setData((Page)this.jsonMapper.convertValue((Object)ret.findValue("page"), Page.class));
        } else {
            Request req = new Request();
            req.setPage(page);
            req.setModule("contract");
            this.applySearchOptions(options, req);
            req.setAction("FindContract");
            if (this.dbInfo.versionCompare("7.0") >= 0) {
                req.setAttribute("type", "c9");
            } else {
                req.setAttribute("type", 9);
            }
            req.setAttribute("parameters", Utils.toString(paramIds));
            req.setAttribute("phone", phone);
            this.addSearchResult(result, page, req);
        }
    }

    public void searchContractByDateParam(Pageable<Contract> result, SearchOptions options, Set<Integer> paramIds, Date dateFrom, Date dateTo) {
        Page page = result.getPage();
        Request req = new Request();
        req.setPage(page);
        req.setModule("contract");
        this.applySearchOptions(options, req);
        req.setAction("FindContract");
        if (this.dbInfo.versionCompare("7.0") >= 0) {
            req.setAttribute("type", "c6");
        } else {
            req.setAttribute("type", 6);
        }
        req.setAttribute("parameters", Utils.toString(paramIds));
        req.setAttribute("date1", TimeUtils.format(dateFrom, "dd.MM.yyyy"));
        req.setAttribute("date2", TimeUtils.format(dateTo, "dd.MM.yyyy"));
        this.addSearchResult(result, page, req);
    }

    public void searchContractByEmailParam(Pageable<Contract> result, SearchOptions options, Set<Integer> paramIds, String email) {
        Page page = result.getPage();
        Request req = new Request();
        req.setPage(page);
        req.setModule("contract");
        this.applySearchOptions(options, req);
        req.setAction("FindContract");
        req.setAttribute("type", 3);
        req.setAttribute("parameters", Utils.toString(paramIds));
        req.setAttribute("mail", email);
        this.addSearchResult(result, page, req);
    }

    public void addSearchResult(Pageable<Contract> result, Page page, Request req) {
        this.setPage(req, page);
        Document doc = this.transferData.postData(req, this.user);
        Element contracts = XMLUtils.selectElement(doc, "/data/contracts");
        if (contracts != null) {
            this.getPage(page, contracts);
            List<Contract> list = result.getList();
            for (Element item : XMLUtils.selectElements(contracts, "item")) {
                String fullTitle = item.getAttribute("title");
                Contract contract = new Contract(this.dbInfo.getId(), Utils.parseInt(item.getAttribute("id")), StringUtils.substringBefore((String)fullTitle, (String)"[").trim(), StringUtils.substringBetween((String)fullTitle, (String)"[", (String)"]").trim());
                list.add(contract);
            }
        }
    }

    private void applySearchOptions(SearchOptions options, Request req) {
        if (options == null) {
            req.setAttribute("del", 0);
            req.setAttribute("show_sub", 0);
            req.setAttribute("show_closed", 0);
        } else {
            req.setAttribute("del", Utils.booleanToStringInt(options.showHidden));
            req.setAttribute("show_sub", Utils.booleanToStringInt(options.showSub));
            req.setAttribute("show_closed", Utils.booleanToStringInt(options.showClosed));
        }
    }

    public Contract createContract(int patternId, Date date, String title, String customTitle, int superId) throws BGMessageException {
        if (this.dbInfo.getCustomerIdParam() <= 0) {
            throw new BGMessageExceptionWithoutL10n("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 customerIdParam \u0434\u043b\u044f \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0430.", new Object[0]);
        }
        Contract contract = null;
        if (this.dbInfo.versionCompare("9.2") >= 0) {
            if (date == null) {
                date = new Date();
            }
            ContractCreateData.Builder builder = ContractCreateData.builder().setPatternId(patternId).setDateFrom(date);
            if (Utils.notBlankString(customTitle)) {
                builder.setCustomTitle(customTitle);
            }
            RequestJsonRpc req = new RequestJsonRpc(KERNEL_CONTRACT_API, "ContractService", "contractCreate");
            req.setParam("contractCreateData", builder.build());
            int contractId = Utils.parseInt(this.transferData.postDataReturn(req, this.user).asText());
            return this.getContractById(contractId);
        }
        Request req = new Request();
        req.setModule("contract");
        req.setAction("NewContract");
        req.setAttribute("pattern_id", patternId);
        req.setAttribute("date", date);
        if (Utils.notBlankString(customTitle)) {
            req.setAttribute("custom_title", customTitle);
        }
        if (Utils.notBlankString(title)) {
            req.setAttribute("title", title);
        }
        if (superId > 0) {
            req.setAttribute("super_id", superId);
        }
        Document result = this.transferData.postData(req, this.user);
        int contractId = Utils.parseInt(XMLUtils.selectText(result, "/data/contract/@id"));
        String contractTitle = Utils.maskNull(XMLUtils.selectText(result, "/data/contract/@title"));
        contract = new Contract();
        contract.setId(contractId);
        contract.setTitle(contractTitle);
        contract.setBillingId(this.dbInfo.getId());
        return contract;
    }

    public void faceLog(Pageable<ContractFace> result, int contractId) {
        List<ContractFace> list = result.getList();
        Request request = new Request();
        request.setModule("contract");
        request.setAction("ContractFace");
        request.setContractId(contractId);
        request.setAttribute("type", "face");
        request.setAttribute("view", 0);
        this.setPage(request, result.getPage());
        Document document = this.transferData.postData(request, this.user);
        for (Element el : XMLUtils.selectElements(document, "/data/table/data/row")) {
            ContractFace face = new ContractFace();
            face.setTime(TimeUtils.parse(el.getAttribute("date"), "dd.MM.yyyy HH:mm:ss"));
            face.setUser(el.getAttribute("user"));
            face.setFace(el.getAttribute("value"));
            list.add(face);
        }
        this.getPage(result.getPage(), XMLUtils.selectElement(document, "/data/table"));
    }

    public void updateFace(int contractId, int face) {
        Request req = new Request();
        req.setModule("contract");
        req.setAction("SetFcContract");
        req.setContractId(contractId);
        req.setAttribute("value", face);
        this.transferData.postData(req, this.user);
    }

    public void modeLog(Pageable<ContractMode> result, int contractId) {
        List<ContractMode> list = result.getList();
        Request request = new Request();
        request.setModule("contract");
        request.setAction("ContractMode");
        request.setContractId(contractId);
        request.setAttribute("type", "mode");
        request.setAttribute("view", 0);
        this.setPage(request, result.getPage());
        Document document = this.transferData.postData(request, this.user);
        for (Element el : XMLUtils.selectElements(document, "/data/table/data/row")) {
            ContractMode face = new ContractMode();
            face.setTime(TimeUtils.parse(el.getAttribute("date"), "dd.MM.yyyy HH:mm:ss"));
            face.setUser(el.getAttribute("user"));
            face.setMode(el.getAttribute("value"));
            list.add(face);
        }
        this.getPage(result.getPage(), XMLUtils.selectElement(document, "/data/table"));
    }

    public void updateMode(int contractId, int mode) {
        Request req = new Request();
        req.setModule("contract");
        req.setAction("UpdateContractMode");
        req.setContractId(contractId);
        req.setAttribute("value", mode == 0 ? "credit" : "debet");
        this.transferData.postData(req, this.user);
    }

    public List<ContractGroup> getContractLabelTreeItemList(int contractId) {
        List<ContractGroup> groups = new ArrayList<ContractGroup>();
        if (this.dbInfo.versionCompare("9.2") >= 0) {
            RequestJsonRpc req = new RequestJsonRpc(KERNEL_CONTRACT_LABEL, "ContractLabelService", "getContractLabelTreeItemList");
            req.setParam("contractId", contractId);
            req.setParam("calcCount", false);
            JsonNode ret = this.transferData.postDataReturn(req, this.user);
            groups = (List)this.readJsonValue(ret.traverse(), (JavaType)this.jsonTypeFactory.constructCollectionType(List.class, ContractGroup.class));
        }
        return groups;
    }

    public Pair<List<IdTitle>, Set<Integer>> groupsGet(int contractId) {
        List<Object> groupList = new ArrayList();
        Set<Integer> selectedIds = new HashSet();
        if (this.dbInfo.versionCompare("9.2") >= 0) {
            List<ContractGroup> groups = this.getContractLabelTreeItemList(contractId);
            RequestJsonRpc req = new RequestJsonRpc(KERNEL_CONTRACT_LABEL, "ContractLabelService", "getContractLabelIds");
            req.setParam("contractId", contractId);
            JsonNode ret = this.transferData.postDataReturn(req, this.user);
            selectedIds = (Set)this.readJsonValue(ret.traverse(), (JavaType)this.jsonTypeFactory.constructCollectionType(Set.class, Integer.class));
            groupList = groups.stream().map(gr -> new IdTitle(gr.getId(), gr.getTitle())).collect(Collectors.toList());
        } else {
            Request request = new Request();
            request.setModule("contract");
            request.setAction("ContractGroup");
            request.setContractId(contractId);
            Document document = this.transferData.postData(request, this.user);
            long selected = 0L;
            Element groups = XMLUtils.selectElement(document, "/data/groups");
            if (groups != null) {
                selected = Utils.parseLong(groups.getAttribute("selected"));
            }
            for (Element rowElement : XMLUtils.selectElements(document, "/data/groups/group")) {
                IdTitle group = new IdTitle();
                group.setId(Utils.parseInt(rowElement.getAttribute("id")));
                group.setTitle(rowElement.getAttribute("title"));
                groupList.add(group);
                if ((selected & 1L << group.getId()) <= 0L) continue;
                selectedIds.add(group.getId());
            }
        }
        return new Pair<List<IdTitle>, Set<Integer>>(groupList, selectedIds);
    }

    public void updateLabels(int contractId, Set<Integer> labelIds) {
        if (this.dbInfo.versionCompare("9.2") > 0) {
            RequestJsonRpc req = new RequestJsonRpc(KERNEL_CONTRACT_LABEL, "ContractLabelService", "setContractLabelIds");
            req.setParam("contractId", contractId);
            req.setParam("contractLabelsIds", labelIds);
            this.transferData.postData(req, this.user);
        } else {
            Set<Integer> currentGroups = this.groupsGet(contractId).getSecond();
            for (Integer deleteGroup : CollectionUtils.subtract(currentGroups, labelIds)) {
                this.updateGroup("del", contractId, deleteGroup);
            }
            for (Integer addGroup : CollectionUtils.subtract(labelIds, currentGroups)) {
                this.updateGroup("add", contractId, addGroup);
            }
        }
    }

    private void updateGroup(String command, int contractId, int groupId) {
        if (this.dbInfo.versionCompare("5.2") < 0) {
            Request request = new Request();
            request.setModule("contract");
            request.setContractId(contractId);
            request.setAttribute("value", groupId);
            request.setAttribute("id", contractId);
            if ("add".equals(command)) {
                request.setAction("UpdateContractGroup");
            } else if ("del".equals(command)) {
                request.setAction("ClearContractGroup");
            }
            this.transferData.postData(request, this.user);
        } else {
            RequestJsonRpc req = null;
            if ("add".equals(command)) {
                req = new RequestJsonRpc(KERNEL_CONTRACT_API, "ContractService", "contractGroupAdd");
            } else if ("del".equals(command)) {
                req = new RequestJsonRpc(KERNEL_CONTRACT_API, "ContractService", "contractGroupRemove");
            }
            if (req != null) {
                req.setParamContractId(contractId);
                req.setParam("contractGroupId", groupId);
                this.transferData.postDataReturn(req, this.user);
            }
        }
    }

    public List<IdTitle> additionalActionList(int contractId) {
        Request request = new Request();
        request.setModule("contract");
        request.setAction("AdditionalActionList");
        request.setContractId(contractId);
        Document document = this.transferData.postData(request, this.user);
        Element dataElement = document.getDocumentElement();
        NodeList nodeList = dataElement.getElementsByTagName("item");
        ArrayList<IdTitle> additionalActionList = new ArrayList<IdTitle>();
        for (int index = 0; index < nodeList.getLength(); ++index) {
            Element rowElement = (Element)nodeList.item(index);
            IdTitle additionalAction = new IdTitle();
            additionalAction.setId(Utils.parseInt(rowElement.getAttribute("id")));
            additionalAction.setTitle(rowElement.getAttribute("title"));
            additionalActionList.add(additionalAction);
        }
        return additionalActionList;
    }

    public String executeAdditionalAction(int contractId, int actionId) {
        Request request = new Request();
        request.setModule("contract");
        request.setAction("AdditionalAction");
        request.setContractId(contractId);
        request.setAttribute("action_id", actionId);
        Document document = this.transferData.postData(request, this.user);
        Element dataElement = document.getDocumentElement();
        NodeList nodeList = dataElement.getElementsByTagName("row");
        StringBuilder result = new StringBuilder();
        for (int index = 0; index < nodeList.getLength(); ++index) {
            Element rowElement = (Element)nodeList.item(index);
            result.append(rowElement.getAttribute("text") + "&#13;&#10;");
        }
        return result.toString();
    }

    public Pair<List<IdTitle>, List<IdTitle>> moduleList(int contractId) {
        List<IdTitle> selectedList = new ArrayList();
        List<IdTitle> availableList = new ArrayList<IdTitle>();
        if (this.dbInfo.versionCompare("9.2410") >= 0) {
            RequestJsonRpc req = new RequestJsonRpc("ru.bitel.bgbilling.kernel.module", "ModuleService", "contractModules");
            req.setParamContractId(contractId);
            selectedList = (List)this.readJsonValue(this.transferData.postDataReturn(req, this.user).traverse(), (JavaType)this.jsonTypeFactory.constructCollectionType(List.class, IdTitle.class));
            req = new RequestJsonRpc("ru.bitel.bgbilling.kernel.module", "ModuleService", "moduleList");
            availableList = (List)this.readJsonValue(this.transferData.postDataReturn(req, this.user).traverse(), (JavaType)this.jsonTypeFactory.constructCollectionType(List.class, IdTitle.class));
            Set<Integer> selectedIds = Utils.getObjectIdsSet(selectedList);
            availableList.removeIf(module -> selectedIds.contains(module.getId()));
        } else {
            Request request = new Request();
            request.setModule("contract");
            request.setAction("ContractModuleList");
            request.setContractId(contractId);
            Document document = this.transferData.postData(request, this.user);
            for (Element item : XMLUtils.selectElements(document, "/data/list_select/item")) {
                selectedList.add(new IdTitle(Utils.parseInt(item.getAttribute("id")), item.getAttribute("title")));
            }
            for (Element item : XMLUtils.selectElements(document, "/data/list_avaliable/item")) {
                availableList.add(new IdTitle(Utils.parseInt(item.getAttribute("id")), item.getAttribute("title")));
            }
        }
        return new Pair<List<IdTitle>, List<IdTitle>>(selectedList, availableList);
    }

    public void updateModule(int contractId, int moduleId, String command) throws BGMessageException {
        if (this.dbInfo.versionCompare("9.2410") >= 0) {
            RequestJsonRpc req = new RequestJsonRpc(KERNEL_CONTRACT_API, "ContractService", "del".equals(command) ? "contractModuleDelete" : "contractModuleAdd");
            req.setParamContractId(contractId);
            req.setParam("moduleIds", List.of(Integer.valueOf(moduleId)));
            this.transferData.postData(req, this.user);
        } else {
            Request request = new Request();
            request.setModule("contract");
            request.setContractId(contractId);
            request.setAttribute("module_id", moduleId);
            if ("add".equals(command)) {
                request.setAction("ContractModuleAdd");
            } else if ("del".equals(command)) {
                request.setAction("ContractModuleDelete");
            } else {
                throw new BGMessageExceptionWithoutL10n("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 command", new Object[0]);
            }
            this.transferData.postData(request, this.user);
        }
    }

    public BigDecimal limit(int contractId, Pageable<LimitLogItem> log, List<LimitChangeTask> taskList) {
        List sessionList;
        JsonNode ret;
        BigDecimal result;
        Object req;
        Document doc = null;
        if (this.dbInfo.versionCompare("6.2") >= 0) {
            req = new RequestJsonRpc(this.dbInfo.versionCompare("7.0") >= 0 ? KERNEL_CONTRACT_LIMIT : KERNEL_CONTRACT_API, "ContractLimitService", "contractLimitGet");
            ((RequestJsonRpc)req).setParamContractId(contractId);
            result = (BigDecimal)this.jsonMapper.convertValue((Object)this.transferData.postDataReturn((RequestJsonRpc)req, this.user), BigDecimal.class);
        } else {
            Request request = new Request();
            request.setModule("contract");
            request.setContractId(contractId);
            request.setAction("ContractLimit");
            if (log != null) {
                this.setPage(request, log.getPage());
            }
            doc = this.transferData.postData(request, this.user);
            result = Utils.parseBigDecimal(XMLUtils.selectText(doc, "/data/table/@limitValue"));
        }
        if (log != null) {
            if (this.dbInfo.versionCompare("6.2") >= 0) {
                req = new RequestJsonRpc(KERNEL_CONTRACT_LIMIT, "ContractLimitService", "searchContractLimitLogList");
                ((RequestJsonRpc)req).setParamContractId(contractId);
                ((RequestJsonRpc)req).setParam("page", log.getPage());
                ret = this.transferData.postDataReturn((RequestJsonRpc)req, this.user);
                sessionList = (List)this.readJsonValue(ret.findValue("list").traverse(), (JavaType)this.jsonTypeFactory.constructCollectionType(List.class, LimitLogItem.class));
                log.getList().addAll(sessionList);
                log.getPage().setData((Page)this.jsonMapper.convertValue((Object)ret.findValue("page"), Page.class));
            } else {
                this.getPage(log.getPage(), XMLUtils.selectElement(doc, "/data/table"));
                for (Element item : XMLUtils.selectElements(doc, "/data/table/data/row")) {
                    LimitLogItem logItem = new LimitLogItem();
                    logItem.setTime(TimeUtils.parse(item.getAttribute("f0"), "dd.MM.yyyy HH:mm:ss"));
                    logItem.setUser(item.getAttribute("f1"));
                    logItem.setLimit(Utils.parseBigDecimal(item.getAttribute("f2")));
                    logItem.setComment(item.getAttribute("comment"));
                    logItem.setDays(item.getAttribute("days"));
                    log.getList().add(logItem);
                }
            }
        }
        if (taskList != null) {
            if (this.dbInfo.versionCompare("6.2") >= 0) {
                req = new RequestJsonRpc(KERNEL_CONTRACT_LIMIT, "ContractLimitService", "searchContractLimitAvtoList");
                ((RequestJsonRpc)req).setParamContractId(contractId);
                if (log != null) {
                    ((RequestJsonRpc)req).setParam("page", log.getPage());
                }
                ret = this.transferData.postDataReturn((RequestJsonRpc)req, this.user);
                sessionList = (List)this.readJsonValue(ret.findValue("list").traverse(), (JavaType)this.jsonTypeFactory.constructCollectionType(List.class, LimitChangeTask.class));
                taskList.addAll(sessionList);
            } else {
                for (Element item : XMLUtils.selectElements(doc, "/data/table_lp/data/row")) {
                    LimitChangeTask task = new LimitChangeTask();
                    task.setId(Utils.parseInt(item.getAttribute("id")));
                    task.setDate(TimeUtils.parse(item.getAttribute("f0"), "dd.MM.yyyy"));
                    task.setUser(item.getAttribute("f1"));
                    task.setLimitChange(Utils.parseBigDecimal(item.getAttribute("f2")));
                    taskList.add(task);
                }
            }
        }
        return result;
    }

    public void updateLimit(int contractId, BigDecimal limit, int days, String comment) {
        if (days > 0) {
            if (this.dbInfo.versionCompare("6.2") >= 0) {
                RequestJsonRpc req = new RequestJsonRpc(KERNEL_CONTRACT_LIMIT, "ContractLimitService", "updateContractLimitPeriod");
                req.setParamContractId(contractId);
                req.setParam("limit", limit);
                req.setParam("period", days);
                req.setParam("comment", comment);
                this.transferData.postData(req, this.user);
            } else {
                Request request = new Request();
                request.setModule("contract");
                request.setContractId(contractId);
                request.setAttribute("comment", comment);
                request.setAction("UpdateContractLimitPeriod");
                request.setAttribute("limit", Utils.format(limit));
                request.setAttribute("period", days);
                this.transferData.postData(request, this.user);
            }
        } else if (this.dbInfo.versionCompare("9.2") > 0) {
            RequestJsonRpc req = new RequestJsonRpc(KERNEL_CONTRACT_LIMIT, "ContractLimitService", "updateContractLimit");
            req.setParamContractId(contractId);
            req.setParam("limit", limit);
            req.setParam("comment", comment);
            this.transferData.postData(req, this.user);
        } else {
            Request request = new Request();
            request.setModule("contract");
            request.setContractId(contractId);
            request.setAttribute("comment", comment);
            request.setAction("UpdateContractLimit");
            request.setAttribute("value", Utils.format(limit));
            this.transferData.postData(request, this.user);
        }
    }

    public void deleteLimitTask(int contractId, int id) {
        if (this.dbInfo.versionCompare("8.0") >= 0) {
            RequestJsonRpc req = new RequestJsonRpc(KERNEL_CONTRACT_LIMIT, "ContractLimitService", "cancelLimitChangeTask");
            req.setParamContractId(contractId);
            req.setParam("taskIds", Collections.singletonList(id));
            this.transferData.postDataReturn(req, this.user);
        } else {
            Request request = new Request();
            request.setModule("contract");
            request.setAction("LimitChangeTaskDelete");
            request.setContractId(contractId);
            request.setAttribute("id", id);
            this.transferData.postData(request, this.user);
        }
    }

    public String getContractStatisticPassword(int contractId) {
        Document contractCard = new ContractDAO(this.user, this.dbInfo).getContractCardDoc(contractId);
        return XMLUtils.selectText(contractCard, "/data/contract/@pswd");
    }

    public List<IdTitle> getContractAddress(int contractId) {
        Request request = new Request();
        request.setModule("contract");
        request.setAction("ContractAddressList");
        request.setContractId(contractId);
        Document document = this.transferData.postData(request, this.user);
        ArrayList<IdTitle> contractAddress = new ArrayList<IdTitle>();
        Element dataElement = document.getDocumentElement();
        NodeList nodeList = dataElement.getElementsByTagName("item");
        for (int index = 0; index < nodeList.getLength(); ++index) {
            Element rowElement = (Element)nodeList.item(index);
            IdTitle address = new IdTitle();
            address.setId(Utils.parseInt(rowElement.getAttribute("id")));
            address.setTitle(rowElement.getAttribute("title"));
            contractAddress.add(address);
        }
        return contractAddress;
    }

    public void updateContractPassword(int contractId, String value, boolean generate) {
        Request request = new Request();
        request.setModule("contract");
        request.setAction("UpdateContractPassword");
        request.setContractId(contractId);
        request.setAttribute("value", Utils.maskNull(value));
        if (generate) {
            request.setAttribute("set_pswd", 1);
        }
        this.transferData.postData(request, this.user);
    }

    public String getContractFullCard(int contractId) {
        Request req = new Request();
        req.setModule("contract");
        req.setAction("ContractCardXml");
        req.setAttribute("contentType", "html");
        req.setContractId(contractId);
        return this.transferData.postDataGetString(req, this.user);
    }

    public Document getContractCardDoc(int contractId) {
        Request req = new Request();
        req.setModule("contract");
        req.setAction("ContractCardXml");
        req.setAttribute("contentType", "xml");
        req.setContractId(contractId);
        return this.transferData.postData(req, this.user);
    }

    public List<String[]> getContractCardTypes(int contractId) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        if (this.dbInfo.versionCompare("8.0") > 0) {
            RequestJsonRpc req = new RequestJsonRpc(KERNEL_CONTRACT_API, "ContractService", "contractCardList");
            req.setParamContractId(contractId);
            List list = (List)this.readJsonValue(this.transferData.postDataReturn(req, this.user).traverse(), (JavaType)this.jsonTypeFactory.constructCollectionType(List.class, IdStringTitle.class));
            for (IdStringTitle item : list) {
                result.add(new String[]{item.getId(), item.getTitle()});
            }
        } else {
            Request req = new Request();
            req.setModule("contract");
            req.setAction("ContractCard2ListTypes");
            req.setContractId(contractId);
            Document doc = this.transferData.postData(req, this.user);
            for (Element el : XMLUtils.selectElements(doc, "/data/combo/el")) {
                result.add(new String[]{el.getAttribute("id"), el.getAttribute("title")});
            }
        }
        return result;
    }

    public byte[] getContractCard2Pdf(int contractId, String type) {
        Request req = new Request();
        req.setModule("contract");
        req.setAction("ContractCard2");
        req.setAttribute("contentType", "application/pdf");
        req.setContractId(contractId);
        req.setAttribute("type", type);
        return this.transferData.postDataGetBytes(req, this.user);
    }

    public void bgbillingOpenContract(int contractId) {
        Request req = new Request();
        req.setModule("admin");
        req.setAction("Command");
        req.setAttribute("command", "put");
        req.setAttribute("value", "openContract:" + contractId);
        this.transferData.postData(req, this.user);
    }

    public void bgbillingUpdateContractTitleAndComment(int contractId, String comment, int patid) {
        if (this.dbInfo.versionCompare("8.0") > 0) {
            RequestJsonRpc req = new RequestJsonRpc(KERNEL_CONTRACT_API, "ContractService", "contractTitleAndCommentUpdate");
            req.setParamContractId(contractId);
            req.setParam("title", null);
            req.setParam("comment", comment);
            req.setParam("patternId", patid);
            this.transferData.postDataReturn(req, this.user);
        } else {
            Request req = new Request();
            req.setModule("contract");
            req.setAction("UpdateContractTitleAndComment");
            req.setContractId(contractId);
            if (patid > 0) {
                req.setAttribute("patid", patid);
            }
            req.setAttribute("comment", comment);
            this.transferData.postData(req, this.user);
        }
    }

    public List<IdTitle> bgbillingGetContractPatternList() {
        Request req = new Request();
        req.setModule("contract");
        req.setAction("GetPatternList");
        Document document = this.transferData.postData(req, this.user);
        ArrayList<IdTitle> contractPatterns = new ArrayList<IdTitle>();
        Element dataElement = document.getDocumentElement();
        NodeList nodeList = dataElement.getElementsByTagName("item");
        for (int index = 0; index < nodeList.getLength(); ++index) {
            Element rowElement = (Element)nodeList.item(index);
            IdTitle pattern = new IdTitle();
            pattern.setId(Utils.parseInt(rowElement.getAttribute("id")));
            pattern.setTitle(rowElement.getAttribute("title"));
            contractPatterns.add(pattern);
        }
        return contractPatterns;
    }

    public List<IdTitle> getStreetsByCity(int cityId) {
        Request request = new Request();
        request.setModule("contract");
        request.setAction("GetStreetsByCity");
        request.setAttribute("city", cityId);
        Document document = this.transferData.postData(request, this.user);
        LinkedList<IdTitle> streets = new LinkedList<IdTitle>();
        for (Element item : XMLUtils.selectElements(document, "/data/streets/item")) {
            streets.add(new IdTitle(Utils.parseInt(item.getAttribute("id")), item.getAttribute("title")));
        }
        return streets;
    }

    public OpenContract openContract() {
        Request request = new Request();
        request.setModule("contract");
        request.setAction("OpenContract");
        Document document = this.transferData.postData(request, this.user);
        return new OpenContract(document);
    }

    public List<IdTitle> getParameterList(int parameterTypeId) {
        List<IdTitle> paramList;
        if (this.dbInfo.versionCompare("8.0") > 0) {
            RequestJsonRpc req = new RequestJsonRpc("ru.bitel.bgbilling.kernel.contract.param", "ContractParameterServiceOld", "getContractParameterPrefList");
            req.setParam("paramType", parameterTypeId);
            JsonNode ret = this.transferData.postDataReturn(req, this.user);
            paramList = (ArrayList<IdTitle>)this.readJsonValue(ret.traverse(), (JavaType)this.jsonTypeFactory.constructCollectionType(List.class, IdTitle.class));
        } else if (this.dbInfo.versionCompare("7.0") >= 0) {
            RequestJsonRpc req = new RequestJsonRpc("ru.bitel.bgbilling.kernel.contract.param", "ContractParameterService", "getContractParameterPrefList");
            req.setParam("paramType", parameterTypeId);
            JsonNode ret = this.transferData.postDataReturn(req, this.user);
            paramList = (List)this.readJsonValue(ret.traverse(), (JavaType)this.jsonTypeFactory.constructCollectionType(List.class, IdTitle.class));
        } else {
            Request req = new Request();
            req.setModule("admin");
            req.setAction("ContractParameters");
            req.setAttribute("type", parameterTypeId);
            Document document = this.transferData.postData(req, this.user);
            paramList = new ArrayList<IdTitle>();
            for (Element el : XMLUtils.selectElements(document, "/data/table/data/row")) {
                paramList.add(new IdTitle(Utils.parseInt(el.getAttribute("id")), el.getAttribute("title")));
            }
        }
        return paramList;
    }

    public ContractInfo getContractInfo(int contractId) {
        ContractInfo result = null;
        if (this.dbInfo.versionCompare("8.0") > 0) {
            RequestJsonRpc req = new RequestJsonRpc(KERNEL_CONTRACT_API, "ContractService", "contractInfoGet");
            req.setParamContractId(contractId);
            JsonNode res = this.transferData.postDataReturn(req, this.user);
            JSONObject contractInfo = (JSONObject)this.jsonMapper.convertValue((Object)res, JSONObject.class);
            JSONObject contract = contractInfo.optJSONObject("contract");
            if (contract != null) {
                JSONObject balanceJson;
                result = new ContractInfo();
                result.setBillingId(this.dbInfo.getId());
                result.setId(contractId);
                result.setComment(contract.optString("comment"));
                result.setObjects(Utils.parseInt(contract.optString("objects").split("/")[0]), Utils.parseInt(contract.optString("objects").split("/")[1]));
                result.setHierarchy(contract.optString("hierarchy"));
                result.setHierarchyDep(Utils.parseInt(contract.optString("hierarchyDep", null)));
                result.setHierarchyIndep(Utils.parseInt(contract.optString("hierarchyIndep", null)));
                result.setDeleted(Utils.parseBoolean(contract.optString("del")));
                result.setFace(Utils.parseInt(contract.optString("fc")));
                result.setDateFrom(TimeUtils.parse(contract.optString("date1"), "dd.MM.yyyy"));
                result.setDateTo(TimeUtils.parse(contract.optString("date2"), "dd.MM.yyyy"));
                result.setMode(Utils.parseInt(contract.optString("mode")));
                result.setBalanceLimit(Utils.parseBigDecimal(contract.optString("limit"), BigDecimal.ZERO));
                result.setStatus(contract.optString("status"));
                result.setTitle(contract.optString("title"));
                result.setComments(Utils.parseInt(contract.optString("comments")));
                if ("super".equals(contract.optString("hierarchy"))) {
                    result.setSubContractIds(new ContractHierarchyDAO(this.user, this.dbInfo).getSubContracts(contractId));
                }
                JSONObject infoJson = contractInfo.optJSONObject("info");
                result.setGroupList(this.getList(infoJson, "groups"));
                result.setTariffList(this.getList(infoJson, "tariff"));
                result.setScriptList(this.getList(infoJson, "script"));
                JSONArray modulesJson = infoJson.optJSONArray("modules");
                if (modulesJson != null && !modulesJson.isEmpty()) {
                    ArrayList<ContractInfo.ModuleInfo> moduleList = new ArrayList<ContractInfo.ModuleInfo>();
                    for (int i = 0; i < modulesJson.length(); ++i) {
                        JSONObject moduleJson = modulesJson.getJSONObject(i);
                        int moduleId = moduleJson.optInt("id", -1);
                        String moduleTitle = moduleJson.optString("title", "?");
                        String status = moduleJson.optString("status", null);
                        String modulePackage = moduleJson.optString("package");
                        if (status == null) {
                            status = "";
                        }
                        moduleList.add(new ContractInfo.ModuleInfo(moduleId, moduleTitle, modulePackage, status));
                    }
                    result.setModuleList(moduleList);
                }
                if ((balanceJson = infoJson.optJSONObject("balance")) != null) {
                    result.setBalanceDate(new GregorianCalendar(balanceJson.optInt("yy", -1), balanceJson.optInt("mm", -1) - 1, 1).getTime());
                    result.setBalanceIn(Utils.parseBigDecimal(balanceJson.optString("summa1", "0"), BigDecimal.ZERO));
                    result.setBalancePayment(Utils.parseBigDecimal(balanceJson.optString("summa2", "0"), BigDecimal.ZERO));
                    result.setBalanceAccount(Utils.parseBigDecimal(balanceJson.optString("summa3", "0"), BigDecimal.ZERO));
                    result.setBalanceCharge(Utils.parseBigDecimal(balanceJson.optString("summa4", "0"), BigDecimal.ZERO));
                    result.setBalanceOut(Utils.parseBigDecimal(balanceJson.optString("summa5", "0"), BigDecimal.ZERO));
                }
            }
        } else {
            Request req = new Request();
            req.setModule("contract");
            req.setAction("ContractInfo");
            req.setAttribute("cid", contractId);
            Document doc = this.transferData.postData(req, this.user);
            Element contract = XMLUtils.selectElement(doc, "/data/contract");
            if (contract != null) {
                Element balance;
                result = new ContractInfo();
                result.setBillingId(this.dbInfo.getId());
                result.setId(contractId);
                result.setComment(contract.getAttribute("comment"));
                result.setObjects(Utils.parseInt(contract.getAttribute("objects").split("/")[0]), Utils.parseInt(contract.getAttribute("objects").split("/")[1]));
                result.setHierarchy(contract.getAttribute("hierarchy"));
                result.setHierarchyDep(Utils.parseInt(contract.getAttribute("hierarchyDep")));
                result.setHierarchyIndep(Utils.parseInt(contract.getAttribute("hierarchyIndep")));
                result.setDeleted(Utils.parseBoolean(contract.getAttribute("del")));
                result.setFace(Utils.parseInt(contract.getAttribute("fc")));
                result.setDateFrom(TimeUtils.parse(contract.getAttribute("date1"), "dd.MM.yyyy"));
                result.setDateTo(TimeUtils.parse(contract.getAttribute("date2"), "dd.MM.yyyy"));
                result.setMode(Utils.parseInt(contract.getAttribute("mode")));
                result.setBalanceLimit(Utils.parseBigDecimal(contract.getAttribute("limit"), BigDecimal.ZERO));
                result.setStatus(contract.getAttribute("status"));
                result.setTitle(contract.getAttribute("title"));
                result.setComments(Utils.parseInt(contract.getAttribute("comments")));
                if ("super".equals(contract.getAttribute("hierarchy"))) {
                    result.setSubContractIds(new ContractHierarchyDAO(this.user, this.dbInfo).getSubContracts(contractId));
                }
                result.setGroupList(this.getList(XMLUtils.selectElement(doc, "/data/info/groups")));
                result.setTariffList(this.getList(XMLUtils.selectElement(doc, "/data/info/tariff")));
                result.setScriptList(this.getList(XMLUtils.selectElement(doc, "/data/info/script")));
                Element modules = XMLUtils.selectElement(doc, "/data/info/modules");
                if (modules != null) {
                    ArrayList<ContractInfo.ModuleInfo> moduleList = new ArrayList<ContractInfo.ModuleInfo>();
                    for (Element item : XMLUtils.selectElements(modules, "item")) {
                        moduleList.add(new ContractInfo.ModuleInfo(Utils.parseInt(item.getAttribute("id")), item.getAttribute("title"), item.getAttribute("package"), item.getAttribute("status")));
                    }
                    result.setModuleList(moduleList);
                }
                if ((balance = XMLUtils.selectElement(doc, "/data/info/balance")) != null) {
                    result.setBalanceDate(new GregorianCalendar(Utils.parseInt(balance.getAttribute("yy")), Utils.parseInt(balance.getAttribute("mm")) - 1, 1).getTime());
                    result.setBalanceIn(Utils.parseBigDecimal(balance.getAttribute("summa1"), BigDecimal.ZERO));
                    result.setBalancePayment(Utils.parseBigDecimal(balance.getAttribute("summa2"), BigDecimal.ZERO));
                    result.setBalanceAccount(Utils.parseBigDecimal(balance.getAttribute("summa3"), BigDecimal.ZERO));
                    result.setBalanceCharge(Utils.parseBigDecimal(balance.getAttribute("summa4"), BigDecimal.ZERO));
                    result.setBalanceOut(Utils.parseBigDecimal(balance.getAttribute("summa5"), BigDecimal.ZERO));
                }
            }
        }
        return result;
    }

    protected List<IdTitle> getList(JSONObject infoJson, String nodeName) {
        ArrayList<IdTitle> result = new ArrayList<IdTitle>();
        JSONArray nodeJson = infoJson.optJSONArray(nodeName);
        if (nodeJson == null) {
            return result;
        }
        for (int index = 0; index < nodeJson.length(); ++index) {
            JSONObject itemJson = nodeJson.optJSONObject(index);
            IdTitle item = new IdTitle(itemJson.optInt("id"), itemJson.optString("title"));
            result.add(item);
        }
        return result;
    }

    protected List<IdTitle> getList(Element node) {
        List<IdTitle> result = Collections.emptyList();
        if (node != null) {
            result = new ArrayList<IdTitle>();
            for (Element item : XMLUtils.selectElements(node, "item")) {
                result.add(new IdTitle(Utils.parseInt(item.getAttribute("id")), item.getAttribute("title")));
            }
        }
        return result;
    }

    public void copyParametersToBilling(Connection con, int customerId, int contractId, String title) throws Exception {
        Customer customer = new CustomerDAO(con).getCustomerById(customerId);
        String copyParamsMapping = this.dbInfo.getSetup().get("copyParamMapping", "");
        this.copyObjectParamsToContract(con, copyParamsMapping, customerId, contractId, customer);
    }

    public void copyObjectParamsToContract(Connection con, String copyParamsMapping, int objectId, int contractId, Customer customer) throws SQLException, BGMessageException {
        String[] params;
        ParamValueDAO paramDAO = new ParamValueDAO(con);
        try {
            if (customer != null) {
                this.bgbillingUpdateContractTitleAndComment(contractId, customer.getTitle(), 0);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new BGMessageExceptionWithoutL10n("\u041e\u0448\u0438\u0431\u043a\u0430 \u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0438\u043c\u0435\u043d\u0438 \u043a\u043e\u043d\u0442\u0440\u0430\u0433\u0435\u043d\u0442\u0430: " + customer.getTitle() + "; " + this.dbInfo.getTitle() + ", " + e.getMessage(), new Object[0]);
        }
        if (Utils.isBlankString(copyParamsMapping)) {
            return;
        }
        for (String pair : params = copyParamsMapping.split(";")) {
            try {
                Object value;
                String[] keyValue = pair.split(":");
                String fromParamId = keyValue[0].indexOf(91) == -1 ? keyValue[0] : keyValue[0].substring(0, keyValue[0].indexOf(91));
                int toParamId = Utils.parseInt(keyValue[1].indexOf(91) == -1 ? keyValue[1] : keyValue[1].substring(0, keyValue[1].indexOf(91)));
                Request request = new Request();
                request.setModule("contract");
                request.setAttribute("cid", contractId);
                request.setAttribute("pid", toParamId);
                if (fromParamId.equals("customerTitle")) {
                    if (customer == null) continue;
                    request.setAttribute("action", "UpdateParameterType1");
                    request.setAttribute("value", customer.getTitle());
                    this.transferData.postData(request, this.user);
                    continue;
                }
                Parameter param = ParameterCache.getParameter(Integer.parseInt(fromParamId));
                if (param == null) {
                    throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430: \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \u0441 ID=" + fromParamId + " \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442!", new Object[0]);
                }
                String type = param.getType();
                if ("address".equals(type)) {
                    SortedMap<Integer, ParameterAddressValue> values = paramDAO.getParamAddress(objectId, Integer.parseInt(fromParamId));
                    if (values.size() <= 0) continue;
                    ParameterAddressValue value2 = (ParameterAddressValue)values.get(values.firstKey());
                    request.setAction("UpdateAddressInfo");
                    request.setAttribute("hid", value2.getHouseId());
                    request.setAttribute("flat", value2.getFlat());
                    request.setAttribute("floor", value2.getFloor() == null ? "" : value2.getFloor());
                    request.setAttribute("pod", value2.getPod());
                    request.setAttribute("room", value2.getRoom());
                    request.setAttribute("comment", value2.getComment());
                    this.transferData.postData(request, this.user);
                    continue;
                }
                if ("text".equals(type)) {
                    value = paramDAO.getParamText(objectId, Integer.parseInt(fromParamId));
                    if (!Utils.notBlankString((String)value)) continue;
                    request.setAction("UpdateParameterType1");
                    request.setAttribute("value", value);
                    this.transferData.postData(request, this.user);
                    continue;
                }
                if ("list".equals(type)) {
                    Set<Integer> listValue = paramDAO.getParamList(objectId, Integer.parseInt(fromParamId));
                    if (listValue == null || listValue.size() <= 0) continue;
                    String fromValue = listValue.iterator().next().toString();
                    String toValue = null;
                    if (keyValue[0].indexOf(91) > 0) {
                        String[] fromVals = keyValue[0].substring(keyValue[0].indexOf(91) + 1, keyValue[0].indexOf(93)).split(",");
                        String[] toVals = keyValue[1].substring(keyValue[1].indexOf(91) + 1, keyValue[1].indexOf(93)).split(",");
                        for (int i = 0; i < fromVals.length; ++i) {
                            if (!fromVals[i].equals(fromValue)) continue;
                            toValue = toVals[i];
                            break;
                        }
                    } else {
                        toValue = fromValue;
                    }
                    if (!Utils.notBlankString(toValue)) continue;
                    new ContractParamDAO(this.user, this.dbInfo).updateListParameter(contractId, toParamId, toValue);
                    continue;
                }
                if ("phone".equals(type)) {
                    value = paramDAO.getParamPhone(objectId, Integer.parseInt(fromParamId));
                    if (value == null) continue;
                    new ContractParamDAO(this.user, this.dbInfo).updatePhoneParameter(contractId, toParamId, (ParameterPhoneValue)value);
                    continue;
                }
                if ("date".equals(type)) {
                    value = paramDAO.getParamDate(objectId, Integer.parseInt(fromParamId));
                    if (value == null) continue;
                    new ContractParamDAO(this.user, this.dbInfo).updateDateParameter(contractId, toParamId, (Date)value);
                    continue;
                }
                if (!"email".equals(type) || (value = paramDAO.getParamEmail(objectId, Integer.parseInt(fromParamId))).size() <= 0) continue;
                new ContractParamDAO(this.user, this.dbInfo).updateEmailParameter(contractId, toParamId, value.values());
            }
            catch (BGException e) {
                log.error(e.getMessage(), e);
                throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u0432 \u0431\u0438\u043b\u043b\u0438\u043d\u0433! [" + pair + "] " + e.getMessage(), new Object[0]);
            }
        }
    }

    public static void copyParametersToAllContracts(Connection con, User user, int customerId) throws Exception {
        CustomerLinkDAO linkDao = new CustomerLinkDAO(con);
        for (CommonObjectLink link : linkDao.getObjectLinksWithType(customerId, "contract%")) {
            Contract contract = new Contract(link);
            new ContractDAO(user, contract.getBillingId()).copyParametersToBilling(con, customerId, contract.getId(), contract.getTitle());
        }
    }

    public static class SearchOptions {
        public boolean showHidden;
        public boolean showClosed;
        public boolean showSub;

        public SearchOptions(boolean showHidden, boolean showClosed, boolean showSub) {
            this.showHidden = showHidden;
            this.showClosed = showClosed;
            this.showSub = showSub;
        }
    }
}

