/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling.proto.dao;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.app.exception.BGMessageExceptionWithoutL10n;
import org.bgerp.model.base.IdTitle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bgcrm.model.Pair;
import ru.bgcrm.model.user.User;
import ru.bgcrm.plugin.bgbilling.Request;
import ru.bgcrm.plugin.bgbilling.RequestJsonRpc;
import ru.bgcrm.plugin.bgbilling.dao.BillingDAO;
import ru.bgcrm.plugin.bgbilling.proto.model.UnsupportedBillingVersion;
import ru.bgcrm.util.Utils;

public class CashCheckDAO
extends BillingDAO {
    public static final String CASHCHECK_MODULE_ID = "ru.bitel.bgbilling.plugins.cashcheck";

    public CashCheckDAO(User user, String billingId) {
        super(user, billingId);
    }

    public Pair<String, String> printCheck(int registratorId, int paymentId, String summa, String pswd) throws BGMessageException {
        if (this.dbInfo.versionCompare("6.1") >= 0) {
            RequestJsonRpc req;
            if (Utils.notBlankString(pswd) && registratorId > 0) {
                req = new RequestJsonRpc(CASHCHECK_MODULE_ID, "CashcheckService", "bindPrinter");
                req.setParam("registratorId", registratorId);
                req.setParam("password", pswd);
                this.transferData.postData(req, this.user);
            }
            req = new RequestJsonRpc(CASHCHECK_MODULE_ID, "CashcheckService", "printCheck");
            req.setParam("paymentIds", Collections.singleton(paymentId));
            req.setParam("summa", summa);
            JsonNode result = this.transferData.postDataReturn(req, this.user);
            return new Pair<String, String>(result.path("summa").textValue(), result.path("submit").textValue());
        }
        if (this.dbInfo.versionCompare("5.1") <= 0) {
            block8: {
                if (paymentId > 0) {
                    try {
                        Request request;
                        if (Utils.notBlankString(pswd) && registratorId > 0) {
                            request = new Request();
                            request.setModule(CASHCHECK_MODULE_ID);
                            request.setAction("BindPrinter");
                            request.setAttribute("registrator", registratorId);
                            request.setAttribute("password", pswd);
                            this.transferData.postData(request, this.user);
                        }
                        request = new Request();
                        request.setModule(CASHCHECK_MODULE_ID);
                        request.setAction("PrintCheck");
                        request.setAttribute("id", paymentId);
                        request.setAttribute("summa", summa);
                        Document doc = this.transferData.postData(request, this.user);
                        NodeList nodeList = doc.getElementsByTagName("data");
                        if (nodeList.getLength() > 0) {
                            Element element = (Element)nodeList.item(0);
                            return new Pair<String, String>(element.getAttribute("summa"), element.getAttribute("submit"));
                        }
                        break block8;
                    }
                    catch (Exception e) {
                        throw new BGMessageExceptionWithoutL10n("\u0427\u0435\u043a \u043d\u0435 \u043d\u0430\u043f\u0435\u0447\u0430\u0442\u0430\u043d. " + e.getMessage(), new Object[0]);
                    }
                }
                throw new BGMessageExceptionWithoutL10n("\u0427\u0435\u043a \u043d\u0435 \u043d\u0430\u043f\u0435\u0447\u0430\u0442\u0430\u043d.\u041e\u0448\u0438\u0431\u043a\u0430.", new Object[0]);
            }
            return new Pair<String, String>("", "");
        }
        throw new UnsupportedBillingVersion("5.1 \u0438 \u0441 6.1");
    }

    public List<IdTitle> getRegistratorList() {
        ArrayList<IdTitle> registratorList = new ArrayList<IdTitle>();
        int selectedRegistratorId = 0;
        if (this.dbInfo.versionCompare("6.1") >= 0) {
            RequestJsonRpc req = new RequestJsonRpc(CASHCHECK_MODULE_ID, "CashcheckService", "registratorList");
            JsonNode result = this.transferData.postDataReturn(req, this.user);
            selectedRegistratorId = result.path("registratorId").intValue();
            List list = (List)this.readJsonValue(result.path("list").traverse(), (JavaType)this.jsonTypeFactory.constructCollectionType(List.class, IdTitle.class));
            for (IdTitle registrator : list) {
                if (registrator.getId() == selectedRegistratorId) {
                    registratorList.add(0, registrator);
                    continue;
                }
                registratorList.add(registrator);
            }
        } else if (this.dbInfo.versionCompare("5.1") <= 0) {
            Request request = new Request();
            request.setModule(CASHCHECK_MODULE_ID);
            request.setAction("RegistratorList");
            Document doc = this.transferData.postData(request, this.user);
            selectedRegistratorId = Utils.parseInt(((Element)doc.getElementsByTagName("data").item(0)).getAttribute("registratorId"));
            NodeList nodeList = doc.getElementsByTagName("item");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element element = (Element)node;
                int id = Utils.parseInt(element.getAttribute("id"));
                if (id == selectedRegistratorId) {
                    registratorList.add(0, new IdTitle(id, element.getAttribute("title") + " \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d"));
                    continue;
                }
                registratorList.add(new IdTitle(id, element.getAttribute("title")));
            }
        } else {
            throw new UnsupportedBillingVersion("5.1 \u0438 \u0441 6.1");
        }
        if (selectedRegistratorId == 0) {
            registratorList.add(0, new IdTitle(0, "~ \u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d ~"));
        }
        return registratorList;
    }

    public IdTitle getCurrentPrinter() {
        if (this.dbInfo.versionCompare("6.1") >= 0) {
            RequestJsonRpc req = new RequestJsonRpc(CASHCHECK_MODULE_ID, "CashcheckService", "getCurrentPrinter");
            JsonNode result = this.transferData.postDataReturn(req, this.user);
            return new IdTitle(result.path("registratorId").intValue(), result.path("registratorName").textValue());
        }
        return null;
    }
}

