/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.model.process.queue.config;

import java.util.HashSet;
import java.util.Set;
import org.bgerp.app.cfg.Config;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.cfg.Preferences;
import org.bgerp.util.Log;
import ru.bgcrm.util.Utils;

public class SavedPanelConfig
extends Config {
    private static final Log log = Log.getLog();
    public static final String QUEUE_SAVED_PANEL_SET_PREFIX = "queueSavedPanelSet";
    public static final String QUEUE_CURRENT = "queueCurrent";
    private Set<Integer> savedPanelSet = new HashSet<Integer>();
    private Integer currentSelected = 0;

    public SavedPanelConfig(ConfigMap config) {
        super(null);
        this.savedPanelSet = Utils.toIntegerSet(config.get(QUEUE_SAVED_PANEL_SET_PREFIX, ""));
        log.debug("\u043f\u0440\u043e\u0432\u0435\u0440\u044f\u0435\u043c \u0441\u0435\u0442 \u043f\u043e\u0441\u043b\u0435 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u044f \u0434\u0430\u043d\u043d\u044b\u0445 \u0438\u0437 \u0431\u0430\u0437\u044b: " + this.savedPanelSet.toString(), new Object[0]);
        this.currentSelected = config.getInt(QUEUE_CURRENT, 0);
    }

    public void addSavedPanelSet(Integer queueId) {
        this.savedPanelSet.add(queueId);
        log.debug("putting " + queueId, new Object[0]);
        for (Integer id : this.savedPanelSet) {
            log.debug("check after put " + this.savedPanelSet.contains(id), new Object[0]);
        }
    }

    public void changeCurrentSelected(Integer queueId) {
        log.debug("\u041c\u0435\u043d\u044f\u0435\u043c \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0449\u0443\u044e \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u0443\u044e \u043e\u0447\u0435\u0440\u0435\u0434\u044c: " + queueId, new Object[0]);
        this.currentSelected = queueId;
        log.debug("\u041f\u0440\u043e\u0432\u0435\u0440\u044f\u0435\u043c \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u0443\u044e \u043e\u0447\u0435\u0440\u0435\u0434\u044c " + this.currentSelected, new Object[0]);
    }

    public Set<Integer> getSavedPanelSet() {
        return this.savedPanelSet;
    }

    public Integer getCurrentSelected() {
        log.debug("Current selected: " + this.currentSelected.toString(), new Object[0]);
        return this.currentSelected;
    }

    public void removeSavedPanelSet(Integer queueId) {
        this.savedPanelSet.remove(queueId);
        log.debug("check after remove " + this.savedPanelSet.contains(queueId), new Object[0]);
        log.debug(String.valueOf(this.savedPanelSet), new Object[0]);
    }

    public void updateConfig(Preferences userConfig) {
        userConfig.put(QUEUE_SAVED_PANEL_SET_PREFIX, Utils.toString(this.savedPanelSet));
        if (this.currentSelected > 0) {
            log.debug("\u0437\u0430\u043f\u0438\u0441\u044b\u0432\u0430\u0435\u043c \u0442\u0435\u043a\u0443\u0449\u0443\u044e \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u0443\u044e \u043e\u0447\u0435\u0440\u0435\u0434\u044c \u0432 \u0431\u0430\u0437\u0443", new Object[0]);
            userConfig.put(QUEUE_CURRENT, this.currentSelected.toString());
        }
    }
}

