/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.pln.grpl.action;

import java.sql.Connection;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.struts.action.ActionForward;
import org.bgerp.action.base.BaseAction;
import org.bgerp.app.exception.BGIllegalArgumentException;
import org.bgerp.model.base.IdTitle;
import org.bgerp.plugin.pln.grpl.Config;
import org.bgerp.plugin.pln.grpl.dao.GrplDAO;
import org.bgerp.plugin.pln.grpl.model.BoardConfig;
import org.bgerp.plugin.pln.grpl.model.Cell;
import org.bgerp.plugin.pln.grpl.model.Row;
import org.bgerp.util.TimeConvert;
import ru.bgcrm.dao.process.ProcessDAO;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;

@ActionServlet.Action(path="/user/plugin/grpl/board", pathId=true)
public class BoardAction
extends BaseAction {
    private static final String PATH_JSP = "/WEB-INF/jspf/user/plugin/grpl/board";

    @Override
    public ActionForward unspecified(DynActionForm form, ConnectionSet conSet) throws Exception {
        Config config = this.setup.getConfig(Config.class);
        Date dateFrom = form.getParamDate("dateFrom", TimeConvert.toDate(LocalDate.now().minusDays(2L)));
        form.setParam("dateFrom", TimeUtils.format(dateFrom, "ymd"));
        Date dateTo = form.getParamDate("dateTo", TimeConvert.toDate(LocalDate.now().plusDays(5L)));
        form.setParam("dateTo", TimeUtils.format(dateTo, "ymd"));
        form.setResponseData("boards", config.getBoards());
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/grpl/board/board.jsp");
    }

    public ActionForward show(DynActionForm form, Connection con) throws Exception {
        BoardConfig board = this.setup.getConfig(Config.class).getBoardOrThrow(form.getId());
        Date dateFrom = form.getParamDate("dateFrom");
        Date dateTo = form.getParamDate("dateTo");
        if (dateFrom == null) {
            throw new BGIllegalArgumentException("dateFrom");
        }
        if (dateTo == null || dateTo.before(dateFrom)) {
            throw new BGIllegalArgumentException("dateTo");
        }
        List<Row> rows = new GrplDAO(con).getRows(board, dateFrom, dateTo);
        Set columnIds = rows.stream().flatMap(row -> row.getUsedColumnIds().stream()).collect(Collectors.toSet());
        List<IdTitle> columns = board.getColumns().values().stream().filter(column -> columnIds.contains(column.getId())).toList();
        Date today = new Date();
        for (Row row2 : rows) {
            if (row2.getDate() == null || TimeUtils.dateBefore(row2.getDate(), today) || !row2.hasCells()) continue;
            for (IdTitle column2 : columns) {
                Cell cell = row2.getCell(column2.getId());
                if (cell == null) continue;
                cell.addSlotPlacements();
            }
        }
        form.setResponseData("board", board);
        form.setResponseData("columns", columns);
        form.setResponseData("rows", rows);
        this.updatePersonalization(form, con, map -> map.put("grplBoardLastSelected", String.valueOf(form.getId())));
        return this.html(con, form, "/WEB-INF/jspf/user/plugin/grpl/board/show.jsp");
    }

    public ActionForward menu(DynActionForm form, Connection con) throws Exception {
        BoardConfig board = this.setup.getConfig(Config.class).getBoardOrThrow(form.getId());
        IdTitle column = board.getColumnOrThrow(form.getParamInt("columnId"));
        Row row = new GrplDAO(con).getRow(board, this.getParamDate(form));
        Cell cell = row.getCell(column.getId());
        if (cell == null) {
            cell = new Cell(row, column.getId(), null);
        }
        form.setResponseData("cell", cell);
        return this.html(con, form, "/WEB-INF/jspf/user/plugin/grpl/board/menu.jsp");
    }

    public ActionForward cellGroup(DynActionForm form, Connection con) throws Exception {
        BoardConfig board = this.setup.getConfig(Config.class).getBoardOrThrow(form.getId());
        IdTitle column = board.getColumnOrThrow(form.getParamInt("columnId"));
        new GrplDAO(con).updateGroup(board.getId(), this.getParamDate(form), column.getId(), form.getParamInt("groupId"));
        return this.json(con, form);
    }

    public ActionForward dialog(DynActionForm form, ConnectionSet conSet) throws Exception {
        BoardConfig board = this.setup.getConfig(Config.class).getBoardOrThrow(form.getId());
        IdTitle column = board.getColumnOrThrow(form.getParamInt("columnId"));
        Duration step = Duration.ofMinutes(30L);
        Process process = new ProcessDAO(conSet.getSlaveConnection()).getProcessOrThrow(form.getParamInt("processId"));
        Duration processDuration = board.getProcessDuration(conSet, process);
        LocalTime time = LocalTime.parse(form.getParam("time", Utils::notBlankString));
        LocalTime timeTo = time.plus(Duration.ofMinutes(form.getParamInt("duration", Utils::isPositive)));
        ArrayList<LocalTime> times = new ArrayList<LocalTime>();
        while (time.isBefore(timeTo) && !time.plus(processDuration).isAfter(timeTo)) {
            times.add(time);
            time = time.plus(step);
        }
        form.setResponseData("column", column);
        form.setResponseData("times", times);
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/grpl/board/dialog.jsp");
    }

    public ActionForward slotProcess(DynActionForm form, ConnectionSet conSet) throws Exception {
        BoardConfig board = this.setup.getConfig(Config.class).getBoardOrThrow(form.getId());
        Process process = new ProcessDAO(conSet.getSlaveConnection()).getProcessOrThrow(form.getParamInt("processId"));
        Date date = TimeUtils.parse(form.getParam("date", Utils::notBlankString), "ymd");
        LocalTime time = LocalTime.parse(form.getParam("time", Utils::notBlankString));
        new GrplDAO(conSet.getConnection()).updateSlotTime(board, process, date, time);
        return this.json(conSet, form);
    }

    private Date getParamDate(DynActionForm form) throws BGIllegalArgumentException {
        Date result = form.getParamDate("date");
        if (result == null || TimeUtils.dateBefore(result, new Date())) {
            throw new BGIllegalArgumentException("date");
        }
        return result;
    }
}

