/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.model.process.queue.filter;

import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.model.process.queue.filter.Filter;
import ru.bgcrm.dao.process.QueueSelectParams;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;

public class FilterGrEx
extends Filter {
    private int roleId;
    private Filter groupsFilter;
    private Filter executorsFilter;

    public FilterGrEx(int id, ConfigMap filter) {
        super(id, filter);
        this.roleId = filter.getInt("roleId", 0);
        this.groupsFilter = new Filter(id, filter.sub("groups."));
        this.executorsFilter = new Filter(id, filter.sub("executors."));
    }

    public int getRoleId() {
        return this.roleId;
    }

    public Filter getGroupsFilter() {
        return this.groupsFilter;
    }

    public Filter getExecutorsFilter() {
        return this.executorsFilter;
    }

    @Override
    public void apply(DynActionForm form, QueueSelectParams params) {
        String executorIds;
        StringBuilder joinPart = params.joinPart;
        StringBuilder wherePart = params.wherePart;
        String groupIds = Utils.toString(form.getParamValues("group" + this.roleId));
        if (Utils.isBlankString(groupIds) && this.getOnEmptyValues().size() > 0) {
            groupIds = Utils.toString(this.getOnEmptyValues());
        }
        String pgTableAlias = "pg_" + this.roleId;
        if (Utils.notBlankString(groupIds)) {
            joinPart.append(" INNER JOIN  process_group AS " + pgTableAlias + " ON process.id=" + pgTableAlias + ".process_id AND " + pgTableAlias + ".group_id IN(").append(groupIds).append(") AND " + pgTableAlias + ".role_id=" + this.roleId);
        }
        if (Utils.notBlankString(executorIds = Utils.toString(form.getParamValuesStr("executor" + this.roleId)).replace("current", String.valueOf(form.getUserId())))) {
            String tableAlias = "pe_" + this.roleId;
            boolean empty = executorIds.contains("empty");
            if (empty) {
                joinPart.append(" LEFT JOIN ");
            } else {
                joinPart.append(" INNER JOIN ");
            }
            joinPart.append(" process_executor AS " + tableAlias + " ON process.id=" + tableAlias + ".process_id AND " + tableAlias + ".role_id=" + this.roleId);
            if (Utils.notBlankString(groupIds)) {
                joinPart.append(" AND " + pgTableAlias + ".group_id=" + tableAlias + ".group_id");
            }
            if (empty) {
                wherePart.append(" AND " + tableAlias + ".user_id IS NULL ");
            } else {
                joinPart.append(" AND " + tableAlias + ".user_id IN(");
                joinPart.append(executorIds);
                joinPart.append(") ");
            }
        }
    }
}

