/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.model.msg.config;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bgerp.app.cfg.Config;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.model.base.IdTitle;
import ru.bgcrm.util.Utils;

public class TemplateConfig
extends Config {
    private final Map<Integer, Template> templates;

    protected TemplateConfig(ConfigMap config) {
        super(null);
        this.templates = this.loadTemplates(config);
    }

    private Map<Integer, Template> loadTemplates(ConfigMap config) {
        LinkedHashMap<Integer, Template> result = new LinkedHashMap<Integer, Template>();
        for (Map.Entry<Integer, ConfigMap> me : config.subIndexed("message.template.").entrySet()) {
            Template pattern = new Template((int)me.getKey(), me.getValue());
            if (!Utils.notBlankStrings(pattern.getTitle(), pattern.subject, pattern.text)) continue;
            result.put(pattern.getId(), pattern);
        }
        return Collections.unmodifiableMap(result);
    }

    public Map<Integer, Template> getTemplates() {
        return this.templates;
    }

    public static final class Template
    extends IdTitle {
        private final String subject;
        private final String text;

        private Template(int id, ConfigMap config) {
            super(id, config.get("title"));
            this.subject = config.get("subject");
            this.text = config.get("text");
        }

        public String getSubject() {
            return this.subject;
        }

        public String getText() {
            return this.text;
        }
    }
}

