/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.action;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.struts.action.ActionForward;
import org.apache.struts.upload.FormFile;
import org.bgerp.action.base.BaseAction;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.dao.FileDataDAO;
import org.bgerp.model.base.IdTitle;
import org.bgerp.model.file.FileData;
import org.bgerp.model.file.tmp.SessionTemporaryFiles;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;

@ActionServlet.Action(path="/user/file")
public class FileAction
extends BaseAction {
    @Override
    public ActionForward unspecified(DynActionForm form, Connection con) throws Exception {
        HttpServletResponse response = form.getHttpResponse();
        FileData data = new FileData();
        data.setId(form.getId());
        data.setSecret(form.getParam("secret"));
        data.setTitle(form.getParam("title"));
        File file = new FileDataDAO(con).getFile(data);
        if (file != null) {
            ServletOutputStream out = response.getOutputStream();
            try (FileInputStream fis = new FileInputStream(file);){
                Utils.setFileNameHeaders(response, data.getTitle());
                IOUtils.copy((InputStream)fis, (OutputStream)out);
            }
            out.flush();
        }
        return null;
    }

    public ActionForward temporaryUpload(DynActionForm form, ConnectionSet conSet) throws Exception {
        FormFile file = form.getFile();
        this.log.debug("Uploading temporary file: {}, type: {}", file.getFileName(), file.getContentType());
        FileAction.uploadFileCheck(file);
        int fileId = SessionTemporaryFiles.upload(form);
        form.setResponseData("file", new IdTitle(fileId, file.getFileName()));
        return this.json(conSet, form);
    }

    public static void uploadFileCheck(FormFile file) throws FileNotFoundException, IOException, BGMessageException {
        if (file == null) {
            return;
        }
        long maxSizeMb = Setup.getSetup().getLong("file.upload.max.size.mb", 3L);
        if (maxSizeMb * 1000000L < (long)file.getFileData().length) {
            throw new BGMessageException("File '{}' is bigger than allowed {} MB", file.getFileName(), maxSizeMb);
        }
    }

    public ActionForward temporaryDelete(DynActionForm form, ConnectionSet conSet) {
        this.log.debug("Deleting temporary file: {}", form.getId());
        SessionTemporaryFiles.deleteFiles(form, Set.of(Integer.valueOf(form.getId())));
        return this.json(conSet, form);
    }
}

