/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling.model.process.wizard;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.cfg.bean.annotation.Bean;
import ru.bgcrm.dao.process.ProcessLinkDAO;
import ru.bgcrm.model.CommonObjectLink;
import ru.bgcrm.model.process.wizard.base.StepData;
import ru.bgcrm.model.process.wizard.base.WizardData;
import ru.bgcrm.plugin.bgbilling.model.process.wizard.BaseStep;
import ru.bgcrm.plugin.bgbilling.proto.dao.ContractParamDAO;
import ru.bgcrm.plugin.bgbilling.proto.model.Contract;
import ru.bgcrm.plugin.bgbilling.proto.model.ContractParameter;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;

@Bean(oldClasses={"ru.bgcrm.plugin.bgbilling.model.process.wizard.FillParamsStep"})
public class FillContractParamsStep
extends BaseStep {
    private final List<Integer> parameterIds;
    private final List<Integer> checkParamIds;

    public FillContractParamsStep(ConfigMap config) {
        super(config);
        this.parameterIds = Utils.toIntegerList(config.get("parameterIds", ""));
        this.checkParamIds = Utils.toIntegerList(config.get("checkParamIds", ""));
    }

    public List<Integer> getParameterIds() {
        return this.parameterIds;
    }

    public List<Integer> getCheckParamIds() {
        return this.checkParamIds;
    }

    @Override
    public String getJsp() {
        return "/WEB-INF/jspf/user/plugin/bgbilling/process/wizard/step_fill_params.jsp";
    }

    @Override
    public StepData<?> data(WizardData data) {
        return new Data(this, data);
    }

    public static class Data
    extends StepData<FillContractParamsStep> {
        private Contract contract;
        private List<ContractParameter> values;

        private Data(FillContractParamsStep step, WizardData data) {
            super(step, data);
        }

        public Contract getContract() {
            return this.contract;
        }

        public List<ContractParameter> getValues() {
            return this.values;
        }

        @Override
        public boolean isFilled(DynActionForm form, Connection con) {
            CommonObjectLink contractLink = Utils.getFirst(new ProcessLinkDAO(con).getObjectLinksWithType(this.data.getProcess().getId(), "contract%"));
            if (contractLink == null) {
                return false;
            }
            this.contract = new Contract(contractLink);
            HashSet<Integer> checkParamIds = new HashSet<Integer>(((FillContractParamsStep)this.step).getCheckParamIds());
            ContractParamDAO paramDao = new ContractParamDAO(form.getUser(), this.contract.getBillingId());
            List<ContractParameter> allParamValues = paramDao.getParameterList(this.contract.getId());
            ArrayList<ContractParameter> filteredValues = new ArrayList<ContractParameter>(((FillContractParamsStep)this.step).getParameterIds().size());
            for (int paramId : ((FillContractParamsStep)this.step).getParameterIds()) {
                ContractParameter param = allParamValues.stream().filter(cp -> cp.getParamId() == paramId).findFirst().orElse(null);
                if (param != null) {
                    filteredValues.add(param);
                    if (Utils.notBlankString(param.getValue())) {
                        checkParamIds.remove(paramId);
                    }
                }
                this.values = filteredValues;
            }
            return checkParamIds.isEmpty();
        }
    }
}

