/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.report.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bgerp.plugin.report.model.Column;
import org.bgerp.plugin.report.model.Data;

@JsonSerialize
public class Record {
    private final Data data;
    private final List<Object> values;
    private int pos;

    public Record(Data data) {
        this.data = data;
        this.values = new ArrayList<Object>(data.getColumns().size());
    }

    public Record add(Object value) {
        int index = this.values.size();
        if (index >= this.data.getColumns().size()) {
            throw new IndexOutOfBoundsException("Too many column values");
        }
        Column column = this.data.getColumns().getByIndex(index);
        this.values.add(column.accept(value));
        return this;
    }

    public Object get(String id) {
        return this.values.get(this.data.getColumns().getIndex(id));
    }

    public String getString(String id) {
        Column column = this.data.getColumns().get(id);
        return column.toString(this.values.get(column.getIndex()));
    }

    public int pos() {
        return ++this.pos;
    }

    @JsonAnyGetter
    public Map<String, Object> getData() {
        HashMap<String, Object> result = new HashMap<String, Object>(this.data.getColumns().getVisibleColumns().size());
        for (Column col : this.data.getColumns().getVisibleColumns()) {
            result.put(col.getId(), this.getString(col.getId()));
        }
        return result;
    }
}

