/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.pln.callboard.model;

import java.util.ArrayList;
import java.util.List;
import ru.bgcrm.util.Utils;

public class WorkDaysCalendarRule {
    private int day;
    private int type;

    public WorkDaysCalendarRule(int day, int type) {
        this.day = day;
        this.type = type;
    }

    public int getDay() {
        return this.day;
    }

    public void setDay(int day) {
        this.day = day;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public static List<WorkDaysCalendarRule> createFromString(String ruleString) {
        ArrayList<WorkDaysCalendarRule> result = new ArrayList<WorkDaysCalendarRule>();
        try {
            for (String rule : Utils.toSet(ruleString, ";")) {
                String headPart = rule.substring(0, rule.indexOf(":"));
                int type = Integer.parseInt(rule.substring(rule.indexOf(":") + 1));
                if (headPart.indexOf(",") > -1) {
                    for (Integer part : Utils.toIntegerSet(headPart)) {
                        result.add(new WorkDaysCalendarRule(part, type));
                    }
                    continue;
                }
                if (headPart.indexOf("-") > -1) {
                    int end = Integer.parseInt(headPart.substring(headPart.indexOf("-") + 1));
                    for (int begin = Integer.parseInt(headPart.substring(0, headPart.indexOf("-"))); begin <= end; ++begin) {
                        result.add(new WorkDaysCalendarRule(begin, type));
                    }
                    continue;
                }
                result.add(new WorkDaysCalendarRule(Integer.parseInt(headPart), type));
            }
        }
        catch (Exception e) {
            return result;
        }
        return result;
    }
}

