/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.pln.callboard.dao;

import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.bgerp.app.cfg.Setup;
import org.bgerp.dao.param.ParamValueDAO;
import org.bgerp.plugin.pln.callboard.cache.CallboardCache;
import org.bgerp.plugin.pln.callboard.dao.ShiftDAO;
import org.bgerp.plugin.pln.callboard.dao.WorkTypeDAO;
import org.bgerp.plugin.pln.callboard.model.DayType;
import org.bgerp.plugin.pln.callboard.model.WorkDaysCalendar;
import org.bgerp.plugin.pln.callboard.model.WorkShift;
import org.bgerp.plugin.pln.callboard.model.WorkType;
import org.bgerp.plugin.pln.callboard.model.WorkTypeTime;
import org.bgerp.plugin.pln.callboard.model.config.CalendarConfig;
import org.bgerp.plugin.pln.callboard.model.config.CallboardConfig;
import org.bgerp.plugin.pln.callboard.model.config.DayTypeConfig;
import ru.bgcrm.dao.CommonDAO;
import ru.bgcrm.dao.user.UserDAO;
import ru.bgcrm.model.Pair;
import ru.bgcrm.model.user.User;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.Utils;

public class TabelDAO
extends CommonDAO {
    private static final String SHORTCUT_FREE_DAY = "\u0412";
    private static final int USER_ROW_FROM = 25;
    private static final int USER_ROWS = 4;
    private static final int USER_COL_FROM = 0;
    private static final int USER_COLS = 27;
    private static final String HOLIDAY_WORK_SHORTCUT = "\u0420\u0412";
    private static final String HOLIDAY_SHORTCUT = "Z";
    private static final int HOLIDAY_POS = 3;
    private static final Map<String, int[]> SHORTCUT_POS = new HashMap<String, int[]>();

    public TabelDAO(Connection con) {
        super(con);
    }

    public HSSFWorkbook generateTabel(CallboardConfig.Callboard callboard, Date dateFrom, Date dateTo) throws Exception {
        DayTypeConfig dayTypeConfig = Setup.getSetup().getConfig(DayTypeConfig.class);
        WorkDaysCalendar calendar = Setup.getSetup().getConfig(CalendarConfig.class).getCalendar(callboard.getCalendarId());
        Map<Date, Integer> excludeDates = new WorkTypeDAO(this.con).getWorkDaysCalendarExcludes(calendar.getId());
        ParamValueDAO paramDao = new ParamValueDAO(this.con);
        Map<Integer, Map<Date, WorkShift>> userShifts = new ShiftDAO(this.con).getUserShifts(callboard.getId(), dateFrom, dateTo);
        List<User> userList = new UserDAO(this.con).getUserList(Collections.singleton(callboard.getGroupId()), dateFrom, dateTo);
        HSSFWorkbook workbook = new HSSFWorkbook((InputStream)new FileInputStream(callboard.getTabelConfig().getTemplatePath()));
        HSSFSheet sheet = workbook.getSheetAt(0);
        sheet.getRow(9).getCell(1).setCellValue(callboard.getTabelConfig().getOrgName());
        this.addDates(dateFrom, dateTo, sheet);
        int days = TimeUtils.convertDateToCalendar(dateTo).getActualMaximum(5);
        this.addDays(sheet, days, 20, new GetForDay(this){

            @Override
            public String add(int day, boolean upCell) {
                return upCell ? String.valueOf(day) : "";
            }

            @Override
            public String getDefault(boolean upCell) {
                return upCell ? "X" : "";
            }
        });
        List<CellRangeAddress> rangesForCopy = this.getRangesForCopy(sheet);
        int workHoursSum = 0;
        Calendar date = TimeUtils.convertDateToCalendar(dateFrom);
        Calendar calendarTo = TimeUtils.convertDateToCalendar(dateTo);
        while (TimeUtils.dateBeforeOrEq(date, calendarTo)) {
            Pair<DayType, Boolean> typePair = calendar.getDayType(date.getTime(), excludeDates);
            DayType dayType = dayTypeConfig.getType(typePair.getFirst().getId());
            if (dayType != null) {
                workHoursSum += dayType.getWorkHours();
            }
            date.add(6, 1);
        }
        for (int i = 0; i < userList.size(); ++i) {
            if (userShifts.containsKey(userList.get(i).getId())) continue;
            userList.remove(i);
            --i;
        }
        int size = userList.size();
        for (int i = 0; i < size; ++i) {
            Object post;
            User user = userList.get(i);
            int offset = i * 4;
            if (i > 0) {
                sheet.shiftRows(30 + offset - 4, 34 + offset - 4, 4);
                TabelDAO.createUserRows(sheet, 25 + offset, rangesForCopy);
            }
            if (Utils.notBlankString((String)(post = Utils.maskNull(paramDao.getParamText(user.getId(), callboard.getTabelConfig().getParamDolznost()))))) {
                post = ", " + (String)post;
            }
            HSSFRow row = sheet.getRow(25 + offset);
            row.getCell(0).setCellValue((double)(i + 1));
            row.getCell(1).setCellValue(user.getTitle() + (String)post);
            row.getCell(2).setCellValue(paramDao.getParamText(user.getId(), callboard.getTabelConfig().getParamTabelNumber()));
            HashMap<String, Integer> neyavkMap = new HashMap<String, Integer>(4);
            Map dateShifts = Utils.maskNull(userShifts.get(user.getId()), Collections.emptyMap());
            int[][] workedForPeriod = new int[5][2];
            int userWorkMinutes = 0;
            final LinkedHashMap dayLabels = new LinkedHashMap(31);
            date = TimeUtils.convertDateToCalendar(dateFrom);
            while (TimeUtils.dateBeforeOrEq(date, calendarTo)) {
                int minutes;
                WorkType type;
                Date curDate = TimeUtils.convertCalendarToDate(date);
                Date prevDate = TimeUtils.getPrevDay(curDate);
                int day = date.get(5);
                Pair<DayType, Boolean> curDayType = calendar.getDayType(curDate, excludeDates);
                boolean curDayHoliday = curDayType != null && curDayType.getFirst().isHoliday();
                LinkedHashMap<String, Integer> labels = new LinkedHashMap<String, Integer>();
                dayLabels.put(day, labels);
                WorkShift shift = (WorkShift)dateShifts.get(prevDate);
                if (shift != null) {
                    for (WorkTypeTime time : shift.getWorkTypeTimeList()) {
                        type = CallboardCache.getWorkType(time.getWorkTypeId());
                        if (type != null) {
                            if (type.getIsNonWorkHours() || (minutes = time.getWorkMinutesInDay(type, prevDate, curDate)) <= 0) continue;
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("PrevDay " + TimeUtils.format(curDate, "ymd") + "  += " + minutes + "; type: " + type.getId(), new Object[0]);
                            }
                            for (String shortcut : type.getShortcutList()) {
                                labels.put(shortcut, Utils.maskNull((Integer)labels.get(shortcut), 0) + minutes);
                                if (!HOLIDAY_WORK_SHORTCUT.equals(shortcut) && (!curDayHoliday || "\u041d".equals(shortcut))) continue;
                                labels.put(HOLIDAY_SHORTCUT, Utils.maskNull((Integer)labels.get(HOLIDAY_SHORTCUT), 0) + minutes);
                            }
                            if (curDayHoliday) continue;
                            userWorkMinutes += minutes;
                            continue;
                        }
                        this.log.warn("Can't find workType with id=" + time.getWorkTypeId(), new Object[0]);
                    }
                }
                if ((shift = (WorkShift)dateShifts.get(curDate)) != null) {
                    for (WorkTypeTime time : shift.getWorkTypeTimeList()) {
                        type = CallboardCache.getWorkType(time.getWorkTypeId());
                        if (type != null) {
                            if (type.getIsNonWorkHours()) {
                                int hours = time.getMinutesInDay(type, curDate, curDate, false) / 60;
                                if (hours < 23) continue;
                                String shortcut = Utils.getFirst(type.getShortcutList());
                                Integer current = Utils.maskNull((Integer)neyavkMap.get(shortcut), 0);
                                current = current + 1;
                                neyavkMap.put(shortcut, current);
                                labels.put(shortcut, 0);
                                userWorkMinutes += curDayType.getFirst().getWorkHours() * 60;
                                break;
                            }
                            minutes = time.getWorkMinutesInDay(type, curDate, curDate);
                            if (minutes <= 0) continue;
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("CurDay " + TimeUtils.format(curDate, "ymd") + "  += " + minutes + "; type: " + type.getId(), new Object[0]);
                            }
                            for (String shortcut : type.getShortcutList()) {
                                labels.put(shortcut, Utils.maskNull((Integer)labels.get(shortcut), 0) + minutes);
                                if (!HOLIDAY_WORK_SHORTCUT.equals(shortcut) && (!curDayHoliday || "\u041d".equals(shortcut))) continue;
                                labels.put(HOLIDAY_SHORTCUT, Utils.maskNull((Integer)labels.get(HOLIDAY_SHORTCUT), 0) + minutes);
                            }
                            if (curDayHoliday) continue;
                            userWorkMinutes += minutes;
                            continue;
                        }
                        this.log.warn("Can't find workType with id=" + time.getWorkTypeId(), new Object[0]);
                    }
                }
                date.add(6, 1);
            }
            this.log.debug("userWorkMinutes: {}; workHoursSum: {}", userWorkMinutes, workHoursSum);
            int suMinutesRest = userWorkMinutes - workHoursSum * 60;
            if (suMinutesRest > 0) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("su: " + suMinutesRest / 60 + "; mins: " + suMinutesRest, new Object[0]);
                }
                ArrayList dayLabelsList = new ArrayList(dayLabels.values());
                Collections.reverse(dayLabelsList);
                for (LinkedHashMap labels : dayLabelsList) {
                    Integer yMinutes = Utils.maskNull((Integer)labels.get("\u042f"), 0);
                    Integer nMinutes = Utils.maskNull((Integer)labels.get("\u041d"), 0);
                    Integer allowed\u0423Minutes = yMinutes - nMinutes - 60;
                    if ((allowed\u0423Minutes = Integer.valueOf(Math.max(allowed\u0423Minutes, 0))) > 0) {
                        int suMinutes = Math.min(allowed\u0423Minutes, suMinutesRest);
                        suMinutesRest -= suMinutes;
                        labels.put("\u042f", yMinutes - suMinutes);
                        labels.put("\u0421", suMinutes);
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("y: " + yMinutes / 60 + " ( " + yMinutes + " ) allowed: " + allowed\u0423Minutes / 60 + " ( " + allowed\u0423Minutes + " ) su: " + suMinutes / 60 + " ( " + suMinutes + ") suRest: " + suMinutesRest / 60, new Object[0]);
                        }
                    }
                    if (suMinutesRest != 0) continue;
                    break;
                }
            }
            HashSet<Integer> dayInPosition = new HashSet<Integer>(3);
            for (Map.Entry meD : dayLabels.entrySet()) {
                dayInPosition.clear();
                LinkedHashMap labels = (LinkedHashMap)meD.getValue();
                for (Map.Entry me : labels.entrySet()) {
                    String shortcut = (String)me.getKey();
                    int minutes = (Integer)me.getValue();
                    if (HOLIDAY_SHORTCUT.equals(shortcut)) {
                        int[] nArray = workedForPeriod[3];
                        nArray[0] = nArray[0] + 1;
                        int[] nArray2 = workedForPeriod[3];
                        nArray2[1] = nArray2[1] + minutes;
                        continue;
                    }
                    int[] positions = SHORTCUT_POS.get(shortcut);
                    if (positions == null) continue;
                    for (int position : positions) {
                        if (!dayInPosition.contains(position)) {
                            int[] nArray = workedForPeriod[position];
                            nArray[0] = nArray[0] + 1;
                            dayInPosition.add(position);
                        }
                        int[] nArray = workedForPeriod[position];
                        nArray[1] = nArray[1] + minutes;
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug(String.valueOf(meD.getKey()) + " " + shortcut + " " + workedForPeriod[position][0] + " m " + workedForPeriod[position][1] + " h " + workedForPeriod[position][1] / 60, new Object[0]);
                    }
                }
                labels.remove(HOLIDAY_SHORTCUT);
            }
            this.addDays(sheet, days, 25 + offset, new GetForDay(){
                private String valueForDownCell = "";

                @Override
                public String add(int day, boolean upCell) {
                    LinkedHashMap labels = (LinkedHashMap)dayLabels.get(day);
                    if (upCell) {
                        StringBuilder labelString = new StringBuilder(50);
                        StringBuilder hoursString = new StringBuilder(50);
                        for (Map.Entry me : labels.entrySet()) {
                            Utils.addSeparated(labelString, "/", (String)me.getKey());
                            if ((Integer)me.getValue() <= 0) continue;
                            Utils.addSeparated(hoursString, "/", String.valueOf((Integer)me.getValue() / 60));
                        }
                        this.valueForDownCell = hoursString.toString();
                        if (labels.size() == 0) {
                            labelString.append(TabelDAO.SHORTCUT_FREE_DAY);
                        }
                        return labelString.toString();
                    }
                    return this.valueForDownCell;
                }

                @Override
                public String getDefault(boolean upCell) {
                    return "X";
                }
            });
            HSSFRow rowNext = sheet.getRow(25 + offset + 2);
            for (int k = 0; k < 5; ++k) {
                if (workedForPeriod[k][0] <= 0) continue;
                row.getCell(19 + k).setCellValue((double)workedForPeriod[k][0]);
                rowNext.getCell(19 + k).setCellValue((double)(workedForPeriod[k][1] / 60));
            }
            int pos = 0;
            for (Map.Entry me : neyavkMap.entrySet()) {
                row = sheet.getRow(25 + offset + pos++);
                row.getCell(24).setCellValue((String)me.getKey());
                row.getCell(25).setCellValue((double)((Integer)me.getValue()).intValue());
            }
        }
        return workbook;
    }

    private List<CellRangeAddress> getRangesForCopy(HSSFSheet sheet) {
        ArrayList<CellRangeAddress> rangesForCopy = new ArrayList<CellRangeAddress>();
        for (int i = 0; i < sheet.getNumMergedRegions(); ++i) {
            CellRangeAddress range = sheet.getMergedRegion(i);
            if (25 > range.getFirstRow() || range.getFirstRow() >= 29 || 0 > range.getFirstColumn() || range.getLastColumn() >= 27) continue;
            rangesForCopy.add(range);
        }
        return rangesForCopy;
    }

    private void addDates(Date dateFrom, Date dateTo, HSSFSheet sheet) {
        HSSFRow row = sheet.getRow(14);
        row.getCell(15).setCellValue(TimeUtils.format(dateTo, "ymd"));
        row.getCell(19).setCellValue(TimeUtils.format(dateFrom, "ymd"));
        row.getCell(21).setCellValue(TimeUtils.format(dateTo, "ymd"));
    }

    private void addDays(HSSFSheet sheet, int days, int rowNum, GetForDay adder) {
        int daysInFirstRow = days / 2;
        int d = 1;
        HSSFRow row1 = sheet.getRow(rowNum);
        HSSFRow row2 = sheet.getRow(rowNum + 1);
        for (int c = 1; c <= 16; ++c) {
            int cellnum = 2 + c;
            row1.getCell(cellnum).setCellValue(c <= daysInFirstRow ? String.valueOf(adder.add(d, true)) : adder.getDefault(true));
            row2.getCell(cellnum).setCellValue(c <= daysInFirstRow ? String.valueOf(adder.add(d, false)) : adder.getDefault(false));
            if (c > daysInFirstRow) continue;
            ++d;
        }
        row1 = sheet.getRow(rowNum + 2);
        row2 = sheet.getRow(rowNum + 3);
        while (d <= 31) {
            int cellnum = 2 + d - daysInFirstRow;
            row1.getCell(cellnum).setCellValue(d <= days ? String.valueOf(adder.add(d, true)) : adder.getDefault(true));
            row2.getCell(cellnum).setCellValue(d <= days ? String.valueOf(adder.add(d, false)) : adder.getDefault(false));
            ++d;
        }
    }

    public static void createUserRows(HSSFSheet sheet, int toRow, List<CellRangeAddress> rangesForCopy) {
        for (int rowInd = 0; rowInd < 4; ++rowInd) {
            HSSFRow rowFrom = sheet.getRow(25 + rowInd);
            HSSFRow row = sheet.createRow(toRow + rowInd);
            for (int colInd = 0; colInd < 27; ++colInd) {
                HSSFCell cellFrom = rowFrom.getCell(colInd);
                HSSFCell cell = row.createCell(colInd);
                cell.setCellStyle(cellFrom.getCellStyle());
                cell.setCellValue("");
            }
        }
        int rowDelta = toRow - 25;
        for (CellRangeAddress address : rangesForCopy) {
            sheet.addMergedRegion(new CellRangeAddress(address.getFirstRow() + rowDelta, address.getLastRow() + rowDelta, address.getFirstColumn(), address.getLastColumn()));
        }
    }

    static {
        SHORTCUT_POS.put("\u042f", new int[]{0});
        SHORTCUT_POS.put("\u041d", new int[]{2});
        SHORTCUT_POS.put("\u0421", new int[]{0, 4});
    }

    private static interface GetForDay {
        public String add(int var1, boolean var2);

        public String getDefault(boolean var1);
    }
}

