/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.msg.sms;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.bgerp.app.cfg.Config;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.plugin.msg.sms.Sender;
import org.bgerp.util.Log;
import org.json.JSONObject;

public class SenderTele2
extends Sender {
    private static final Log log = Log.getLog();
    private final String url;
    private final String login;
    private final String password;
    private final String shortcode;

    protected SenderTele2(ConfigMap config) throws Config.InitStopException {
        super(null);
        this.url = config.get("url", "https://newbsms.tele2.ru/api/?operation=send");
        this.shortcode = config.get("shortcode", "bgerp.org");
        this.login = config.get("login");
        this.password = config.get("password");
        this.initWhen(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.login, this.password}));
    }

    @Override
    public void send(String number, String text) {
        try {
            String base64orig = this.login + ":" + this.password;
            String base64encode = Base64.getEncoder().encodeToString(base64orig.getBytes(StandardCharsets.UTF_8));
            CloseableHttpClient httpclient = HttpClients.createDefault();
            HttpPost request = new HttpPost();
            JSONObject bodyRequest = new JSONObject();
            bodyRequest.put("msisdn", (Object)Long.valueOf(number));
            bodyRequest.put("shortcode", (Object)this.shortcode);
            bodyRequest.put("text", (Object)text);
            StringEntity entity = new StringEntity(bodyRequest.toString(), "UTF-8");
            request.setEntity((HttpEntity)entity);
            request.setURI(URI.create(this.url));
            request.addHeader((Header)new BasicHeader("Authorization", "Basic " + base64encode));
            request.addHeader((Header)new BasicHeader("Content-Type", "application/json; charset=utf-8"));
            log.debug("Sending: {}", request);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)request);
            log.debug("Response code: {}", response.getStatusLine().getStatusCode() + ", reason: " + response.getStatusLine().getReasonPhrase());
        }
        catch (Exception e) {
            log.error(e);
        }
    }
}

