/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.git.action;

import org.apache.struts.action.ActionForward;
import org.bgerp.action.base.BaseAction;
import org.bgerp.app.exception.BGException;
import org.bgerp.plugin.git.Config;
import ru.bgcrm.dao.process.ProcessDAO;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;

@ActionServlet.Action(path="/user/plugin/git/process", pathId=true)
public class ProcessAction
extends BaseAction {
    private static final String PATH_JSP = "/WEB-INF/jspf/user/plugin/git";

    @Override
    public ActionForward unspecified(DynActionForm form, ConnectionSet conSet) throws Exception {
        int processId = form.getParamInt("processId", id -> id > 0);
        Config config = this.setup.getConfig(Config.class);
        if (config == null) {
            throw new BGException("GIT plugin isn't configured", new Object[0]);
        }
        String branch = config.branch(conSet, processId);
        String main = config.mainBranch();
        String prefix = config.prefix(processId);
        Process p = new ProcessDAO(conSet.getSlaveConnection()).getProcessOrThrow(processId);
        StringBuilder command = new StringBuilder(100).append("git checkout ").append(main).append(" && git pull --rebase && git checkout -b ").append(branch).append(config.getCreateBranchSuffix());
        form.setResponseData("commandBranchCreate", command.toString());
        command.setLength(0);
        command.append("git checkout ").append(branch).append(" && git pull --rebase").append(" && git fetch origin ").append(main).append(":").append(main).append(" && git merge ").append(main).append(" && git push");
        form.setResponseData("commandBranchSync", command.toString());
        command.setLength(0);
        command.append("git checkout ").append(branch).append(" && git pull --rebase").append(" && git commit --allow-empty -m \"MERGED\"").append(" && git push").append(" && git checkout ").append(main).append(" && git merge --squash ").append(branch).append(" && git commit -am \"").append(prefix).append(" ").append(p.getDescription()).append("\"");
        String author = config.author(conSet, p);
        if (Utils.notBlankString(author)) {
            command.append(" --author=\"").append(author).append("\"");
        }
        form.setResponseData("commandBranchAccept", command.toString());
        command.setLength(0);
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/git/process.jsp");
    }
}

