/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.bil.invoice.dao;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.bgerp.plugin.bil.invoice.model.Invoice;
import org.bgerp.util.sql.PreparedQuery;
import ru.bgcrm.dao.CommonDAO;

public class InvoiceNumberDAO
extends CommonDAO {
    private final Invoice invoice;
    private final PreparedQuery pq;

    public InvoiceNumberDAO(Connection con, Invoice invoice) {
        super(con);
        this.invoice = invoice;
        this.pq = new PreparedQuery(con, "SELECT MAX(number_cnt) FROM  invoice  WHERE 1>0");
    }

    public InvoiceNumberDAO process() {
        this.pq.addQuery(" AND process_id=?");
        this.pq.addInt(this.invoice.getProcessId());
        return this;
    }

    public InvoiceNumberDAO month() {
        this.pq.addQuery(" AND date_from=?");
        this.pq.addDate(this.invoice.getDateFrom());
        return this;
    }

    public int next() throws SQLException {
        int cnt = 0;
        try (PreparedQuery preparedQuery = this.pq;){
            ResultSet rs = this.pq.executeQuery();
            if (rs.next()) {
                cnt = rs.getInt(1);
            }
        }
        return cnt + 1;
    }
}

