/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.cache;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bgerp.app.cfg.Setup;
import org.bgerp.cache.Cache;
import org.bgerp.cache.CacheHolder;
import org.bgerp.cache.ProcessTypeCache;
import org.bgerp.util.Log;
import ru.bgcrm.dao.process.QueueDAO;
import ru.bgcrm.model.process.queue.Queue;
import ru.bgcrm.model.user.User;

public class ProcessQueueCache
extends Cache<ProcessQueueCache> {
    private static final Log log = Log.getLog();
    private static final CacheHolder<ProcessQueueCache> HOLDER = new CacheHolder<ProcessQueueCache>(new ProcessQueueCache());
    private Map<Integer, Queue> queueMap;
    private List<Queue> queueList;

    public static Queue getQueue(int id, User user) {
        Queue result = ProcessQueueCache.HOLDER.getInstance().queueMap.get(id);
        if (result != null && user != null && !user.getQueueIds().contains(result.getId())) {
            result = null;
        }
        return result;
    }

    public static Queue getQueue(int id) {
        return ProcessQueueCache.HOLDER.getInstance().queueMap.get(id);
    }

    public static Map<Integer, Queue> getQueueMap() {
        return ProcessQueueCache.HOLDER.getInstance().queueMap;
    }

    public static List<Queue> getQueueList() {
        return ProcessQueueCache.HOLDER.getInstance().queueList;
    }

    public static List<Queue> getUserQueueList(User user) {
        ArrayList<Queue> result = new ArrayList<Queue>();
        for (Queue queue : ProcessQueueCache.HOLDER.getInstance().queueList) {
            if (!user.getQueueIds().contains(queue.getId())) continue;
            result.add(queue);
        }
        return result;
    }

    public static void flush(Connection con) {
        HOLDER.flush(con);
    }

    @Override
    protected ProcessQueueCache newInstance() {
        ProcessQueueCache result = new ProcessQueueCache();
        try (Connection con = Setup.getSetup().getDBConnectionFromPool();){
            result.queueMap = new HashMap<Integer, Queue>();
            result.queueList = new ArrayList<Queue>();
            QueueDAO queueDAO = new QueueDAO(con);
            for (Queue queue : queueDAO.getQueueList()) {
                queue.setProcessTypeIds(queueDAO.getQueueProcessTypeIds(queue.getId()));
                log.debug("Queue {} selected process types: {}", queue.getId(), queue.getProcessTypeIds());
                queue.setProcessTypeIds(ProcessTypeCache.getTypeTreeRoot().getSelectedChildIds(queue.getProcessTypeIds()));
                log.debug("Queue {} process types with children: {}", queue.getId(), queue.getProcessTypeIds());
                queue.extractFiltersAndSorts();
                result.queueMap.put(queue.getId(), queue);
                result.queueList.add(queue);
            }
        }
        catch (Exception e) {
            log.error(e);
        }
        return result;
    }
}

