/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.app.servlet.util;

import java.io.CharArrayWriter;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.AbstractAccessLogValve;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.servlet.filter.AuthFilter;
import org.bgerp.util.Log;
import ru.bgcrm.model.user.User;

public class AccessLogValve
extends org.apache.catalina.valves.AccessLogValve {
    private static final Log log = Log.getLog();
    public static final String PARAM_HEADER_NAME_REMOTE_ADDR = "header.name.remote.addr";
    public static final String DIR = "log/access";
    private static final String PREFIX = "access.";
    private static final String DIR_OLD = "log";
    private static final String PREFIX_OLD = "access_log.";

    public AccessLogValve() {
        this.setDirectory(DIR);
        this.setPrefix(PREFIX);
        this.setFileDateFormat("yyyy-MM-dd");
        this.setSuffix(".log");
        this.setRotatable(true);
        this.setMaxDays(Setup.getSetup().getInt("log.access.max.days", 60));
        this.setPattern("%h %S %t %T %s %b \"%r\" ");
        this.moveOldLogs();
        this.setEnabled(true);
    }

    private void moveOldLogs() {
        File dirOld = new File(DIR_OLD);
        File dir = new File(DIR);
        try {
            for (File file2 : dirOld.listFiles(file -> file.isFile() && file.getName().startsWith(PREFIX_OLD))) {
                String name = file2.getName();
                log.info("Renaming and moving access log file '{}'", name);
                file2.renameTo(new File(dir, PREFIX + name.substring(PREFIX_OLD.length()) + ".log"));
            }
        }
        catch (Exception e) {
            log.error(e);
        }
    }

    protected AbstractAccessLogValve.AccessLogElement[] createLogElements() {
        AbstractAccessLogValve.AccessLogElement element = new AbstractAccessLogValve.AccessLogElement(this){

            public void addElement(CharArrayWriter buf, Date date, Request request, Response response, long time) {
                User user;
                String headerNameRemoteAddr = Setup.getSetup().get(AccessLogValve.PARAM_HEADER_NAME_REMOTE_ADDR);
                if (headerNameRemoteAddr != null) {
                    buf.append(headerNameRemoteAddr).append("=").append(request.getHeader(headerNameRemoteAddr)).append(" ");
                }
                if ((user = AuthFilter.getUser((HttpServletRequest)request)) != null) {
                    buf.append("UID=").append(String.valueOf(user.getId())).append(" ");
                }
                Map paramMap = request.getParameterMap();
                for (Map.Entry me : paramMap.entrySet()) {
                    String key = (String)me.getKey();
                    String[] values = (String[])me.getValue();
                    buf.append(key).append("=");
                    boolean first = true;
                    for (String value : values) {
                        if (!first) {
                            buf.append(" ");
                        }
                        buf.append(value);
                        first = false;
                    }
                    buf.append("&");
                }
            }
        };
        ArrayList<AbstractAccessLogValve.AccessLogElement> superList = new ArrayList<AbstractAccessLogValve.AccessLogElement>();
        for (AbstractAccessLogValve.AccessLogElement superEl : super.createLogElements()) {
            superList.add(superEl);
        }
        superList.add(element);
        return superList.toArray(new AbstractAccessLogValve.AccessLogElement[0]);
    }
}

