/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.app.dist.inst.call;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileInputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipInputStream;
import org.apache.commons.lang3.StringUtils;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.dist.inst.call.InstallationCall;
import org.bgerp.util.Log;
import org.bgerp.util.sql.PreparedQuery;
import ru.bgcrm.dao.CommonDAO;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.ZipUtils;
import ru.bgcrm.util.sql.SQLUtils;

public class ExecuteSQL
extends CommonDAO
implements InstallationCall {
    private static final Log log = Log.getLog();
    private static final String TABLE_DB_UPDATE = "db_update_log";
    private static final String HASH_COLUMN = "query_hash";

    public static void clearHashes() throws SQLException {
        try (Connection con = Setup.getSetup().getDBConnectionFromPool();){
            con.createStatement().executeUpdate("DELETE FROM db_update_log");
            con.commit();
        }
    }

    public static void skipHash(String hash) throws SQLException {
        try (Connection con = Setup.getSetup().getDBConnectionFromPool();
             PreparedQuery pq = new PreparedQuery(con, "INSERT INTO db_update_log(query_hash, dt) VALUES (?, NOW())");){
            pq.addString(hash).executeUpdate();
            con.commit();
        }
    }

    @Override
    public void call(Setup setup, File zip, String param) throws Exception {
        block12: {
            try (FileInputStream fis = new FileInputStream(zip);){
                Map<String, byte[]> map = ZipUtils.getEntriesFromZip(new ZipInputStream(fis), param);
                if (!map.containsKey(param)) {
                    log.error("Can't find {} in module zip", param);
                    break block12;
                }
                try (Connection con = setup.getDBConnectionFromPool();){
                    byte[] file = map.get(param);
                    String query = new String(file, StandardCharsets.UTF_8);
                    this.call(con, query);
                    log.info("Executing database update...OK", new Object[0]);
                }
            }
        }
    }

    public void call(Connection con, String query) throws SQLException {
        String[] queries = query.split(";\\s*\n");
        this.executeSqlCommands(con, queries);
        con.commit();
    }

    private void executeSqlCommands(Connection con, String[] queries) throws SQLException {
        Set<String> existingHashes = this.getQueryHashes(con);
        TreeSet<String> newHashes = new TreeSet<String>();
        StringBuilder blockQuery = null;
        boolean blockUseHash = true;
        Statement st = con.createStatement();
        for (String query : queries) {
            if (Utils.isBlankString(query)) continue;
            if (query.indexOf("#BLOCK#") >= 0) {
                blockQuery = new StringBuilder();
                blockUseHash = query.indexOf("#NO_HASH#") < 0;
                continue;
            }
            if (query.indexOf("#ENDB#") >= 0) {
                if (blockQuery == null) {
                    throw new IllegalStateException("Block query hasn't started.");
                }
                String blockQueryStr = blockQuery.toString().replaceAll("delimiter\\s*\\$\\$", "").replaceAll("delimiter\\s*;", "").replaceAll("END\\$\\$", "END;");
                this.doQuery(st, blockQueryStr, blockUseHash, existingHashes, newHashes);
                blockQuery = null;
                continue;
            }
            if (query.startsWith("--") && Utils.isBlankString(query = StringUtils.substringAfter((String)query, (String)"\n"))) continue;
            if (blockQuery != null) {
                blockQuery.append(query).append(";\n");
                continue;
            }
            this.doQuery(st, query, true, existingHashes, newHashes);
        }
        st.close();
        if (!newHashes.isEmpty()) {
            this.addHashes(con, newHashes);
        }
    }

    protected void doQuery(Statement st, String query, boolean useHash, Set<String> existingHashes, Set<String> newHashes) throws SQLException {
        String hash = Utils.getDigest(query);
        if (useHash && existingHashes.contains(hash)) {
            return;
        }
        if (!useHash) {
            hash = "NO_HASH";
            existingHashes = null;
            newHashes = null;
        }
        try {
            long time = System.currentTimeMillis();
            st.executeUpdate(query);
            log.info("OK ({} ms.) => [{}] {}", System.currentTimeMillis() - time, hash, query);
            if (useHash) {
                newHashes.add(hash);
            }
        }
        catch (SQLException ex) {
            throw new SQLException(ex.getMessage() + " => [" + hash + "] " + query, ex);
        }
    }

    protected Set<String> getQueryHashes(Connection con) throws SQLException {
        TreeSet<String> result = new TreeSet<String>();
        if (!SQLUtils.tableExists(con, TABLE_DB_UPDATE)) {
            String sql = "CREATE TABLE IF NOT EXISTS db_update_log(dt DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP, query_hash CHAR(32) NOT NULL,  PRIMARY KEY (query_hash))";
            con.createStatement().executeUpdate(sql);
            return result;
        }
        String query = "SELECT query_hash FROM db_update_log";
        try (PreparedStatement ps = con.prepareStatement(query);){
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(rs.getString(1));
            }
        }
        return result;
    }

    @VisibleForTesting
    protected void addHashes(Connection con, Set<String> hashes) throws SQLException {
        if (hashes.isEmpty()) {
            return;
        }
        String sql = "INSERT INTO db_update_log(query_hash) VALUES (?)";
        try (PreparedStatement ps = con.prepareStatement(sql);){
            for (String hash : hashes) {
                ps.setString(1, hash);
                ps.executeUpdate();
            }
        }
    }
}

