/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.action.open;

import java.sql.Connection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.struts.action.ActionForward;
import org.bgerp.action.base.BaseAction;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.servlet.Interface;
import org.bgerp.cache.ParameterCache;
import org.bgerp.dao.message.MessageSearchDAO;
import org.bgerp.model.Pageable;
import org.bgerp.model.msg.Message;
import ru.bgcrm.dao.process.ProcessDAO;
import ru.bgcrm.dao.process.SecretExpression;
import ru.bgcrm.model.Page;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;

@ActionServlet.Action(path="/open/process")
public class ProcessAction
extends BaseAction {
    private static final String PATH_JSP = "/WEB-INF/jspf/open/process";

    public ActionForward show(DynActionForm form, ConnectionSet conSet) throws Exception {
        Config config = this.setup.getConfig(Config.class);
        if (config == null) {
            return null;
        }
        Connection con = conSet.getSlaveConnection();
        Process process = new ProcessDAO(con).getProcess(form.getId());
        if (config == null || !config.isOpen(process, form)) {
            return null;
        }
        form.setRequestAttribute("config", config);
        form.setResponseData("process", process);
        return this.html(conSet, null, "/WEB-INF/jspf/open/process/show.jsp");
    }

    public ActionForward messages(DynActionForm form, ConnectionSet conSet) throws Exception {
        Config config = this.setup.getConfig(Config.class);
        Process process = new ProcessDAO(conSet.getSlaveConnection()).getProcess(form.getId());
        if (config == null || !config.isOpen(process, form) || config.getShowMessagesTagIds() == null) {
            return null;
        }
        Pageable<Message> result = new Pageable<Message>(form);
        result.getPage().setPageIndex(Page.PAGE_INDEX_NO_PAGING);
        new MessageSearchDAO(conSet.getSlaveConnection()).withProcessIds(Set.of(Integer.valueOf(form.getId()))).withTagIds(config.getShowMessagesTagIds()).search(result);
        return this.html(conSet, null, "/WEB-INF/jspf/open/process/messages.jsp");
    }

    public static class Config
    extends org.bgerp.app.cfg.Config {
        private final Set<Integer> processTypeIds;
        private final List<Integer> showParamIds;
        private final Set<Integer> showMessagesTagIds;
        private final boolean showLinkCustomer;
        private final SecretExpression secret;

        protected Config(ConfigMap config, boolean validate) throws Exception {
            super(null);
            String messageTagIds;
            this.processTypeIds = Utils.toIntegerSet(config.get("process.open.typeIds"));
            this.initWhen(CollectionUtils.isNotEmpty(this.processTypeIds));
            this.secret = new SecretExpression(config.get("process.open.secret.expression"));
            this.showParamIds = Utils.toIntegerList(config.get("process.open.show.paramIds"));
            if (this.showParamIds.isEmpty()) {
                this.throwValidationException("Param ID list is not defined", new Object[0]);
            }
            if (ParameterCache.getParameterList(this.showParamIds).size() != this.showParamIds.size()) {
                this.throwValidationException("Some of param IDs do not exist", new Object[0]);
            }
            this.showMessagesTagIds = "*".equals(messageTagIds = config.get("process.open.show.message.tagIds")) ? Collections.emptySet() : Utils.toIntegerSet(messageTagIds);
            this.showLinkCustomer = config.getBoolean("process.open.show.link.customer", false);
        }

        public boolean isOpenForUser(Process process) {
            return process != null && this.processTypeIds.contains(process.getTypeId());
        }

        public boolean isOpen(Process process, DynActionForm form) {
            return this.isOpenForUser(process) && this.secret.check(process, form);
        }

        public String url(Process process) {
            return Interface.getUrlOpen() + "/process/" + process.getId() + this.secret.queryString(process);
        }

        public List<Integer> getShowParamIds() {
            return this.showParamIds;
        }

        public Set<Integer> getShowMessagesTagIds() {
            return this.showMessagesTagIds;
        }

        public boolean isShowLinkCustomer() {
            return this.showLinkCustomer;
        }
    }
}

