<%@ page contentType="text/css; charset=UTF-8"%>

/* Plugin AixFlow - Стили для диаризации и интерфейса */

/* Стили для диаризации */
.diarization-container {
    background: #ffffff;
    border-radius: 8px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    margin: 15px 0;
    overflow: hidden;
    transition: all 0.3s ease;
}

.diarization-container:hover {
    box-shadow: 0 4px 16px rgba(0,0,0,0.15);
    transform: translateY(-2px);
}

.diarization-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 10px 14px; /* компактнее */
    font-weight: 600;
    font-size: 13px;   /* компактнее */
    display: flex;
    align-items: center;
    gap: 8px;
}

.diarization-header::before {
    content: "🎤";
    font-size: 16px;
}

.diarization-content {
    padding: 12px;          /* компактнее */
    max-height: 400px;
    overflow-y: auto;
    background: #fafbfc;
    display: grid;          /* карточки в колонках на широких экранах */
    grid-template-columns: 1fr;
    gap: 10px;
}

@media (min-width: 900px) {
    .diarization-content {
        grid-template-columns: 1fr 1fr; /* две колонки, чтобы уменьшить высоту */
    }
}

.diarization-item {
    margin: 0;              /* используется gap у грид-контейнера */
    padding: 10px;          /* компактнее */
    background: #ffffff;
    border-radius: 8px;
    border-left: 3px solid #e9ecef; /* тоньше акцент */
    transition: box-shadow 0.2s ease, transform 0.2s ease;
    animation: fadeIn 0.25s ease-in;
    box-shadow: 0 1px 4px rgba(0,0,0,0.06);
}

.diarization-item:hover {
    transform: translateY(-1px);
    box-shadow: 0 4px 12px rgba(0,0,0,0.10);
}

.diarization-item:last-child {
    margin-bottom: 0;
}

.speaker-label {
    display: inline-block;
    padding: 2px 8px;        /* компактнее */
    border-radius: 10px;
    font-size: 10px;         /* компактнее */
    font-weight: 700;
    text-transform: uppercase;
    letter-spacing: 0.6px;
    margin-bottom: 6px;
    min-width: 52px;
    text-align: center;
}

.speaker-operator { /* лёгкий фон вместо сплошной заливки */
    background: #f4f8ff;
    border-left-color: #1976d2;
}

.speaker-operator .speaker-label {
    background: #e3efff;
    color: #0d47a1;
}

.speaker-customer {
    background: #eefaf1;
    border-left-color: #2e7d32;
}

.speaker-customer .speaker-label {
    background: #def4e4;
    color: #1b5e20;
}

.speaker-abonent {
    background: #f6f1ff;
    border-left-color: #6f42c1;
}

.speaker-abonent .speaker-label {
    background: #efe3ff;
    color: #4527a0;
}

.speaker-text {
    font-size: 13px;      /* компактнее */
    line-height: 1.45;    /* компактнее */
    color: #22313f;
    margin: 0;
    word-wrap: break-word;
    font-style: normal;   /* убрать случайный курсив */
}

/* Сокращение длинного текста с возможностью разворота */
.speaker-text.collapsed {
    display: -webkit-box;
    -webkit-line-clamp: 6;        /* показывать до 6 строк */
    -webkit-box-orient: vertical;
    overflow: hidden;
    position: relative;
}

.speaker-text.collapsed:after {
    content: '';
    position: absolute;
    left: 0; right: 0; bottom: 0;
    height: 26px;
    background: linear-gradient(to bottom, rgba(255,255,255,0), rgba(255,255,255,0.85));
    pointer-events: none;
}

.speaker-text.expanded {
    display: block;
}

.diarization-toggle {
    background: none;
    border: none;
    color: #6f42c1;
    cursor: pointer;
    padding: 4px 0 0 0;
    font-size: 12px;
    text-decoration: underline;
}

.diarization-toggle:hover {
    color: #5a32a3;
}

.diarization-stats {
    background: #f8f9fa;
    padding: 12px 16px;
    border-top: 1px solid #e9ecef;
    font-size: 12px;
    color: #6c757d;
    display: flex;
    justify-content: space-between;
    align-items: center;
}

.diarization-stats-item {
    display: flex;
    align-items: center;
    gap: 4px;
}

.diarization-stats-item::before {
    content: "📊";
    font-size: 14px;
}

/* Анимации для индикаторов загрузки */
@keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
}

@keyframes wave {
    0% { transform: translateX(-100%); }
    100% { transform: translateX(100%); }
}

@keyframes fadeIn {
    from { opacity: 0; transform: translateY(10px); }
    to { opacity: 1; transform: translateY(0); }
}

@keyframes newFilePulse {
    0% {
        background-color: #ffffff;
        transform: scale(1);
    }
    50% {
        background-color: #d4edda;
        transform: scale(1.02);
    }
    100% {
        background-color: #d4edda;
        transform: scale(1);
    }
}

/* Drag & Drop стили */
.drop-zone {
    border: 2px dashed #ccc;
    border-radius: 10px;
    padding: 40px;
    text-align: center;
    background-color: #f9f9f9;
    transition: all 0.3s ease;
    cursor: pointer;
    margin: 20px 0;
}

.drop-zone:hover {
    border-color: #007bff;
    background-color: #f0f8ff;
}

.drop-zone.drag-over {
    border-color: #28a745;
    background-color: #d4edda;
    transform: scale(1.02);
}

.drop-zone.drag-over .drop-zone-content {
    transform: scale(1.05);
}

.drop-zone-content {
    transition: transform 0.3s ease;
}

/* Стили для статусов файлов */
.file-status-processing {
    color: #ffc107;
    font-weight: bold;
}

.file-status-completed {
    color: #28a745;
    font-weight: bold;
}

.file-status-error {
    color: #dc3545;
    font-weight: bold;
}

.file-status-queued {
    color: #17a2b8;
    font-weight: bold;
}

/* Стили для новых файлов */
.new-file-highlight {
    background-color: #d4edda !important;
    border: 2px solid #28a745 !important;
    animation: newFilePulse 0.5s ease-in-out;
}

/* Стили для компонентов */
.file-info-panel {
    background-color: #f8f9fa;
    padding: 10px;
    border: 1px solid #dee2e6;
    border-radius: 4px;
    margin: 5px 0;
}

.progress-bar {
    width: 100%;
    background-color: #e0e0e0;
    border-radius: 10px;
    overflow: hidden;
    height: 20px;
}

.progress-fill {
    height: 100%;
    background-color: #4CAF50;
    transition: width 0.3s ease;
}

/* Стили для медиа плееров */
.media-player {
    margin: 10px 0;
    border-radius: 8px;
    overflow: hidden;
    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
}

.media-player audio,
.media-player video {
    width: 100%;
    height: auto;
}

/* Стили для аналитики */
.analytics-panel {
    background: white;
    border-radius: 8px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
    margin: 15px 0;
    overflow: hidden;
}

.analytics-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 12px 16px;
    font-weight: 600;
    font-size: 14px;
    display: flex;
    align-items: center;
    gap: 8px;
}

.analytics-header::before {
    content: "📊";
    font-size: 16px;
}

.analytics-content {
    padding: 16px;
    background: #fafbfc;
}

.grid-container {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 15px;
    width: 100%;
}

.analytics-item {
    background: white;
    padding: 12px;
    border-radius: 6px;
    border-left: 4px solid #007bff;
}

.analytics-item h4 {
    margin: 0 0 8px 0;
    color: #007bff;
}

.analytics-item ul {
    margin: 0;
    padding-left: 20px;
}

/* Кнопка .btn-purple */
.btn-purple {
    background-color: #6f42c1;
    color: white;
    border: none;
    padding: 8px 16px;
    border-radius: 4px;
    cursor: pointer;
    font-size: 14px;
    margin-left: 5px;
}

.btn-purple:hover {
    background-color: #5a32a3;
}

/* N8n статус кнопка */
.n8n-status-button {
    margin-left: 5px;
}

/* Панель речевой аналитики */
.speech-analytics-panel {
    animation: slideDown 0.3s ease-out;
    width: 100%;
    box-sizing: border-box;
    overflow: visible;
    position: relative;
    z-index: 1000;
}

.speech-analytics-panel .grid-container {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 15px;
    width: 100%;
}

/* Аудио и видео плееры */
.audio-player, .video-player {
    margin-top: 10px;
    padding: 10px;
    background-color: #f5f5f5;
    border-radius: 5px;
    border: 1px solid #ddd;
}

/* Стили для файловых строк */
.file-row:hover {
    background-color: #f8f9fa;
}

/* Стили для файлов со статусами */
.file-row.status-completed {
    background-color: #f0f9f0 !important;
    border-left: 4px solid #90EE90 !important;
}

.file-row.status-error {
    background-color: #fdf0f0 !important;
    border-left: 4px solid #FFB6C1 !important;
}

.file-row.status-processing {
    background-color: #fff8f0 !important;
    border-left: 4px solid #FFE4B5 !important;
}

.file-row.status-queued {
    background-color: #f0f8ff !important;
    border-left: 4px solid #87CEEB !important;
}

.file-row.has-analytics {
    background-color: #f8f0ff !important;
    border-left: 4px solid #DDA0DD !important;
}

/* Диаризация: отдельная подсветка */
.file-row.has-diarization {
    background-color: #f0f8ff !important; /* светло-голубой */
    border-left: 4px solid #87CEFA !important;
}

/* Комбинированные статусы */
.file-row.status-completed.has-analytics {
    background-color: #f0f4f0 !important;
    border-left: 4px solid #98FB98 !important;
}

.file-row.status-error.has-analytics {
    background-color: #faf0f0 !important;
    border-left: 4px solid #F0B6C1 !important;
}

@keyframes slideDown {
    from {
        opacity: 0;
        transform: translateY(-10px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

/* Responsive стили */
@media (max-width: 768px) {
    .grid-container {
        grid-template-columns: 1fr;
    }
    
    .diarization-stats {
        flex-direction: column;
        gap: 8px;
    }
    
    .drop-zone {
        padding: 20px;
    }
    
    .speech-analytics-panel .grid-container {
        grid-template-columns: 1fr;
    }
}
