<%@ page contentType="text/html; charset=UTF-8"%>
<%@ include file="/WEB-INF/jspf/taglibs.jsp"%>

<div class="center1020">
 <c:set var="n8nUrl" value="${frd.n8nUrl}"/>
	<c:set var="n8nApiKeyConfigured" value="${frd.n8nApiKeyConfigured}"/>
	<c:set var="n8nRequestMethod" value="${frd.n8nRequestMethod}"/>
	<c:set var="n8nAuthUsernameConfigured" value="${frd.n8nAuthUsernameConfigured}"/>
	<c:set var="n8nAuthPasswordConfigured" value="${frd.n8nAuthPasswordConfigured}"/>

	<shell:title text="N8n Connection Check"/>
	<shell:state help="plugin/aixflow/index.html#usage-admin-n8n-check"/>

	<div class="box">
		<h2>N8n Connection Settings</h2>
		<div class="box-content">
			<div class="form-row">
				<div class="form-title">N8n URL:</div>
				<div class="form-input">
					<span id="n8nUrl">${n8nUrl}</span>
					<c:if test="${empty n8nUrl}">
						<span class="error">Not configured</span>
					</c:if>
				</div>
			</div>
			<div class="form-row">
				<div class="form-title">N8n API Key:</div>
				<div class="form-input">
					<c:choose>
						<c:when test="${n8nApiKeyConfigured}">
							<span class="success">Configured</span>
						</c:when>
						<c:otherwise>
							<span class="error">Not configured</span>
						</c:otherwise>
					</c:choose>
				</div>
			</div>
			<div class="form-row">
				<div class="form-title">Basic Auth Username:</div>
				<div class="form-input">
					<c:choose>
						<c:when test="${n8nAuthUsernameConfigured}">
							<span class="success">Configured</span>
						</c:when>
						<c:otherwise>
							<span class="error">Not configured</span>
						</c:otherwise>
					</c:choose>
				</div>
			</div>
			<div class="form-row">
				<div class="form-title">Basic Auth Password:</div>
				<div class="form-input">
					<c:choose>
						<c:when test="${n8nAuthPasswordConfigured}">
							<span class="success">Configured</span>
						</c:when>
						<c:otherwise>
							<span class="error">Not configured</span>
						</c:otherwise>
					</c:choose>
				</div>
			</div>
			<div class="form-row">
				<div class="form-title">Request Method:</div>
				<div class="form-input">
					<span id="n8nRequestMethod">${n8nRequestMethod}</span>
				</div>
			</div>
			<div class="form-row">
				<div class="form-title"></div>
				<div class="form-input">
					<button type="button" id="testConnectionBtn" class="btn-grey">Test Connection</button>
				</div>
			</div>
			<div class="form-row" id="connectionResult" style="display: none;">
				<div class="form-title">Connection Status:</div>
				<div class="form-input">
					<div id="connectionStatus"></div>
					<div id="connectionMessage"></div>
				</div>
			</div>
			<div class="form-row" id="authMethodContainer" style="display: none;">
				<div class="form-title">Authentication Method:</div>
				<div class="form-input">
					<div id="authMethodUsed"></div>
				</div>
			</div>
			<div class="form-row" id="diagnosticInfoContainer" style="display: none;">
				<div class="form-title">Diagnostic Information:</div>
				<div class="form-input">
					<pre id="diagnosticInfo" class="diagnostic-info"></pre>
				</div>
			</div>
		</div>
	</div>
</div>

<script>
$(document).ready(function() {
	$("#testConnectionBtn").click(function() {
		$(this).prop("disabled", true).text("Testing...");

		$.ajax({
			url: "/admin/plugin/aixflow/admin_n8n_check.do",
			data: {
				action: "testConnection"
			},
			dataType: "json",
			success: function(data) {
				$("#connectionResult").show();

				// Get success status from either top level or data object
				var success = data.success || (data.data && data.data.success) || false;

				if (success) {
					$("#connectionStatus").html('<span class="success">Success</span>');
				} else {
					$("#connectionStatus").html('<span class="error">Failed</span>');
				}

				// Always show diagnostic info if available
				console.log("Diagnostic info:", data.diagnosticInfo);
				console.log("Data object:", data.data);

				// Check if diagnosticInfo is in the data object
				var diagInfo = data.diagnosticInfo || (data.data && data.data.diagnosticInfo);
				console.log("Found diagnostic info:", diagInfo);

				if (diagInfo) {
					$("#diagnosticInfo").text(diagInfo);
					$("#diagnosticInfoContainer").show();
				} else {
					$("#diagnosticInfoContainer").hide();
				}

				// Debug output to console
				console.log("Response data:", data);

				// Get message from either top level or data object
				var message = data.message || (data.data && data.data.message) || "";
				$("#connectionMessage").text(message);

				// Display which authentication method was used
				var useBasicAuth = data.useBasicAuth || (data.data && data.data.useBasicAuth) || false;
				if (useBasicAuth) {
					$("#authMethodUsed").html('<span class="info">Using Basic Authentication</span>');
				} else {
					$("#authMethodUsed").html('<span class="info">Using API Key Authentication</span>');
				}
				$("#authMethodContainer").show();

				$("#testConnectionBtn").prop("disabled", false).text("Test Connection");
			},
			error: function(xhr, status, error) {
				$("#connectionResult").show();
				$("#connectionStatus").html('<span class="error">Error</span>');
				$("#connectionMessage").text("An error occurred while testing the connection: " + error);

				// Add diagnostic info for AJAX errors
				var diagnosticText = "AJAX Error Details:\n";
				diagnosticText += "- Status: " + status + "\n";
				diagnosticText += "- Error: " + error + "\n";

				if (xhr.responseText) {
					diagnosticText += "- Response Text: " + xhr.responseText + "\n";

					// Try to parse the response text as JSON to extract any diagnostic info
					try {
						var responseData = JSON.parse(xhr.responseText);
						console.log("Parsed error response:", responseData);

						// Check if diagnosticInfo is in the response data
						var errorDiagInfo = responseData.diagnosticInfo || 
							(responseData.data && responseData.data.diagnosticInfo);

						if (errorDiagInfo) {
							diagnosticText += "\nServer Diagnostic Information:\n" + errorDiagInfo;
						}
					} catch (e) {
						console.log("Could not parse error response as JSON:", e);
					}
				}

				$("#diagnosticInfo").text(diagnosticText);
				$("#diagnosticInfoContainer").show();

				$("#testConnectionBtn").prop("disabled", false).text("Test Connection");
			}
		});
	});
});
</script>

<style>
.success {
	color: green;
	font-weight: bold;
}
.error {
	color: red;
	font-weight: bold;
}
.info {
	color: blue;
	font-weight: bold;
}
.diagnostic-info {
	background-color: #f5f5f5;
	border: 1px solid #ddd;
	border-radius: 4px;
	padding: 10px;
	font-family: monospace;
	white-space: pre-wrap;
	max-height: 400px;
	overflow-y: auto;
	font-size: 14px;
	line-height: 1.5;
	margin-top: 10px;
	display: block;
	width: 100%;
}
</style>
