/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.ai.aixflow.model;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.bgerp.dao.FileDataDAO;
import org.bgerp.model.file.FileData;
import org.bgerp.plugin.ai.aixflow.model.AixFlowFileData;
import ru.bgcrm.dao.CommonDAO;

public class AixFlowFileDataDAO
extends CommonDAO {
    private static final String TABLE = " aixflow_file_data ";

    public AixFlowFileDataDAO(Connection con) {
        super(con);
    }

    public void add(AixFlowFileData afd) throws SQLException {
        String sql = "INSERT INTO  aixflow_file_data  (file_data_id, filename) VALUES (?, ?)";
        try (PreparedStatement ps = this.con.prepareStatement(sql, 1);){
            ps.setInt(1, afd.getFileDataId());
            ps.setString(2, afd.getFilename());
            ps.executeUpdate();
            afd.setId(this.lastInsertId(ps));
        }
    }

    public AixFlowFileData getByFileDataId(int fileDataId) throws SQLException {
        String sql = "SELECT  id, file_data_id, filename FROM  aixflow_file_data  WHERE  file_data_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(sql);){
            ps.setInt(1, fileDataId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    AixFlowFileData afd = new AixFlowFileData();
                    afd.setId(rs.getInt("id"));
                    afd.setFileDataId(rs.getInt("file_data_id"));
                    afd.setFilename(rs.getString("filename"));
                    AixFlowFileData aixFlowFileData = afd;
                    return aixFlowFileData;
                }
            }
        }
        return null;
    }

    public AixFlowFileData getByFilename(String filename) throws SQLException {
        String sql = "SELECT  id, file_data_id, filename FROM  aixflow_file_data  WHERE  filename=?";
        try (PreparedStatement ps = this.con.prepareStatement(sql);){
            ps.setString(1, filename);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    AixFlowFileData afd = new AixFlowFileData();
                    afd.setId(rs.getInt("id"));
                    afd.setFileDataId(rs.getInt("file_data_id"));
                    afd.setFilename(rs.getString("filename"));
                    AixFlowFileData aixFlowFileData = afd;
                    return aixFlowFileData;
                }
            }
        }
        return null;
    }

    public void updateFilename(int id, String filename) throws SQLException {
        String sql = "UPDATE  aixflow_file_data  SET filename=?  WHERE  id=?";
        try (PreparedStatement ps = this.con.prepareStatement(sql);){
            ps.setString(1, filename);
            ps.setInt(2, id);
            ps.executeUpdate();
        }
    }

    public void deleteById(int id) throws SQLException {
        String sql = "DELETE FROM  aixflow_file_data  WHERE  id=?";
        try (PreparedStatement ps = this.con.prepareStatement(sql);){
            ps.setInt(1, id);
            ps.executeUpdate();
        }
    }

    public void deleteByFilename(String filename) throws SQLException {
        String sql = "DELETE FROM  aixflow_file_data  WHERE  filename=?";
        try (PreparedStatement ps = this.con.prepareStatement(sql);){
            ps.setString(1, filename);
            ps.executeUpdate();
        }
    }

    public FileData getFileData(int fileDataId) throws SQLException {
        String sql = "SELECT * FROM  file_data AS fd  WHERE fd.id=?";
        try (PreparedStatement ps = this.con.prepareStatement(sql);){
            ps.setInt(1, fileDataId);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    FileData fileData = FileDataDAO.getFromRs(rs, "fd.");
                    return fileData;
                }
            }
        }
        return null;
    }
}

