/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.ai.aixflow.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.bgerp.plugin.ai.aixflow.model.FileN8nTask;
import org.bgerp.util.Log;
import org.bgerp.util.TimeConvert;
import ru.bgcrm.dao.CommonDAO;

public class FileN8nTaskDAO
extends CommonDAO {
    private static final Log log = Log.getLog();

    public FileN8nTaskDAO(Connection con) {
        super(con);
    }

    public FileN8nTask create(FileN8nTask task) throws SQLException {
        log.debug("Creating new n8n task for file ID: {}", task.getFileId());
        String query = "INSERT INTO  file_n8n_tasks  (file_id, task_id, n8n_task_id, status, create_dt, update_dt) VALUES (?, ?, ?, ?, ?, ?)";
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            ps.setInt(1, task.getFileId());
            ps.setString(2, task.getTaskId());
            ps.setString(3, task.getN8nTaskId());
            ps.setString(4, task.getStatus());
            ps.setTimestamp(5, TimeConvert.toTimestamp(task.getCreateDt()));
            ps.setTimestamp(6, TimeConvert.toTimestamp(task.getUpdateDt()));
            ps.executeUpdate();
            task.setId(this.lastInsertId(ps));
            log.debug("Created n8n task with ID: {}", task.getId());
        }
        return task;
    }

    public FileN8nTask getById(int id) throws SQLException {
        log.debug("Getting n8n task by ID: {}", id);
        String query = "SELECT * FROM  file_n8n_tasks  WHERE id = ?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                FileN8nTask fileN8nTask = this.getFromRs(rs);
                return fileN8nTask;
            }
        }
        log.debug("Task with ID {} not found", id);
        return null;
    }

    public List<FileN8nTask> getByFileId(int fileId) throws SQLException {
        log.debug("Getting n8n tasks for file ID: {}", fileId);
        ArrayList<FileN8nTask> result = new ArrayList<FileN8nTask>();
        String query = "SELECT * FROM  file_n8n_tasks  WHERE file_id = ? ORDER BY create_dt DESC";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, fileId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getFromRs(rs));
            }
        }
        log.debug("Found {} tasks for file ID {}", result.size(), fileId);
        return result;
    }

    public FileN8nTask getByTaskId(String taskId) throws SQLException {
        log.debug("Getting n8n task by task ID: {}", taskId);
        String query = "SELECT * FROM  file_n8n_tasks  WHERE task_id = ?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setString(1, taskId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                FileN8nTask fileN8nTask = this.getFromRs(rs);
                return fileN8nTask;
            }
        }
        log.debug("Task with task ID {} not found", taskId);
        return null;
    }

    public FileN8nTask getByN8nTaskId(String n8nTaskId) throws SQLException {
        log.debug("Getting n8n task by n8n task ID: {}", n8nTaskId);
        String query = "SELECT * FROM  file_n8n_tasks  WHERE n8n_task_id = ?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setString(1, n8nTaskId);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                FileN8nTask fileN8nTask = this.getFromRs(rs);
                return fileN8nTask;
            }
        }
        log.debug("Task with n8n task ID {} not found", n8nTaskId);
        return null;
    }

    public boolean updateTaskStatus(String taskId, String status, String result, String errorMessage) throws SQLException {
        log.debug("Updating n8n task status: taskId={}, status={}", taskId, status);
        String query = "UPDATE  file_n8n_tasks  SET status = ?, update_dt = ?, result = ?, error_message = ? WHERE task_id = ?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setString(1, status);
            ps.setTimestamp(2, TimeConvert.toTimestamp(new Date()));
            ps.setString(3, result);
            ps.setString(4, errorMessage);
            ps.setString(5, taskId);
            int updated = ps.executeUpdate();
            log.debug("Updated {} rows", updated);
            boolean bl = updated > 0;
            return bl;
        }
    }

    public boolean updateN8nTaskId(String taskId, String n8nTaskId) throws SQLException {
        log.debug("Updating n8n task ID: taskId={}, n8nTaskId={}", taskId, n8nTaskId);
        String query = "UPDATE  file_n8n_tasks  SET n8n_task_id = ?, update_dt = ? WHERE task_id = ?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setString(1, n8nTaskId);
            ps.setTimestamp(2, TimeConvert.toTimestamp(new Date()));
            ps.setString(3, taskId);
            int updated = ps.executeUpdate();
            log.debug("Updated {} rows", updated);
            boolean bl = updated > 0;
            return bl;
        }
    }

    public boolean delete(int id) throws SQLException {
        log.debug("Deleting n8n task with ID: {}", id);
        String query = "DELETE FROM  file_n8n_tasks  WHERE id = ?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            int deleted = ps.executeUpdate();
            log.debug("Deleted {} rows", deleted);
            boolean bl = deleted > 0;
            return bl;
        }
    }

    public List<FileN8nTask> getAllTasks(String status, int limit) throws SQLException {
        log.debug("Getting all n8n tasks with status filter: {}, limit: {}", status, limit);
        ArrayList<FileN8nTask> result = new ArrayList<FileN8nTask>();
        StringBuilder queryBuilder = new StringBuilder("SELECT * FROM  file_n8n_tasks ");
        if (status != null && !status.isEmpty()) {
            queryBuilder.append(" WHERE status = ?");
        }
        queryBuilder.append(" ORDER BY create_dt DESC");
        if (limit > 0) {
            queryBuilder.append(" LIMIT ?");
        }
        String query = queryBuilder.toString();
        log.debug("Query: {}", query);
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int paramIndex = 1;
            if (status != null && !status.isEmpty()) {
                ps.setString(paramIndex++, status);
            }
            if (limit > 0) {
                ps.setInt(paramIndex, limit);
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getFromRs(rs));
            }
        }
        log.debug("Found {} tasks", result.size());
        return result;
    }

    private FileN8nTask getFromRs(ResultSet rs) throws SQLException {
        FileN8nTask task = new FileN8nTask();
        task.setId(rs.getInt("id"));
        task.setFileId(rs.getInt("file_id"));
        task.setTaskId(rs.getString("task_id"));
        task.setN8nTaskId(rs.getString("n8n_task_id"));
        task.setStatus(rs.getString("status"));
        task.setCreateDt(rs.getTimestamp("create_dt"));
        task.setUpdateDt(rs.getTimestamp("update_dt"));
        task.setResult(rs.getString("result"));
        task.setErrorMessage(rs.getString("error_message"));
        return task;
    }
}

