-- SQL for AixFlow plugin database tables
-- Table for storing n8n processing results
CREATE TABLE IF NOT EXISTS aixflow_results (
    id INT AUTO_INCREMENT PRIMARY KEY,
    filename VARCHAR(255) NOT NULL,
    hash VARCHAR(255) NOT NULL,
    status VARCHAR(50) NOT NULL,
    text TEXT,
    duration_sec VARCHAR(50),
    time_sec VARCHAR(50),
    n8n_filename VARCHAR(255),
    raw_response JSON,
    diarization_hash VARCHAR(255),
    diarization_status VARCHAR(50),
    diarization_result TEXT,
    diarization_raw_response JSON,
    created TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    UNIQUE KEY unique_hash (hash),
    KEY idx_filename (filename),
    KEY idx_status (status),
    KEY idx_diarization_hash (diarization_hash),
    KEY idx_diarization_status (diarization_status)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Mapping table between AixFlow entities and kernel file_data
CREATE TABLE IF NOT EXISTS aixflow_file_data (
    id INT AUTO_INCREMENT PRIMARY KEY,
    file_data_id INT NOT NULL,
    filename VARCHAR(255) NOT NULL,
    created TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    UNIQUE KEY ux_file_data_id (file_data_id),
    KEY idx_filename (filename)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Add raw_response column to existing tables for backward compatibility
CALL add_column_if_not_exists('aixflow_results', 'raw_response', 'JSON');

-- Add diarization columns
CALL add_column_if_not_exists('aixflow_results', 'diarization_hash', 'VARCHAR(255)');
CALL add_column_if_not_exists('aixflow_results', 'diarization_status', 'VARCHAR(50)');
CALL add_column_if_not_exists('aixflow_results', 'diarization_result', 'TEXT');
CALL add_column_if_not_exists('aixflow_results', 'diarization_raw_response', 'JSON');