/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.report.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.struts.action.ActionForward;
import org.bgerp.action.base.BaseAction;
import org.bgerp.action.base.TitledAction;
import org.bgerp.action.base.TitledActionFactory;
import org.bgerp.app.exception.BGIllegalArgumentException;
import org.bgerp.model.base.iface.Title;
import org.bgerp.plugin.report.model.Columns;
import org.bgerp.plugin.report.model.Data;
import org.bgerp.plugin.report.model.chart.Chart;
import org.bgerp.util.Log;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import ru.bgcrm.dao.CommonDAO;
import ru.bgcrm.plugin.Plugin;
import ru.bgcrm.plugin.PluginManager;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.sql.ConnectionSet;

public abstract class ReportActionBase
extends BaseAction
implements Title {
    protected abstract String getHref();

    public abstract Columns getColumns();

    public List<Chart> getCharts() {
        return Collections.emptyList();
    }

    protected abstract String getJsp();

    protected abstract Selector getSelector();

    @Override
    public ActionForward unspecified(DynActionForm form, ConnectionSet conSet) throws Exception {
        Data data = new Data(this, form, this.getColumns());
        form.setRequestAttribute("data", data);
        this.getSelector().select(conSet, data);
        this.charts(form, data);
        return this.html(conSet, form, this.getJsp());
    }

    private void charts(DynActionForm form, Data data) throws BGIllegalArgumentException {
        List<Chart> charts = this.getCharts();
        if (charts.isEmpty()) {
            return;
        }
        int chartIndex = form.getParamInt("chartIndex");
        if (chartIndex <= 0) {
            return;
        }
        if (charts.size() < chartIndex) {
            throw new BGIllegalArgumentException();
        }
        Chart chart = charts.get(chartIndex - 1);
        form.setResponseData("chart", chart.json(form.l, data));
    }

    protected static abstract class Selector
    extends CommonDAO {
        protected Selector() {
        }

        protected abstract void select(ConnectionSet var1, Data var2) throws Exception;
    }

    public static final class Factory
    implements TitledActionFactory {
        private static final Log log = Log.getLog();

        @Override
        public List<TitledAction> create() {
            ArrayList<TitledAction> result = new ArrayList<TitledAction>();
            try {
                List pluginList = PluginManager.getInstance().getPluginList().stream().sorted((p1, p2) -> {
                    if ("report".equals(p1.getId())) {
                        return -1;
                    }
                    if ("report".equals(p2.getId())) {
                        return 1;
                    }
                    return 0;
                }).collect(Collectors.toList());
                for (Plugin p : pluginList) {
                    Reflections r = new Reflections(p.getClass().getPackageName(), new Scanner[0]);
                    for (Class reportClass : r.getSubTypesOf(ReportActionBase.class)) {
                        ReportActionBase reportInstance = (ReportActionBase)reportClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                        log.debug("Loading report: {}", reportInstance);
                        result.add(new TitledAction(reportInstance, reportInstance, reportInstance.getHref()));
                    }
                }
            }
            catch (Exception ex) {
                log.error(ex);
            }
            return result;
        }
    }
}

