/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.ai.aixflow.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.bgerp.plugin.ai.aixflow.Config;
import org.bgerp.util.Log;
import ru.bgcrm.util.Utils;

public class AixFlowService {
    private static final Log log = Log.getLog();
    private final Config config;
    private final ObjectMapper objectMapper;

    public AixFlowService(Config config) {
        this.config = config;
        this.objectMapper = new ObjectMapper();
    }

    public AixFlowResponse sendFile(File file) throws Exception {
        CloseableHttpResponse response;
        if (Utils.isBlankString(this.config.getN8nUrl())) {
            throw new IllegalStateException("N8n service is not configured");
        }
        String fileContent = this.encodeFileToBase64(file);
        String taskId = UUID.randomUUID().toString();
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("fileSize", file.length());
        requestBody.put("taskId", taskId);
        requestBody.put("fileContent", fileContent);
        Object url = this.config.getN8nUrl();
        if (!((String)url).contains("webhook/integration-webhook-frontend")) {
            if (!((String)url).endsWith("/")) {
                url = (String)url + "/";
            }
            url = (String)url + "webhook/integration-webhook-frontend";
        }
        log.debug("Sending file to n8n: {} ({} bytes), URL: {}", file.getName(), file.length(), url);
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost request = new HttpPost((String)url);
        StringEntity entity = new StringEntity(this.objectMapper.writeValueAsString(requestBody), "UTF-8");
        request.setEntity((HttpEntity)entity);
        request.setHeader("Content-Type", "application/json");
        if (Utils.notBlankString(this.config.getN8nAuthUsername()) && Utils.notBlankString(this.config.getN8nAuthPassword())) {
            String auth = this.config.getN8nAuthUsername() + ":" + this.config.getN8nAuthPassword();
            String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes());
            request.setHeader("Authorization", "Basic " + encodedAuth);
        }
        if ((response = httpClient.execute((HttpUriRequest)request)).getStatusLine().getStatusCode() != 200) {
            throw new Exception("N8n request failed with status: " + response.getStatusLine().getStatusCode() + ", response: " + EntityUtils.toString((HttpEntity)response.getEntity()));
        }
        String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
        JsonNode jsonResponse = this.objectMapper.readTree(responseBody);
        log.info("=== SEND FILE RESPONSE PARSING DEBUG ===", new Object[0]);
        log.info("Response body: {}", responseBody);
        log.info("Has data.transkribe: {}", jsonResponse.get("data") != null && jsonResponse.get("data").get("transkribe") != null);
        log.info("=== END SEND FILE RESPONSE PARSING DEBUG ===", new Object[0]);
        AixFlowResponse aixFlowResponse = new AixFlowResponse();
        JsonNode dataNode = jsonResponse.get("data");
        if (dataNode != null) {
            JsonNode transkribeNode = dataNode.get("transkribe");
            if (transkribeNode != null) {
                JsonNode hashNode = transkribeNode.get("hash");
                JsonNode filenameNode = transkribeNode.get("filename");
                JsonNode statusNode = transkribeNode.get("status");
                aixFlowResponse.setHash(hashNode != null ? hashNode.asText() : "");
                aixFlowResponse.setFilename(filenameNode != null ? filenameNode.asText() : "");
                aixFlowResponse.setStatus(statusNode != null ? statusNode.asText() : "");
            } else {
                JsonNode hashNode = dataNode.get("hash");
                JsonNode filenameNode = dataNode.get("filename");
                JsonNode statusNode = dataNode.get("status");
                aixFlowResponse.setHash(hashNode != null ? hashNode.asText() : "");
                aixFlowResponse.setFilename(filenameNode != null ? filenameNode.asText() : "");
                aixFlowResponse.setStatus(statusNode != null ? statusNode.asText() : "");
            }
        } else {
            JsonNode hashNode = jsonResponse.get("hash");
            JsonNode filenameNode = jsonResponse.get("filename");
            JsonNode statusNode = jsonResponse.get("status");
            aixFlowResponse.setHash(hashNode != null ? hashNode.asText() : "");
            aixFlowResponse.setFilename(filenameNode != null ? filenameNode.asText() : "");
            aixFlowResponse.setStatus(statusNode != null ? statusNode.asText() : "");
        }
        log.debug("N8n response: hash={}, filename={}, status={}", aixFlowResponse.getHash(), aixFlowResponse.getFilename(), aixFlowResponse.getStatus());
        return aixFlowResponse;
    }

    public AixFlowResponse sendTextForDiarization(String text, String hash) throws Exception {
        JsonNode firstElement;
        JsonNode diarizNode;
        if (Utils.isBlankString(this.config.getN8nUrl())) {
            throw new IllegalStateException("N8n service is not configured");
        }
        HashMap<String, String> requestBody = new HashMap<String, String>();
        requestBody.put("text", text);
        requestBody.put("action", "diariz");
        requestBody.put("hash", hash);
        Object url = this.config.getN8nUrl();
        if (!((String)url).contains("webhook/integration-webhook-frontend")) {
            if (!((String)url).endsWith("/")) {
                url = (String)url + "/";
            }
            url = (String)url + "webhook/integration-webhook-frontend";
        }
        log.info("=== DIARIZATION REQUEST DEBUG ===", new Object[0]);
        log.info("Original n8n URL from config: {}", this.config.getN8nUrl());
        log.info("Final URL for diarization: {}", url);
        log.info("Text length: {}, Hash: {}", text.length(), hash);
        log.info("Request body: {}", this.objectMapper.writeValueAsString(requestBody));
        log.info("=== END DIARIZATION DEBUG ===", new Object[0]);
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost request = new HttpPost((String)url);
        StringEntity entity = new StringEntity(this.objectMapper.writeValueAsString(requestBody), "UTF-8");
        request.setEntity((HttpEntity)entity);
        request.setHeader("Content-Type", "application/json");
        if (Utils.notBlankString(this.config.getN8nAuthUsername()) && Utils.notBlankString(this.config.getN8nAuthPassword())) {
            String auth = this.config.getN8nAuthUsername() + ":" + this.config.getN8nAuthPassword();
            String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes());
            request.setHeader("Authorization", "Basic " + encodedAuth);
        }
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
        log.info("=== DIARIZATION RESPONSE DEBUG ===", new Object[0]);
        log.info("Response status: {}", response.getStatusLine().getStatusCode());
        log.info("Response headers: {}", Arrays.toString(response.getAllHeaders()));
        String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
        log.info("Response body: {}", responseBody);
        log.info("=== END DIARIZATION RESPONSE DEBUG ===", new Object[0]);
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new Exception("N8n diarization request failed with status: " + response.getStatusLine().getStatusCode() + ", response: " + responseBody);
        }
        JsonNode jsonResponse = this.objectMapper.readTree(responseBody);
        log.info("=== DIARIZATION RESPONSE PARSING DEBUG ===", new Object[0]);
        log.info("Response body: {}", responseBody);
        log.info("Is array: {}", jsonResponse.isArray());
        log.info("Has data.diariz: {}", jsonResponse.get("data") != null && jsonResponse.get("data").get("diariz") != null);
        log.info("=== END DIARIZATION RESPONSE PARSING DEBUG ===", new Object[0]);
        AixFlowResponse aixFlowResponse = new AixFlowResponse();
        aixFlowResponse.setRawResponse(responseBody);
        JsonNode dataNode = jsonResponse.get("data");
        if (dataNode != null) {
            JsonNode diarizNode2 = dataNode.get("diariz");
            if (diarizNode2 != null) {
                JsonNode statusNode = diarizNode2.get("status");
                JsonNode hashPromptNode = diarizNode2.get("hash_prompt");
                JsonNode hashFullNode = diarizNode2.get("hash_full");
                JsonNode resultNode = diarizNode2.get("result");
                aixFlowResponse.setStatus(statusNode != null ? statusNode.asText() : "");
                aixFlowResponse.setHash(hashFullNode != null ? hashFullNode.asText() : "");
                if ("completed".equals(aixFlowResponse.getStatus()) && resultNode != null) {
                    StringBuilder resultText = new StringBuilder();
                    if (resultNode.isArray()) {
                        for (JsonNode speakerNode : resultNode) {
                            JsonNode speakerNameNode = speakerNode.get("speaker");
                            JsonNode speakerTextNode = speakerNode.get("text");
                            if (speakerNameNode == null || speakerTextNode == null) continue;
                            if (resultText.length() > 0) {
                                resultText.append("\n");
                            }
                            resultText.append(speakerNameNode.asText()).append(": ").append(speakerTextNode.asText());
                        }
                    }
                    aixFlowResponse.setFilename(resultText.toString());
                }
                log.debug("Diarization response parsed: status={}, hash={}", aixFlowResponse.getStatus(), aixFlowResponse.getHash());
            }
        } else if (jsonResponse.isArray() && jsonResponse.size() > 0 && (diarizNode = (firstElement = jsonResponse.get(0)).get("diariz")) != null) {
            JsonNode statusNode = diarizNode.get("status");
            JsonNode hashPromptNode = diarizNode.get("hash_prompt");
            JsonNode hashFullNode = diarizNode.get("hash_full");
            JsonNode resultNode = diarizNode.get("result");
            aixFlowResponse.setStatus(statusNode != null ? statusNode.asText() : "");
            aixFlowResponse.setHash(hashFullNode != null ? hashFullNode.asText() : "");
            if ("completed".equals(aixFlowResponse.getStatus()) && resultNode != null) {
                StringBuilder resultText = new StringBuilder();
                if (resultNode.isArray()) {
                    for (JsonNode speakerNode : resultNode) {
                        JsonNode speakerNameNode = speakerNode.get("speaker");
                        JsonNode speakerTextNode = speakerNode.get("text");
                        if (speakerNameNode == null || speakerTextNode == null) continue;
                        if (resultText.length() > 0) {
                            resultText.append("\n");
                        }
                        resultText.append(speakerNameNode.asText()).append(": ").append(speakerTextNode.asText());
                    }
                }
                aixFlowResponse.setFilename(resultText.toString());
            }
        }
        log.debug("N8n diarization response: hash={}, filename={}, status={}", aixFlowResponse.getHash(), aixFlowResponse.getFilename(), aixFlowResponse.getStatus());
        return aixFlowResponse;
    }

    public AixFlowTaskData checkDiarizationTaskStatus(String hash) throws Exception {
        JsonNode diarizNode;
        CloseableHttpResponse response;
        if (Utils.isBlankString(this.config.getN8nUrl())) {
            throw new IllegalStateException("N8n service is not configured");
        }
        HashMap<String, String> requestBody = new HashMap<String, String>();
        requestBody.put("hash", hash);
        requestBody.put("action", "getTaskData");
        Object url = this.config.getN8nUrl();
        if (!((String)url).contains("webhook/integration-webhook-frontend")) {
            if (!((String)url).endsWith("/")) {
                url = (String)url + "/";
            }
            url = (String)url + "webhook/integration-webhook-frontend";
        }
        log.debug("Checking diarization task status for hash: {}, URL: {}", hash, url);
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost request = new HttpPost((String)url);
        StringEntity entity = new StringEntity(this.objectMapper.writeValueAsString(requestBody), "UTF-8");
        request.setEntity((HttpEntity)entity);
        request.setHeader("Content-Type", "application/json");
        if (Utils.notBlankString(this.config.getN8nAuthUsername()) && Utils.notBlankString(this.config.getN8nAuthPassword())) {
            String auth = this.config.getN8nAuthUsername() + ":" + this.config.getN8nAuthPassword();
            String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes());
            request.setHeader("Authorization", "Basic " + encodedAuth);
        }
        if ((response = httpClient.execute((HttpUriRequest)request)).getStatusLine().getStatusCode() != 200) {
            throw new Exception("N8n diarization status check failed with status: " + response.getStatusLine().getStatusCode() + ", response: " + EntityUtils.toString((HttpEntity)response.getEntity()));
        }
        String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
        JsonNode jsonResponse = this.objectMapper.readTree(responseBody);
        log.info("=== DIARIZATION TASK STATUS RESPONSE DEBUG ===", new Object[0]);
        log.info("Response body: {}", responseBody);
        log.info("Has data.diariz: {}", jsonResponse.get("data") != null && jsonResponse.get("data").get("diariz") != null);
        log.info("=== END DIARIZATION TASK STATUS RESPONSE DEBUG ===", new Object[0]);
        AixFlowTaskData taskData = new AixFlowTaskData();
        taskData.setId(jsonResponse.get("id").asText());
        taskData.setMode(jsonResponse.get("mode").asText());
        taskData.setResumeUrl(jsonResponse.get("resumeUrl").asText());
        taskData.setResumeFormUrl(jsonResponse.get("resumeFormUrl").asText());
        JsonNode dataNode = jsonResponse.get("data");
        if (dataNode != null && (diarizNode = dataNode.get("diariz")) != null) {
            JsonNode statusNode = diarizNode.get("status");
            taskData.setStatus(statusNode != null ? statusNode.asText() : "");
            JsonNode hashPromptNode = diarizNode.get("hash_prompt");
            JsonNode hashFullNode = diarizNode.get("hash_full");
            JsonNode tokensNode = diarizNode.get("tokens");
            JsonNode resultNode = diarizNode.get("result");
            taskData.setRawResponse(responseBody);
            log.debug("Diarization task status: id={}, status={}", taskData.getId(), taskData.getStatus());
        }
        return taskData;
    }

    public AixFlowTaskData checkTaskStatus(String hash) throws Exception {
        JsonNode transkribeNode;
        CloseableHttpResponse response;
        if (Utils.isBlankString(this.config.getN8nUrl())) {
            throw new IllegalStateException("N8n service is not configured");
        }
        HashMap<String, String> requestBody = new HashMap<String, String>();
        requestBody.put("hash", hash);
        requestBody.put("action", "getTaskData");
        Object url = this.config.getN8nUrl();
        if (!((String)url).contains("webhook/integration-webhook-frontend")) {
            if (!((String)url).endsWith("/")) {
                url = (String)url + "/";
            }
            url = (String)url + "webhook/integration-webhook-frontend";
        }
        log.debug("Checking task status for hash: {}, URL: {}", hash, url);
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost request = new HttpPost((String)url);
        StringEntity entity = new StringEntity(this.objectMapper.writeValueAsString(requestBody), "UTF-8");
        request.setEntity((HttpEntity)entity);
        request.setHeader("Content-Type", "application/json");
        if (Utils.notBlankString(this.config.getN8nAuthUsername()) && Utils.notBlankString(this.config.getN8nAuthPassword())) {
            String auth = this.config.getN8nAuthUsername() + ":" + this.config.getN8nAuthPassword();
            String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes());
            request.setHeader("Authorization", "Basic " + encodedAuth);
        }
        if ((response = httpClient.execute((HttpUriRequest)request)).getStatusLine().getStatusCode() != 200) {
            throw new Exception("N8n status check failed with status: " + response.getStatusLine().getStatusCode() + ", response: " + EntityUtils.toString((HttpEntity)response.getEntity()));
        }
        String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
        JsonNode jsonResponse = this.objectMapper.readTree(responseBody);
        log.info("=== TASK STATUS RESPONSE DEBUG ===", new Object[0]);
        log.info("Response body: {}", responseBody);
        log.info("Has data.transkribe: {}", jsonResponse.get("data") != null && jsonResponse.get("data").get("transkribe") != null);
        log.info("=== END TASK STATUS RESPONSE DEBUG ===", new Object[0]);
        AixFlowTaskData taskData = new AixFlowTaskData();
        taskData.setId(jsonResponse.get("id").asText());
        taskData.setMode(jsonResponse.get("mode").asText());
        taskData.setResumeUrl(jsonResponse.get("resumeUrl").asText());
        taskData.setResumeFormUrl(jsonResponse.get("resumeFormUrl").asText());
        JsonNode dataNode = jsonResponse.get("data");
        if (dataNode != null && (transkribeNode = dataNode.get("transkribe")) != null) {
            JsonNode textNode = transkribeNode.get("text");
            taskData.setText(textNode != null ? textNode.asText() : "");
            taskData.setHash(transkribeNode.get("hash").asText());
            JsonNode durationNode = transkribeNode.get("duration_sec");
            taskData.setDurationSec(durationNode != null ? durationNode.asText() : "");
            JsonNode timeNode = transkribeNode.get("time_sec");
            taskData.setTimeSec(timeNode != null ? timeNode.asText() : "");
            JsonNode filenameNode = transkribeNode.get("filename");
            taskData.setFilename(filenameNode != null ? filenameNode.asText() : "");
            taskData.setStatus(transkribeNode.get("status").asText());
        }
        log.debug("N8n task status: id={}, status={}", taskData.getId(), taskData.getStatus());
        return taskData;
    }

    private String encodeFileToBase64(File file) throws IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            byte[] fileBytes = IOUtils.toByteArray((InputStream)fis);
            String string = Base64.getEncoder().encodeToString(fileBytes);
            return string;
        }
    }

    public static class AixFlowResponse {
        private String hash;
        private String filename;
        private String status;
        private String rawResponse;

        public String getHash() {
            return this.hash;
        }

        public void setHash(String hash) {
            this.hash = hash;
        }

        public String getFilename() {
            return this.filename;
        }

        public void setFilename(String filename) {
            this.filename = filename;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getRawResponse() {
            return this.rawResponse;
        }

        public void setRawResponse(String rawResponse) {
            this.rawResponse = rawResponse;
        }
    }

    public static class AixFlowTaskData {
        private String id;
        private String mode;
        private String resumeUrl;
        private String resumeFormUrl;
        private String text;
        private String hash;
        private String durationSec;
        private String timeSec;
        private String filename;
        private String status;
        private String rawResponse;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getMode() {
            return this.mode;
        }

        public void setMode(String mode) {
            this.mode = mode;
        }

        public String getResumeUrl() {
            return this.resumeUrl;
        }

        public void setResumeUrl(String resumeUrl) {
            this.resumeUrl = resumeUrl;
        }

        public String getResumeFormUrl() {
            return this.resumeFormUrl;
        }

        public void setResumeFormUrl(String resumeFormUrl) {
            this.resumeFormUrl = resumeFormUrl;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public String getHash() {
            return this.hash;
        }

        public void setHash(String hash) {
            this.hash = hash;
        }

        public String getDurationSec() {
            return this.durationSec;
        }

        public void setDurationSec(String durationSec) {
            this.durationSec = durationSec;
        }

        public String getTimeSec() {
            return this.timeSec;
        }

        public void setTimeSec(String timeSec) {
            this.timeSec = timeSec;
        }

        public String getFilename() {
            return this.filename;
        }

        public void setFilename(String filename) {
            this.filename = filename;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getRawResponse() {
            return this.rawResponse;
        }

        public void setRawResponse(String rawResponse) {
            this.rawResponse = rawResponse;
        }
    }
}

