/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.ai.aixflow.model;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.bgerp.plugin.ai.aixflow.model.AixFlowResult;
import org.bgerp.util.Log;

public class AixFlowResultDAO {
    private static final Log log = Log.getLog();
    private static String TABLE_NAME = "aixflow_results";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String resolveTableName(Connection con) {
        try (PreparedStatement ps = con.prepareStatement("SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME IN ('aixflow_results','aixflow_n8n_results','plugin_aixflow_n8n_results') ORDER BY CASE TABLE_NAME WHEN 'aixflow_results' THEN 0 WHEN 'aixflow_n8n_results' THEN 1 ELSE 2 END LIMIT 1");
             ResultSet rs = ps.executeQuery();){
            if (!rs.next()) return TABLE_NAME;
            String string = rs.getString(1);
            return string;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return TABLE_NAME;
    }

    public static void createTable(Connection con) throws SQLException {
        TABLE_NAME = AixFlowResultDAO.resolveTableName(con);
        log.info("Table " + TABLE_NAME + " should be created via db.sql", new Object[0]);
    }

    public static void saveDiarizationResult(Connection con, String filename, String diarizationHash, String diarizationStatus, String diarizationResult, String diarizationRawResponse) throws SQLException {
        PreparedStatement ps;
        TABLE_NAME = AixFlowResultDAO.resolveTableName(con);
        boolean hasDiarizationColumns = false;
        try {
            String checkSql = "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = ? AND COLUMN_NAME = 'diarization_hash'";
            ps = con.prepareStatement(checkSql);
            try {
                ps.setString(1, TABLE_NAME);
                try (ResultSet rs = ps.executeQuery();){
                    hasDiarizationColumns = rs.next();
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (SQLException e) {
            hasDiarizationColumns = false;
        }
        if (!hasDiarizationColumns) {
            log.warn("Diarization columns not found in table " + TABLE_NAME, new Object[0]);
            return;
        }
        String sql = "UPDATE " + TABLE_NAME + " SET diarization_hash = ?, diarization_status = ?, diarization_result = ?, diarization_raw_response = ?, updated = ? WHERE filename = ?";
        ps = con.prepareStatement(sql);
        try {
            ps.setString(1, diarizationHash);
            ps.setString(2, diarizationStatus);
            ps.setString(3, diarizationResult);
            ps.setString(4, diarizationRawResponse);
            ps.setTimestamp(5, new Timestamp(System.currentTimeMillis()));
            ps.setString(6, filename);
            int updated = ps.executeUpdate();
            log.debug("Updated {} rows with diarization data for filename: {}", updated, filename);
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public static void saveResult(Connection con, AixFlowResult result) throws SQLException {
        PreparedStatement ps;
        TABLE_NAME = AixFlowResultDAO.resolveTableName(con);
        boolean hasRawResponseColumn = false;
        try {
            String checkSql = "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = ? AND COLUMN_NAME = 'raw_response'";
            ps = con.prepareStatement(checkSql);
            try {
                ps.setString(1, TABLE_NAME);
                try (ResultSet rs = ps.executeQuery();){
                    hasRawResponseColumn = rs.next();
                }
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (SQLException e) {
            hasRawResponseColumn = false;
        }
        String sql = hasRawResponseColumn ? "INSERT INTO " + TABLE_NAME + " (filename, hash, status, text, duration_sec, time_sec, n8n_filename, raw_response, created, updated) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE status = VALUES(status), text = VALUES(text), duration_sec = VALUES(duration_sec), time_sec = VALUES(time_sec), n8n_filename = VALUES(n8n_filename), raw_response = VALUES(raw_response), updated = VALUES(updated)" : "INSERT INTO " + TABLE_NAME + " (filename, hash, status, text, duration_sec, time_sec, n8n_filename, created, updated) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?) ON DUPLICATE KEY UPDATE status = VALUES(status), text = VALUES(text), duration_sec = VALUES(duration_sec), time_sec = VALUES(time_sec), n8n_filename = VALUES(n8n_filename), updated = VALUES(updated)";
        ps = con.prepareStatement(sql);
        try {
            ps.setString(1, result.getFilename());
            ps.setString(2, result.getHash());
            ps.setString(3, result.getStatus());
            ps.setString(4, result.getText());
            ps.setString(5, result.getDurationSec());
            ps.setString(6, result.getTimeSec());
            ps.setString(7, result.getN8nFilename());
            if (hasRawResponseColumn) {
                ps.setString(8, result.getRawResponse());
                ps.setTimestamp(9, new Timestamp(result.getCreated().getTime()));
                ps.setTimestamp(10, new Timestamp(result.getUpdated().getTime()));
            } else {
                ps.setTimestamp(8, new Timestamp(result.getCreated().getTime()));
                ps.setTimestamp(9, new Timestamp(result.getUpdated().getTime()));
            }
            ps.executeUpdate();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }

    public static AixFlowResult getByHash(Connection con, String hash) throws SQLException {
        String currentTableName = AixFlowResultDAO.resolveTableName(con);
        String sql = "SELECT * FROM " + currentTableName + " WHERE hash = ?";
        try (PreparedStatement ps = con.prepareStatement(sql);){
            ps.setString(1, hash);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    AixFlowResult aixFlowResult = AixFlowResultDAO.mapResult(rs);
                    return aixFlowResult;
                }
            }
        }
        return null;
    }

    public static List<AixFlowResult> getByFilename(Connection con, String filename) throws SQLException {
        String currentTableName = AixFlowResultDAO.resolveTableName(con);
        String sql = "SELECT * FROM " + currentTableName + " WHERE filename = ? ORDER BY created DESC";
        ArrayList<AixFlowResult> results = new ArrayList<AixFlowResult>();
        try (PreparedStatement ps = con.prepareStatement(sql);){
            ps.setString(1, filename);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    results.add(AixFlowResultDAO.mapResult(rs));
                }
            }
        }
        return results;
    }

    public static List<AixFlowResult> getAll(Connection con) throws SQLException {
        String currentTableName = AixFlowResultDAO.resolveTableName(con);
        String sql = "SELECT * FROM " + currentTableName + " ORDER BY created DESC";
        ArrayList<AixFlowResult> results = new ArrayList<AixFlowResult>();
        try (PreparedStatement ps = con.prepareStatement(sql);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                results.add(AixFlowResultDAO.mapResult(rs));
            }
        }
        return results;
    }

    public static void deleteByFilename(Connection con, String filename) throws SQLException {
        String currentTableName = AixFlowResultDAO.resolveTableName(con);
        String sql = "DELETE FROM " + currentTableName + " WHERE filename = ?";
        try (PreparedStatement ps = con.prepareStatement(sql);){
            ps.setString(1, filename);
            ps.executeUpdate();
        }
    }

    private static AixFlowResult mapResult(ResultSet rs) throws SQLException {
        AixFlowResult result = new AixFlowResult();
        result.setId(rs.getInt("id"));
        result.setFilename(rs.getString("filename"));
        result.setHash(rs.getString("hash"));
        result.setStatus(rs.getString("status"));
        result.setText(rs.getString("text"));
        result.setDurationSec(rs.getString("duration_sec"));
        result.setTimeSec(rs.getString("time_sec"));
        result.setN8nFilename(rs.getString("n8n_filename"));
        try {
            result.setRawResponse(rs.getString("raw_response"));
        }
        catch (SQLException e) {
            result.setRawResponse(null);
        }
        try {
            result.setDiarizationHash(rs.getString("diarization_hash"));
        }
        catch (SQLException e) {
            result.setDiarizationHash(null);
        }
        try {
            result.setDiarizationStatus(rs.getString("diarization_status"));
        }
        catch (SQLException e) {
            result.setDiarizationStatus(null);
        }
        try {
            result.setDiarizationResult(rs.getString("diarization_result"));
        }
        catch (SQLException e) {
            result.setDiarizationResult(null);
        }
        try {
            result.setDiarizationRawResponse(rs.getString("diarization_raw_response"));
        }
        catch (SQLException e) {
            result.setDiarizationRawResponse(null);
        }
        result.setCreated(rs.getTimestamp("created"));
        result.setUpdated(rs.getTimestamp("updated"));
        return result;
    }
}

