/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.ai.aixflow.action;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.struts.action.ActionForward;
import org.apache.struts.upload.FormFile;
import org.bgerp.action.base.BaseAction;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.servlet.file.Files;
import org.bgerp.app.servlet.file.Options;
import org.bgerp.app.servlet.file.Order;
import org.bgerp.dao.FileDataDAO;
import org.bgerp.model.file.FileData;
import org.bgerp.plugin.ai.aixflow.Config;
import org.bgerp.plugin.ai.aixflow.model.AixFlowFileData;
import org.bgerp.plugin.ai.aixflow.model.AixFlowFileDataDAO;
import org.bgerp.plugin.ai.aixflow.model.AixFlowResult;
import org.bgerp.plugin.ai.aixflow.model.AixFlowResultDAO;
import org.bgerp.plugin.ai.aixflow.model.AixFlowService;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;

@ActionServlet.Action(path="/user/plugin/aixflow/point3", pathId=true)
public class AixFlowActionPoint3
extends BaseAction {
    private static final String PATH_JSP = "/WEB-INF/jspf/user/plugin/aixflow";
    public static final Files FILE_AIXFLOW = new Files(AixFlowActionPoint3.class, "fileAixflow", "filestorage/aixflow", new Options().withOrder(Order.LAST_MODIFIED_DESC).withDeletionEnabled().withDownloadEnabled(), "*");

    @Override
    public ActionForward unspecified(DynActionForm form, ConnectionSet conSet) throws Exception {
        this.log.info("=== AixFlowActionPoint3 unspecified called ===", new Object[0]);
        this.log.info("Form method: {}", form.getParam("method"));
        return this.html(conSet, form, "/WEB-INF/jspf/user/plugin/aixflow/point3.jsp");
    }

    public ActionForward uploadFile(DynActionForm form, ConnectionSet conSet) throws Exception {
        this.log.info("uploadFile method called", new Object[0]);
        FormFile formFile = form.getFile();
        if (formFile == null) {
            form.setResponseData("success", false);
            form.setResponseData("message", "No file uploaded");
            return this.json(conSet, form);
        }
        try {
            FileData fileData = new FileData();
            fileData.setTitle(formFile.getFileName());
            FileDataDAO fileDataDAO = new FileDataDAO(conSet.getConnection());
            try (FileOutputStream fos = fileDataDAO.add(fileData);){
                IOUtils.copy((InputStream)formFile.getInputStream(), (OutputStream)fos);
            }
            AixFlowFileDataDAO mapDao = new AixFlowFileDataDAO(conSet.getConnection());
            try {
                mapDao.deleteByFilename(formFile.getFileName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            AixFlowFileData afd = new AixFlowFileData();
            afd.setFileDataId(fileData.getId());
            afd.setFilename(formFile.getFileName());
            mapDao.add(afd);
            form.setResponseData("success", true);
            form.setResponseData("message", "File uploaded successfully: " + formFile.getFileName());
            form.setResponseData("fileId", fileData.getId());
        }
        catch (Exception e) {
            this.log.error("Error uploading file", e);
            form.setResponseData("success", false);
            form.setResponseData("message", "Error uploading file: " + e.getMessage());
        }
        return this.json(conSet, form);
    }

    public ActionForward downloadFileAixflow(DynActionForm form, ConnectionSet conSet) throws Exception {
        return FILE_AIXFLOW.download(form);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ActionForward deleteFileAixflow(DynActionForm form, ConnectionSet conSet) throws Exception {
        Object message;
        boolean success;
        block30: {
            String filename = form.getParam("name");
            int fileId = form.getParamInt("fileId", 0);
            success = false;
            try {
                AixFlowFileDataDAO mapDao = new AixFlowFileDataDAO(conSet.getConnection());
                if (fileId > 0) {
                    FileData fd;
                    String sql = "SELECT id, title, dt, secret FROM file_data WHERE id=?";
                    try (PreparedStatement ps = conSet.getConnection().prepareStatement(sql);){
                        ps.setInt(1, fileId);
                        try (ResultSet rs = ps.executeQuery();){
                            if (!rs.next()) {
                                form.setResponseData("success", false);
                                form.setResponseData("message", "file_data not found for id: " + fileId);
                                ActionForward actionForward = this.json(conSet, form);
                                return actionForward;
                            }
                            fd = FileDataDAO.getFromRs(rs, "");
                        }
                    }
                    new FileDataDAO(conSet.getConnection()).delete(fd);
                    AixFlowFileData afd = mapDao.getByFileDataId(fileId);
                    String fname = filename;
                    if (afd != null) {
                        fname = afd.getFilename();
                        mapDao.deleteById(afd.getId());
                    }
                    if (Utils.notBlankString(fname)) {
                        try {
                            AixFlowResultDAO.deleteByFilename(conSet.getConnection(), fname);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    success = true;
                    message = "File deleted by id: " + fileId;
                    break block30;
                }
                if (Utils.notBlankString(filename)) {
                    AixFlowFileData afd = mapDao.getByFilename(filename);
                    if (afd != null) {
                        FileData fileData = mapDao.getFileData(afd.getFileDataId());
                        if (fileData != null) {
                            new FileDataDAO(conSet.getConnection()).delete(fileData);
                        }
                        mapDao.deleteById(afd.getId());
                        success = true;
                        message = "File deleted: " + filename;
                    } else {
                        message = "Mapping not found for file: " + filename;
                    }
                    try {
                        AixFlowResultDAO.deleteByFilename(conSet.getConnection(), filename);
                    }
                    catch (Exception exception) {}
                } else {
                    message = "Neither fileId nor filename provided";
                }
            }
            catch (Exception e) {
                this.log.error("Error deleting file", e);
                message = "Error deleting file: " + e.getMessage();
            }
        }
        form.setResponseData("success", success);
        form.setResponseData("message", message);
        return this.json(conSet, form);
    }

    /*
     * Exception decompiling
     */
    public ActionForward sendFileToN8n(DynActionForm form, ConnectionSet conSet) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ActionForward checkN8nTaskStatus(DynActionForm form, ConnectionSet conSet) throws Exception {
        String hash = form.getParam("hash");
        if (Utils.isBlankString(hash)) {
            form.setResponseData("success", false);
            form.setResponseData("message", "Hash is required");
            return this.json(conSet, form);
        }
        try {
            Config config;
            try {
                config = Setup.getSetup().getConfig(Config.class);
            }
            catch (Exception e) {
                this.log.error("Failed to load Config", e);
                form.setResponseData("success", false);
                form.setResponseData("message", "Configuration error: " + e.getMessage());
                return this.json(conSet, form);
            }
            if (config == null || Utils.isBlankString(config.getN8nUrl())) {
                form.setResponseData("success", false);
                form.setResponseData("message", "N8n service is not configured. Please check configuration.");
                return this.json(conSet, form);
            }
            AixFlowService n8nService = new AixFlowService(config);
            AixFlowService.AixFlowTaskData taskData = n8nService.checkTaskStatus(hash);
            form.setResponseData("success", true);
            form.setResponseData("id", taskData.getId());
            form.setResponseData("mode", taskData.getMode());
            form.setResponseData("resumeUrl", taskData.getResumeUrl());
            form.setResponseData("resumeFormUrl", taskData.getResumeFormUrl());
            form.setResponseData("text", taskData.getText());
            form.setResponseData("hash", taskData.getHash());
            form.setResponseData("durationSec", taskData.getDurationSec());
            form.setResponseData("timeSec", taskData.getTimeSec());
            form.setResponseData("filename", taskData.getFilename());
            form.setResponseData("status", taskData.getStatus());
        }
        catch (Exception e) {
            this.log.error("Error checking n8n task status", e);
            form.setResponseData("success", false);
            form.setResponseData("message", "Error checking task status: " + e.getMessage());
        }
        return this.json(conSet, form);
    }

    public ActionForward getN8nConfig(DynActionForm form, ConnectionSet conSet) throws Exception {
        try {
            Config config = Setup.getSetup().getConfig(Config.class);
            form.setResponseData("success", true);
            form.setResponseData("n8nUrl", config.getN8nUrl());
            form.setResponseData("n8nAuthUsername", config.getN8nAuthUsername());
            form.setResponseData("n8nAuthPassword", config.getN8nAuthPassword());
        }
        catch (Exception e) {
            this.log.error("Failed to get n8n config", e);
            form.setResponseData("success", false);
            form.setResponseData("message", "Configuration error: " + e.getMessage());
        }
        return this.json(conSet, form);
    }

    public ActionForward getAixFlowResults(DynActionForm form, ConnectionSet conSet) throws Exception {
        try {
            AixFlowResultDAO.createTable(conSet.getConnection());
            List<AixFlowResult> results = AixFlowResultDAO.getAll(conSet.getConnection());
            form.setResponseData("success", true);
            form.setResponseData("results", results);
        }
        catch (Exception e) {
            this.log.error("Failed to get n8n results", e);
            form.setResponseData("success", false);
            form.setResponseData("message", "Error getting results: " + e.getMessage());
        }
        return this.json(conSet, form);
    }

    public ActionForward getAixflowFiles(DynActionForm form, ConnectionSet conSet) throws Exception {
        try {
            Connection con = conSet.getConnection();
            ArrayList list = new ArrayList();
            String sql = "SELECT afd.id AS map_id, afd.filename, fd.id, fd.title, fd.dt, fd.secret FROM aixflow_file_data afd JOIN file_data fd ON afd.file_data_id=fd.id ORDER BY fd.dt DESC";
            try (PreparedStatement ps = con.prepareStatement(sql);
                 ResultSet rs = ps.executeQuery();){
                HashSet<String> seen = new HashSet<String>();
                while (rs.next()) {
                    String filename = rs.getString("filename");
                    if (seen.contains(filename)) continue;
                    seen.add(filename);
                    HashMap<String, Object> row = new HashMap<String, Object>();
                    row.put("mapId", rs.getInt("map_id"));
                    FileData fd = FileDataDAO.getFromRs(rs, "");
                    row.put("fileId", fd.getId());
                    row.put("title", fd.getTitle());
                    row.put("dt", fd.getTime());
                    row.put("secret", fd.getSecret());
                    row.put("filename", filename);
                    try {
                        File f = new FileDataDAO(con).getFile(fd);
                        row.put("size", f != null && f.exists() ? f.length() : 0L);
                    }
                    catch (Exception ex) {
                        row.put("size", 0L);
                    }
                    list.add(row);
                }
            }
            form.setResponseData("success", true);
            form.setResponseData("files", list);
        }
        catch (Exception e) {
            this.log.error("Failed to list aixflow files", e);
            form.setResponseData("success", false);
            form.setResponseData("message", e.getMessage());
        }
        return this.json(conSet, form);
    }

    public ActionForward saveAixFlowResult(DynActionForm form, ConnectionSet conSet) throws Exception {
        String filename = form.getParam("filename");
        String hash = form.getParam("hash");
        String status = form.getParam("status");
        String text = form.getParam("text");
        String durationSec = form.getParam("durationSec");
        String timeSec = form.getParam("timeSec");
        String n8nFilename = form.getParam("n8nFilename");
        String rawResponse = form.getParam("rawResponse");
        try {
            AixFlowResultDAO.createTable(conSet.getConnection());
            AixFlowResult result = new AixFlowResult(filename, hash, status);
            result.setText(text);
            result.setDurationSec(durationSec);
            result.setTimeSec(timeSec);
            result.setN8nFilename(n8nFilename);
            result.setRawResponse(rawResponse);
            AixFlowResultDAO.saveResult(conSet.getConnection(), result);
            form.setResponseData("success", true);
            form.setResponseData("message", "Result saved successfully");
        }
        catch (Exception e) {
            this.log.error("Failed to save n8n result", e);
            form.setResponseData("success", false);
            form.setResponseData("message", "Error saving result: " + e.getMessage());
        }
        return this.json(conSet, form);
    }

    public ActionForward cleanupAixFlowResults(DynActionForm form, ConnectionSet conSet) throws Exception {
        try {
            AixFlowResultDAO.createTable(conSet.getConnection());
            HashSet<String> existingFilenames = new HashSet<String>();
            try (PreparedStatement ps = conSet.getConnection().prepareStatement("SELECT filename FROM aixflow_file_data");
                 ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    existingFilenames.add(rs.getString(1));
                }
            }
            List<AixFlowResult> allResults = AixFlowResultDAO.getAll(conSet.getConnection());
            int deletedCount = 0;
            for (AixFlowResult result : allResults) {
                if (existingFilenames.contains(result.getFilename())) continue;
                AixFlowResultDAO.deleteByFilename(conSet.getConnection(), result.getFilename());
                ++deletedCount;
            }
            form.setResponseData("success", true);
            form.setResponseData("message", "Cleanup completed. Deleted " + deletedCount + " orphaned results.");
            form.setResponseData("deletedCount", deletedCount);
        }
        catch (Exception e) {
            this.log.error("Failed to cleanup n8n results", e);
            form.setResponseData("success", false);
            form.setResponseData("message", "Error during cleanup: " + e.getMessage());
        }
        return this.json(conSet, form);
    }

    public ActionForward updateDatabaseSchema(DynActionForm form, ConnectionSet conSet) throws Exception {
        block37: {
            try {
                String tableName = "aixflow_results";
                try (PreparedStatement ps = conSet.getConnection().prepareStatement("SELECT TABLE_NAME FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME IN ('aixflow_results','aixflow_n8n_results','plugin_aixflow_n8n_results') ORDER BY CASE TABLE_NAME WHEN 'aixflow_results' THEN 0 WHEN 'aixflow_n8n_results' THEN 1 ELSE 2 END LIMIT 1");
                     ResultSet rs = ps.executeQuery();){
                    if (rs.next()) {
                        tableName = rs.getString(1);
                    }
                }
                boolean columnExists = false;
                try (PreparedStatement ps = conSet.getConnection().prepareStatement("SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = ? AND COLUMN_NAME = 'raw_response'");){
                    ps.setString(1, tableName);
                    try (ResultSet rs = ps.executeQuery();){
                        columnExists = rs.next();
                    }
                }
                if (!columnExists) {
                    String alterSql = "ALTER TABLE " + tableName + " ADD COLUMN raw_response JSON";
                    try (PreparedStatement ps = conSet.getConnection().prepareStatement(alterSql);){
                        ps.executeUpdate();
                        this.log.info("Added raw_response column to " + tableName + " table", new Object[0]);
                    }
                    form.setResponseData("success", true);
                    form.setResponseData("message", "Database schema updated successfully. Added raw_response column.");
                    break block37;
                }
                form.setResponseData("success", true);
                form.setResponseData("message", "Database schema is already up to date. raw_response column exists.");
            }
            catch (Exception e) {
                this.log.error("Failed to update database schema", e);
                form.setResponseData("success", false);
                form.setResponseData("message", "Error updating schema: " + e.getMessage());
            }
        }
        return this.json(conSet, form);
    }

    public ActionForward sendTextForDiarization(DynActionForm form, ConnectionSet conSet) throws Exception {
        String text = form.getParam("text");
        String filename = form.getParam("filename");
        String hash = form.getParam("hash");
        if (Utils.isBlankString(text)) {
            form.setResponseData("success", false);
            form.setResponseData("message", "Text is required for diarization");
            return this.json(conSet, form);
        }
        if (Utils.isBlankString(hash)) {
            form.setResponseData("success", false);
            form.setResponseData("message", "Hash is required for diarization");
            return this.json(conSet, form);
        }
        try {
            Config config = Setup.getSetup().getConfig(Config.class);
            if (config == null || Utils.isBlankString(config.getN8nUrl())) {
                form.setResponseData("success", false);
                form.setResponseData("message", "N8n service is not configured. Please check configuration.");
                return this.json(conSet, form);
            }
            AixFlowService aixFlowService = new AixFlowService(config);
            AixFlowService.AixFlowResponse response = aixFlowService.sendTextForDiarization(text, hash);
            form.setResponseData("success", true);
            form.setResponseData("message", "Text sent for diarization successfully");
            form.setResponseData("hash", response.getHash());
            form.setResponseData("filename", response.getFilename());
            form.setResponseData("status", response.getStatus());
            if ("completed".equals(response.getStatus()) && Utils.notBlankString(response.getFilename())) {
                try {
                    AixFlowResultDAO.createTable(conSet.getConnection());
                    AixFlowResultDAO.saveDiarizationResult(conSet.getConnection(), filename, response.getHash(), response.getStatus(), response.getFilename(), response.getRawResponse());
                    this.log.info("Diarization result saved for filename: {}", filename);
                }
                catch (Exception saveException) {
                    this.log.error("Failed to save diarization result", saveException);
                }
            }
        }
        catch (Exception e) {
            this.log.error("Error sending text for diarization", e);
            form.setResponseData("success", false);
            form.setResponseData("message", "Error sending text for diarization: " + e.getMessage());
        }
        return this.json(conSet, form);
    }

    public ActionForward checkDiarizationTaskStatus(DynActionForm form, ConnectionSet conSet) throws Exception {
        String hash = form.getParam("hash");
        if (Utils.isBlankString(hash)) {
            form.setResponseData("success", false);
            form.setResponseData("message", "Hash is required");
            return this.json(conSet, form);
        }
        try {
            Config config = Setup.getSetup().getConfig(Config.class);
            if (config == null || Utils.isBlankString(config.getN8nUrl())) {
                form.setResponseData("success", false);
                form.setResponseData("message", "N8n service is not configured. Please check configuration.");
                return this.json(conSet, form);
            }
            AixFlowService aixFlowService = new AixFlowService(config);
            AixFlowService.AixFlowTaskData taskData = aixFlowService.checkDiarizationTaskStatus(hash);
            form.setResponseData("success", true);
            form.setResponseData("id", taskData.getId());
            form.setResponseData("mode", taskData.getMode());
            form.setResponseData("resumeUrl", taskData.getResumeUrl());
            form.setResponseData("resumeFormUrl", taskData.getResumeFormUrl());
            form.setResponseData("text", taskData.getText());
            form.setResponseData("hash", taskData.getHash());
            form.setResponseData("durationSec", taskData.getDurationSec());
            form.setResponseData("timeSec", taskData.getTimeSec());
            form.setResponseData("filename", taskData.getFilename());
            form.setResponseData("status", taskData.getStatus());
            form.setResponseData("rawResponse", taskData.getRawResponse());
        }
        catch (Exception e) {
            this.log.error("Error checking diarization task status", e);
            form.setResponseData("success", false);
            form.setResponseData("message", "Error checking diarization task status: " + e.getMessage());
        }
        return this.json(conSet, form);
    }

    public ActionForward saveDiarizationResult(DynActionForm form, ConnectionSet conSet) throws Exception {
        String filename = form.getParam("filename");
        String diarizationHash = form.getParam("diarizationHash");
        String diarizationStatus = form.getParam("diarizationStatus");
        String diarizationResult = form.getParam("diarizationResult");
        String diarizationRawResponse = form.getParam("diarizationRawResponse");
        if (Utils.isBlankString(filename)) {
            form.setResponseData("success", false);
            form.setResponseData("message", "Filename is required");
            return this.json(conSet, form);
        }
        try {
            AixFlowResultDAO.createTable(conSet.getConnection());
            AixFlowResultDAO.saveDiarizationResult(conSet.getConnection(), filename, diarizationHash, diarizationStatus, diarizationResult, diarizationRawResponse);
            form.setResponseData("success", true);
            form.setResponseData("message", "Diarization result saved successfully");
        }
        catch (Exception e) {
            this.log.error("Failed to save diarization result", e);
            form.setResponseData("success", false);
            form.setResponseData("message", "Error saving diarization result: " + e.getMessage());
        }
        return this.json(conSet, form);
    }
}

