/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.ai.aixflow.action;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Base64;
import org.apache.struts.action.ActionForward;
import org.bgerp.action.base.BaseAction;
import org.bgerp.app.cfg.Setup;
import org.bgerp.plugin.ai.aixflow.Config;
import org.bgerp.util.Log;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;

@ActionServlet.Action(path="/admin/plugin/aixflow/admin_n8n_check", pathId=true)
public class AixFlowActionAdminN8nCheck
extends BaseAction {
    private static final String PATH_JSP = "/WEB-INF/jspf/admin/plugin/aixflow";
    private static final Log log = Log.getLog();

    @Override
    public ActionForward unspecified(DynActionForm form, ConnectionSet conSet) throws Exception {
        Config config = Setup.getSetup().getConfig(Config.class);
        form.setResponseData("n8nUrl", config.getN8nUrl());
        form.setResponseData("n8nApiKeyConfigured", !Utils.isBlankString(config.getN8nApiKey()));
        form.setResponseData("n8nRequestMethod", config.getN8nRequestMethod());
        form.setResponseData("n8nAuthUsernameConfigured", !Utils.isBlankString(config.getN8nAuthUsername()));
        form.setResponseData("n8nAuthPasswordConfigured", !Utils.isBlankString(config.getN8nAuthPassword()));
        return this.html(conSet, form, "/WEB-INF/jspf/admin/plugin/aixflow/admin_n8n_check.jsp");
    }

    public ActionForward testConnection(DynActionForm form, ConnectionSet conSet) throws Exception {
        Config config = Setup.getSetup().getConfig(Config.class);
        String n8nUrl = config.getN8nUrl();
        String n8nApiKey = config.getN8nApiKey();
        String n8nRequestMethod = config.getN8nRequestMethod();
        String n8nAuthUsername = config.getN8nAuthUsername();
        String n8nAuthPassword = config.getN8nAuthPassword();
        boolean useBasicAuth = !Utils.isBlankString(n8nAuthUsername) && !Utils.isBlankString(n8nAuthPassword);
        boolean success = false;
        Object message = "";
        StringBuilder diagnosticInfo = new StringBuilder();
        if (Utils.isBlankString(n8nUrl)) {
            message = "N8n URL is not configured";
        } else if (Utils.isBlankString(n8nApiKey) && !useBasicAuth) {
            message = "Neither API key nor Basic Auth credentials are configured";
        } else {
            if (useBasicAuth) {
                log.debug("Using Basic Authentication for n8n connection test", new Object[0]);
            } else {
                log.debug("Using API Key Authentication for n8n connection test", new Object[0]);
            }
            try {
                URL url = new URL(n8nUrl);
                String host = url.getHost();
                diagnosticInfo.append("Connection details:\n");
                diagnosticInfo.append("- Target URL: ").append(url.toString()).append("\n");
                diagnosticInfo.append("- Host: ").append(host).append("\n");
                try {
                    InetAddress address = InetAddress.getByName(host);
                    diagnosticInfo.append("- IP address: ").append(address.getHostAddress()).append("\n");
                    boolean reachable = address.isReachable(3000);
                    diagnosticInfo.append("- Host reachable: ").append(reachable ? "Yes" : "No").append("\n");
                    if (!reachable) {
                        diagnosticInfo.append("- Network diagnostic: Host is not reachable. Check firewall settings or network connectivity.\n");
                    }
                }
                catch (UnknownHostException e) {
                    diagnosticInfo.append("- DNS resolution failed: Cannot resolve hostname ").append(host).append("\n");
                    diagnosticInfo.append("- Error: ").append(e.getMessage()).append("\n");
                }
                diagnosticInfo.append("\nHTTP connection attempt:\n");
                diagnosticInfo.append("- Connection timeout: 5000ms\n");
                diagnosticInfo.append("- Read timeout: 5000ms\n");
                diagnosticInfo.append("- Request method: ").append(n8nRequestMethod).append("\n");
                if (useBasicAuth) {
                    diagnosticInfo.append("- Authentication: Basic Auth\n");
                } else {
                    diagnosticInfo.append("- Authentication: API Key\n");
                }
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod(n8nRequestMethod);
                if (useBasicAuth) {
                    String auth = n8nAuthUsername + ":" + n8nAuthPassword;
                    String encodedAuth = Base64.getEncoder().encodeToString(auth.getBytes());
                    String authHeaderValue = "Basic " + encodedAuth;
                    connection.setRequestProperty("Authorization", authHeaderValue);
                    diagnosticInfo.append("- Using Basic Auth with username: ").append(n8nAuthUsername).append("\n");
                } else {
                    connection.setRequestProperty("X-N8N-API-KEY", n8nApiKey);
                    diagnosticInfo.append("- Using API Key authentication\n");
                }
                connection.setConnectTimeout(5000);
                connection.setReadTimeout(5000);
                int responseCode = connection.getResponseCode();
                diagnosticInfo.append("- Response code: ").append(responseCode).append("\n");
                if (responseCode == 200) {
                    success = true;
                    message = "Connection successful";
                } else {
                    message = "Connection failed with response code: " + responseCode;
                    diagnosticInfo.append("- Response message: ").append(connection.getResponseMessage()).append("\n");
                    diagnosticInfo.append("- Possible causes:\n");
                    if (useBasicAuth) {
                        diagnosticInfo.append("  * Incorrect Basic Auth username or password\n");
                    } else {
                        diagnosticInfo.append("  * Incorrect API key\n");
                    }
                    diagnosticInfo.append("  * N8n service not running\n");
                    diagnosticInfo.append("  * N8n endpoint configuration issue\n");
                }
            }
            catch (IOException e) {
                Throwable rootCause;
                log.error("Error testing connection to n8n", e);
                message = "Connection failed: " + e.getMessage();
                diagnosticInfo.append("\nException details:\n");
                diagnosticInfo.append("- Exception type: ").append(e.getClass().getName()).append("\n");
                diagnosticInfo.append("- Message: ").append(e.getMessage()).append("\n");
                for (rootCause = e; rootCause.getCause() != null && rootCause.getCause() != rootCause; rootCause = rootCause.getCause()) {
                }
                if (rootCause != e) {
                    diagnosticInfo.append("- Root cause: ").append(rootCause.getClass().getName()).append("\n");
                    diagnosticInfo.append("- Root message: ").append(rootCause.getMessage()).append("\n");
                }
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                diagnosticInfo.append("\nStack trace:\n").append(sw.toString());
                diagnosticInfo.append("\nTroubleshooting tips:\n");
                if (e instanceof UnknownHostException) {
                    diagnosticInfo.append("- The hostname could not be resolved. Check DNS settings or use an IP address.\n");
                }
                if (e instanceof ConnectException) {
                    diagnosticInfo.append("- Connection refused. Ensure n8n is running and accessible on the specified port.\n");
                    diagnosticInfo.append("- Check firewall settings to ensure the port is open.\n");
                }
                if (e instanceof SocketTimeoutException) {
                    diagnosticInfo.append("- Connection timed out. The server might be slow to respond or unreachable.\n");
                    diagnosticInfo.append("- Consider increasing the connection timeout.\n");
                }
                diagnosticInfo.append("- Check network connectivity between this server and the n8n server.\n");
                diagnosticInfo.append("- Verify the n8n URL is correct and the service is running.\n");
            }
        }
        form.setResponseData("success", success);
        form.setResponseData("message", message);
        form.setResponseData("diagnosticInfo", diagnosticInfo.toString());
        form.setResponseData("n8nUrl", n8nUrl);
        form.setResponseData("n8nApiKeyConfigured", !Utils.isBlankString(n8nApiKey));
        form.setResponseData("n8nRequestMethod", n8nRequestMethod);
        form.setResponseData("n8nAuthUsernameConfigured", !Utils.isBlankString(n8nAuthUsername));
        form.setResponseData("n8nAuthPasswordConfigured", !Utils.isBlankString(n8nAuthPassword));
        form.setResponseData("useBasicAuth", useBasicAuth);
        return this.json(conSet, form);
    }
}

