/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.ai.aixflow;

import org.bgerp.app.cfg.Config;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.util.Log;

public class Config
extends org.bgerp.app.cfg.Config {
    private static final Log log = Log.getLog();
    private static final String CONFIG_N8N_URL = "n8n.url";
    private static final String CONFIG_N8N_API_KEY = "n8n.apiKey";
    private static final String CONFIG_N8N_REQUEST_METHOD = "n8n.requestMethod";
    private static final String CONFIG_N8N_AUTH_USERNAME = "n8n.auth.username";
    private static final String CONFIG_N8N_AUTH_PASSWORD = "n8n.auth.password";
    private static final String CONFIG_N8N_FILE_FORMAT = "n8n.fileFormat";
    private final String n8nUrl;
    private final String n8nApiKey;
    private final String n8nRequestMethod;
    private final String n8nAuthUsername;
    private final String n8nAuthPassword;
    private final String n8nFileFormat;

    protected Config(ConfigMap config) throws Config.InitStopException {
        super(null);
        if (config == null) {
            this.n8nUrl = "";
            this.n8nApiKey = "";
            this.n8nRequestMethod = "GET";
            this.n8nAuthUsername = "";
            this.n8nAuthPassword = "";
            this.n8nFileFormat = "binary";
            return;
        }
        config = config.sub("aixflow:");
        this.n8nUrl = config.get(CONFIG_N8N_URL, "");
        this.n8nApiKey = config.get(CONFIG_N8N_API_KEY, "");
        this.n8nRequestMethod = config.get(CONFIG_N8N_REQUEST_METHOD, "GET");
        this.n8nAuthUsername = config.get(CONFIG_N8N_AUTH_USERNAME, "");
        this.n8nAuthPassword = config.get(CONFIG_N8N_AUTH_PASSWORD, "");
        this.n8nFileFormat = config.get(CONFIG_N8N_FILE_FORMAT, "binary");
        log.debug("N8n URL: {}", this.n8nUrl);
        log.debug("N8n API key configured: {}", !this.n8nApiKey.isEmpty());
        log.debug("N8n request method: {}", this.n8nRequestMethod);
        log.debug("N8n Basic Auth username configured: {}", !this.n8nAuthUsername.isEmpty());
        log.debug("N8n Basic Auth password configured: {}", !this.n8nAuthPassword.isEmpty());
        log.debug("N8n file format: {}", this.n8nFileFormat);
        boolean hasApiKey = !this.n8nApiKey.isEmpty();
        boolean hasBasicAuth = !this.n8nAuthUsername.isEmpty() && !this.n8nAuthPassword.isEmpty();
        this.initWhen(!this.n8nUrl.isEmpty() && (hasApiKey || hasBasicAuth));
    }

    public String getN8nUrl() {
        return this.n8nUrl;
    }

    public String getN8nApiKey() {
        return this.n8nApiKey;
    }

    public String getN8nRequestMethod() {
        return this.n8nRequestMethod;
    }

    public String getN8nAuthUsername() {
        return this.n8nAuthUsername;
    }

    public String getN8nAuthPassword() {
        return this.n8nAuthPassword;
    }

    public String getN8nFileFormat() {
        return this.n8nFileFormat;
    }
}

