/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.app.dist.inst;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.dist.inst.Module;
import org.bgerp.app.dist.inst.call.InstallationCall;
import org.bgerp.util.Log;
import ru.bgcrm.util.ZipUtils;

public class InstallerModule {
    private static final Log log = Log.getLog();
    protected static final String MESSAGE_ERROR = "ERROR";
    protected static final String MESSAGE_OK = "OK";
    private static final String SUFFIX_ORIG = ".orig";
    private static final String INFIX_BAK = ".bak.";
    public static final String ENTRY_CONTENT = "content";
    private static final int ENTRY_CONTENT_LENGTH = "content".length();
    public static final String ENTRY_MODULE_PROPERTIES = "module.properties";
    private static final Set<String> CLEANED_DIRS_UPDATE = Set.of("action", "plugin", "webapps");
    private static final Set<String> CLEANED_DIRS_UPDATE_LIB = Set.of("lib/ext");
    private final File targetDir;
    private final List<String> paths = new ArrayList<String>(100);
    private final Set<String> cleanedDirs;
    private final Report report = new Report();

    @VisibleForTesting
    InstallerModule() {
        this.targetDir = null;
        this.cleanedDirs = null;
    }

    public InstallerModule(Setup setup, File targetDir, File zip) throws Exception {
        this.targetDir = targetDir;
        Module mi = this.getModuleInf(zip);
        if (mi == null || mi.hasErrors()) {
            throw new IllegalArgumentException("Module info was not found or incorrect");
        }
        if ("update".equals(mi.getName())) {
            this.cleanedDirs = CLEANED_DIRS_UPDATE;
        } else if ("update_lib".equals(mi.getName())) {
            this.cleanedDirs = CLEANED_DIRS_UPDATE_LIB;
        } else {
            throw new IllegalArgumentException("Unsupported module: " + mi.getName());
        }
        this.executeCalls(mi, setup, zip);
        log.info("Execute calls => {}", MESSAGE_OK);
        boolean result = true;
        if (result) {
            result = this.copyFiles(zip, mi);
            log.info("File copy => {}", result ? MESSAGE_OK : MESSAGE_ERROR);
        }
        if (!result) {
            log.error("Module was not installed.", new Object[0]);
        } else {
            log.info("Module {} was successfully installed!", mi.getName());
            log.info("Please, restart BGERP server.", new Object[0]);
        }
        this.removeExcessFiles();
    }

    @VisibleForTesting
    protected Module getModuleInf(File zip) {
        Module mi = null;
        try {
            FileInputStream fis = new FileInputStream(zip);
            ZipInputStream zis = new ZipInputStream(fis);
            ZipEntry ze = null;
            boolean infFound = false;
            while ((ze = zis.getNextEntry()) != null) {
                if (!ze.getName().equals(ENTRY_MODULE_PROPERTIES)) continue;
                infFound = true;
                break;
            }
            if (infFound) {
                byte[] infFile = IOUtils.toByteArray((InputStream)zis);
                mi = new Module(new String(infFile, StandardCharsets.UTF_8));
            } else {
                log.error("module.properties was not found in zip", new Object[0]);
            }
            fis.close();
        }
        catch (Exception ex) {
            log.error(ex);
        }
        return mi;
    }

    @VisibleForTesting
    protected boolean copyFiles(File zip, Module mi) {
        boolean result = false;
        String name = null;
        try (FileInputStream fis = new FileInputStream(zip);
             ZipInputStream zis = new ZipInputStream(fis);){
            for (Map.Entry<String, byte[]> me : ZipUtils.getFileEntriesFromZipByPrefix(zis, ENTRY_CONTENT).entrySet()) {
                name = me.getKey().substring(ENTRY_CONTENT_LENGTH + 1);
                if (name.trim().length() == 0) continue;
                if (name.endsWith("/")) {
                    new File(this.targetDir, name).mkdirs();
                    continue;
                }
                this.writeFile(name, me.getValue());
            }
            fis.close();
            result = true;
        }
        catch (Exception ex) {
            log.error("File's copy error.. File: {}", name);
            log.error(ex);
        }
        return result;
    }

    @VisibleForTesting
    protected void executeCalls(Module mi, Setup setup, File zip) throws Exception {
        List<String[]> calls = mi.getCalls();
        for (String[] class_param : calls) {
            String callClass = class_param[0];
            String param = class_param[1];
            log.info("Executing call {}; param: {}", callClass, param);
            String fullClassName = InstallationCall.class.getPackageName() + "." + callClass;
            InstallationCall call = (InstallationCall)Class.forName(fullClassName.toString()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            call.call(setup, zip, param);
            log.info("Result => OK", new Object[0]);
        }
    }

    private void writeFile(String path, byte[] content) throws Exception {
        this.paths.add(path);
        File file = new File(this.targetDir, path);
        if (file.exists() && !this.equal(content, file)) {
            File origFile = new File(this.targetDir, path + SUFFIX_ORIG);
            if (origFile.exists()) {
                if (this.equal(content, origFile)) {
                    log.info("File hasn't changed: {}", path);
                    return;
                }
                file.renameTo(new File(this.targetDir, path + INFIX_BAK + System.currentTimeMillis()));
            }
            this.report.replaced.add(path);
        }
        try (FileOutputStream fos = new FileOutputStream(new File(this.targetDir, path));){
            fos.write(content);
        }
    }

    private boolean equal(byte[] newContent, File existing) {
        if ((long)newContent.length == existing.length()) {
            boolean bl;
            FileInputStream fileInputStream = new FileInputStream(existing);
            try {
                byte[] existingContent = IOUtils.toByteArray((InputStream)fileInputStream);
                bl = Arrays.compare(newContent, existingContent) == 0;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        fileInputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.error(e);
                }
            }
            fileInputStream.close();
            return bl;
        }
        return false;
    }

    private void removeExcessFiles() {
        log.info("Checking of excess files.", new Object[0]);
        for (String dirPath : this.cleanedDirs) {
            try {
                this.removeExcessFiles(dirPath);
            }
            catch (IOException e) {
                log.error(e);
            }
        }
    }

    private void removeExcessFiles(String dirPath) throws IOException {
        File dir = new File(this.targetDir, dirPath);
        Set innerPaths = this.paths.stream().filter(p -> p.startsWith(dirPath)).collect(Collectors.toSet());
        if (innerPaths.isEmpty()) {
            this.delete(dirPath, dir);
            return;
        }
        for (File file : dir.listFiles()) {
            String path = dirPath + "/" + file.getName();
            if (file.isDirectory()) {
                this.removeExcessFiles(path);
                continue;
            }
            if (path.endsWith(SUFFIX_ORIG)) {
                this.report.removeSoon.add(path);
                if (innerPaths.contains(path.substring(0, path.length() - SUFFIX_ORIG.length()))) continue;
                this.delete(path, file);
                continue;
            }
            if (path.contains(INFIX_BAK)) {
                this.report.removeSoon.add(path);
                if (innerPaths.contains(StringUtils.substringBeforeLast((String)path, (String)INFIX_BAK))) continue;
                this.delete(path, file);
                continue;
            }
            if (innerPaths.contains(path)) continue;
            this.delete(path, file);
        }
    }

    private void delete(String path, File file) {
        if (!file.exists()) {
            return;
        }
        if (path.contains("custom/") || path.contains("/custom")) {
            this.report.removeSoon.add(path);
        } else {
            this.report.removed.add(path);
            FileUtils.deleteQuietly((File)file);
        }
    }

    public Report getReport() {
        return this.report;
    }

    public static class Report {
        private final Set<String> replaced = new TreeSet<String>();
        private final Set<String> removed = new TreeSet<String>();
        private final Set<String> removeSoon = new TreeSet<String>();

        public Set<String> getReplaced() {
            return this.replaced;
        }

        public Set<String> getRemoved() {
            return this.removed;
        }

        public Set<String> getRemoveSoon() {
            return this.removeSoon;
        }

        public String toString() {
            StringWriter report = new StringWriter(2000);
            PrintWriter writer = new PrintWriter(report);
            this.subReport(writer, "REPLACED:", this.replaced);
            this.subReport(writer, "REMOVED:", this.removed);
            this.subReport(writer, "REMOVE SOON:", this.removeSoon);
            return report.toString();
        }

        private void subReport(PrintWriter writer, String prefix, Collection<String> paths) {
            if (!paths.isEmpty()) {
                writer.println(prefix);
                for (String path : paths) {
                    writer.println(path);
                }
            }
        }
    }
}

