/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.bgerp.util.Log;

public class ZipUtils {
    private static final Log log = Log.getLog();

    public static ZipEntry addEntry(ZipOutputStream zos, String name, String content) throws IOException {
        ZipEntry ze = new ZipEntry(name);
        zos.putNextEntry(ze);
        if (content != null) {
            zos.write(content.getBytes(StandardCharsets.UTF_8));
        }
        zos.closeEntry();
        return ze;
    }

    public static SortedMap<String, byte[]> getFileEntriesFromZipByPrefix(ZipInputStream zis, String prefix) {
        TreeMap<String, byte[]> result = new TreeMap<String, byte[]>();
        ZipEntry ze = null;
        try {
            while ((ze = zis.getNextEntry()) != null) {
                String name = ze.getName();
                if (!name.startsWith(prefix)) continue;
                byte[] data = IOUtils.toByteArray((InputStream)zis);
                result.put(name, data);
            }
        }
        catch (Exception ex) {
            log.error(ex);
        }
        return result;
    }

    public static Map<String, byte[]> getEntriesFromZip(ZipInputStream zis, String subst) {
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        ZipEntry ze = null;
        try {
            while ((ze = zis.getNextEntry()) != null) {
                String name = ze.getName();
                if (subst != null && name.indexOf(subst) < 0) continue;
                byte[] data = IOUtils.toByteArray((InputStream)zis);
                result.put(name, data);
            }
        }
        catch (Exception ex) {
            log.error(ex);
        }
        return result;
    }
}

