/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.util;

import java.util.Random;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.exception.BGMessageException;
import ru.bgcrm.util.Utils;

public class PswdUtil {
    public static final String EMPTY_PASSWORD = "*******";
    private static final String DEFAULT_PSWD_CHARS = "1234567890qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM";
    private ConfigMap setup;
    private String prefix;

    public PswdUtil(ConfigMap config, String prefix) {
        this.setup = config;
        this.prefix = prefix;
    }

    public String generatePassword() {
        int length = this.getPasswordLengthAuto();
        String passwordChars = this.getPasswordChars();
        StringBuffer result = new StringBuffer();
        char[] array = passwordChars.toCharArray();
        int arrayLength = array.length;
        long time = System.currentTimeMillis();
        time %= 10000L;
        int[] offsets = new int[4];
        for (int i = 3; i >= 0; --i) {
            offsets[i] = (int)time % 10;
            time /= 10L;
        }
        Random random = new Random();
        for (int i = 0; i < length; ++i) {
            int pos = (offsets[i % 4] + random.nextInt(arrayLength)) % arrayLength;
            result.append(array[pos]);
        }
        return result.toString();
    }

    public void checkPassword(String pswd) throws BGMessageException {
        if (EMPTY_PASSWORD.equals(pswd)) {
            return;
        }
        this.checkPassword(pswd, pswd);
    }

    public void checkPassword(String pswd1, String pswd2) throws BGMessageException {
        int passwordMin = this.getPasswordLengthMin();
        int passwordMax = this.getPasswordLengthMax();
        String passwordChars = this.getPasswordChars();
        if (Utils.isEmptyString(pswd1) || pswd1.length() < passwordMin || pswd1.length() > passwordMax) {
            throw new BGMessageException("\u0414\u043b\u0438\u043d\u0430 \u043f\u0430\u0440\u043e\u043b\u044f \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u043e\u0442 " + passwordMin + " \u0434\u043e " + passwordMax + " \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432!", new Object[0]);
        }
        if (!this.checkPasswordChars(pswd1, passwordChars)) {
            throw new BGMessageException("\u041f\u0430\u0440\u043e\u043b\u044c \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0441\u0442\u043e\u044f\u0442\u044c \u0438\u0437 \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0445 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432 - " + passwordChars, new Object[0]);
        }
        if (pswd2 != null && !pswd1.equals(pswd2)) {
            throw new BGMessageException("\u041f\u0430\u0440\u043e\u043b\u0438 \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u044e\u0442!", new Object[0]);
        }
    }

    private boolean checkPasswordChars(String password, String passwordChars) {
        boolean result = true;
        if (password != null && passwordChars != null) {
            for (int index = 0; index < password.length(); ++index) {
                if (passwordChars.indexOf(password.charAt(index)) >= 0) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public int getPasswordLengthMin() {
        return this.setup.getInt(this.prefix + "password.length.min", 5);
    }

    public int getPasswordLengthMax() {
        return this.setup.getInt(this.prefix + "password.length.max", 10);
    }

    public int getPasswordLengthAuto() {
        return this.setup.getInt(this.prefix + "password.length.auto", this.getPasswordLengthMax());
    }

    public String getPasswordChars() {
        return this.setup.get(this.prefix + "password.chars", DEFAULT_PSWD_CHARS);
    }

    public static class UserPswdUtil
    extends PswdUtil {
        public UserPswdUtil(ConfigMap setup) {
            super(setup, "user.");
        }
    }
}

