/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling.proto.dao;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bgerp.model.Pageable;
import org.bgerp.model.base.IdTitle;
import org.bgerp.util.xml.XMLUtils;
import org.w3c.dom.Element;
import ru.bgcrm.model.Pair;
import ru.bgcrm.model.user.User;
import ru.bgcrm.plugin.bgbilling.Request;
import ru.bgcrm.plugin.bgbilling.RequestJsonRpc;
import ru.bgcrm.plugin.bgbilling.proto.dao.BillingModuleDAO;
import ru.bgcrm.plugin.bgbilling.proto.model.bill.Attribute;
import ru.bgcrm.plugin.bgbilling.proto.model.bill.AttributeType;
import ru.bgcrm.plugin.bgbilling.proto.model.bill.Bill;
import ru.bgcrm.plugin.bgbilling.proto.model.bill.Document;
import ru.bgcrm.plugin.bgbilling.proto.model.bill.Invoice;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.Utils;

public class BillDAO
extends BillingModuleDAO {
    private static final String BILL_MODULE_ID = "bill";
    private static final String BILL_MODULE = "ru.bitel.bgbilling.modules.bill";

    public BillDAO(User user, String billingId, int moduleId) {
        super(user, billingId, moduleId);
    }

    public List<AttributeType> getAttributeTypeList() {
        List<AttributeType> result = new ArrayList<AttributeType>();
        if (this.dbInfo.versionCompare("9.2") >= 0) {
            RequestJsonRpc req = new RequestJsonRpc(BILL_MODULE, this.moduleId, "BillService", "attributeTypeList");
            JsonNode ret = this.transferData.postDataReturn(req, this.user);
            result = (List)this.readJsonValue(ret.traverse(), (JavaType)this.jsonTypeFactory.constructCollectionType(List.class, AttributeType.class));
        }
        return result;
    }

    public List<Attribute> getAttributeList(int contractId) {
        List<Object> result = new ArrayList();
        if (this.dbInfo.versionCompare("9.2") >= 0) {
            RequestJsonRpc req = new RequestJsonRpc(BILL_MODULE, this.moduleId, "BillService", "attributeList");
            req.setParam("contractId", contractId);
            JsonNode ret = this.transferData.postDataReturn(req, this.user);
            result = (List)this.readJsonValue(ret.traverse(), (JavaType)this.jsonTypeFactory.constructCollectionType(List.class, Attribute.class));
            Map<String, String> types = this.getAttributeTypeList().stream().collect(Collectors.toMap(AttributeType::getName, IdTitle::getTitle));
            result = result.stream().map(attr -> {
                String title = (String)types.get(attr.getTitle());
                if (title != null) {
                    attr.setTitle(title);
                }
                return attr;
            }).collect(Collectors.toList());
        } else {
            Request req = new Request();
            req.setModule(BILL_MODULE_ID);
            req.setAction("Attribute");
            req.setModuleID(this.moduleId);
            req.setContractId(contractId);
            org.w3c.dom.Document document = this.transferData.postData(req, this.user);
            for (Element rowElement : XMLUtils.selectElements(document, "/data/table/data/row")) {
                Attribute item = new Attribute();
                item.setId(Utils.parseInt(rowElement.getAttribute("id")));
                item.setTitle(rowElement.getAttribute("title"));
                TimeUtils.parsePeriod(rowElement.getAttribute("period"), item);
                item.setValue(rowElement.getAttribute("value"));
                result.add(item);
            }
        }
        return result;
    }

    public Pair<List<IdTitle>, List<IdTitle>> getContractDocTypeList(int contractId, String type) {
        ArrayList<IdTitle> listSelected = new ArrayList<IdTitle>();
        ArrayList<IdTitle> listAvailable = new ArrayList<IdTitle>();
        Request req = new Request();
        req.setModule(BILL_MODULE_ID);
        req.setAction("DocTypeList");
        req.setModuleID(this.moduleId);
        req.setContractId(contractId);
        req.setAttribute("type", type);
        org.w3c.dom.Document document = this.transferData.postData(req, this.user);
        for (Element rowElement : XMLUtils.selectElements(document, "/data/list_select/item")) {
            listSelected.add(new IdTitle(Utils.parseInt(rowElement.getAttribute("id")), rowElement.getAttribute("title")));
        }
        for (Element rowElement : XMLUtils.selectElements(document, "/data/list_avaliable/item")) {
            listAvailable.add(new IdTitle(Utils.parseInt(rowElement.getAttribute("id")), rowElement.getAttribute("title")));
        }
        return new Pair<List<IdTitle>, List<IdTitle>>(listSelected, listAvailable);
    }

    public void contractDocTypeAdd(int contractId, String typeIds) {
        Request req = new Request();
        req.setModule(BILL_MODULE_ID);
        req.setAction("ContractDocTypeAdd");
        req.setModuleID(this.moduleId);
        req.setContractId(contractId);
        req.setAttribute("selectedItems", typeIds);
        this.transferData.postData(req, this.user);
    }

    public void contractDocTypeDelete(int contractId, String typeIds) {
        Request req = new Request();
        req.setModule(BILL_MODULE_ID);
        req.setAction("ContractDocTypeDelete");
        req.setModuleID(this.moduleId);
        req.setContractId(contractId);
        req.setAttribute("selectedItems", typeIds);
        this.transferData.postData(req, this.user);
    }

    public void searchBillList(int contractId, Pageable<Bill> searchResult) {
        Request req = new Request();
        req.setModule(BILL_MODULE_ID);
        req.setAction("ContractBill");
        req.setModuleID(this.moduleId);
        req.setContractId(contractId);
        this.setPage(req, searchResult.getPage());
        org.w3c.dom.Document doc = this.transferData.postData(req, this.user);
        for (Element row : XMLUtils.selectElements(doc, "/data/table/data/row")) {
            Bill bill = new Bill();
            this.loadDocumentFields(row, bill);
            bill.setStatusTitle(row.getAttribute("status"));
            bill.setCreateUser(row.getAttribute("who_created"));
            bill.setPayDate(TimeUtils.parse(row.getAttribute("pay_dt"), "ymd"));
            bill.setPayUser(row.getAttribute("who_payed"));
            searchResult.getList().add(bill);
        }
        this.getPage(searchResult.getPage(), XMLUtils.selectElement(doc, "/data/table"));
    }

    public void searchInvoiceList(int contractId, Pageable<Invoice> searchResult) {
        Request req = new Request();
        req.setModule(BILL_MODULE_ID);
        req.setAction("ContractInvoice");
        req.setModuleID(this.moduleId);
        req.setContractId(contractId);
        this.setPage(req, searchResult.getPage());
        org.w3c.dom.Document doc = this.transferData.postData(req, this.user);
        for (Element row : XMLUtils.selectElements(doc, "/data/table/data/row")) {
            Invoice bill = new Invoice();
            this.loadDocumentFields(row, bill);
            bill.setShowOnWeb(Utils.parseBoolean(row.getAttribute("show_ready")));
            searchResult.getList().add(bill);
        }
        this.getPage(searchResult.getPage(), XMLUtils.selectElement(doc, "/data/table"));
    }

    private void loadDocumentFields(Element row, Document bill) {
        bill.setId(Utils.parseInt(row.getAttribute("id")));
        bill.setMonth(row.getAttribute("month"));
        bill.setNumber(row.getAttribute("number"));
        bill.setCreateDate(TimeUtils.parse(row.getAttribute("create_dt"), "ymd"));
        bill.setTypeTitle(row.getAttribute("type_title"));
        bill.setSumma(Utils.parseBigDecimal(row.getAttribute("summ")));
    }

    public void setPayed(String ids, boolean value, Date date, BigDecimal summa, String comment) {
        Request req = new Request();
        req.setModule(BILL_MODULE_ID);
        req.setAction("SetPayed");
        req.setModuleID(this.moduleId);
        req.setAttribute("value", value);
        req.setAttribute("ids", ids);
        if (value) {
            req.setAttribute("date", TimeUtils.format(date, "dd.MM.yyyy"));
            req.setAttribute("summComment", Utils.format(summa) + ":" + Utils.maskNull(comment));
        }
        this.transferData.postData(req, this.user);
    }

    public byte[] getDocumentsPdf(String ids, String type) {
        Request req = new Request();
        req.setModule(BILL_MODULE_ID);
        req.setAction("ViewDocs");
        req.setModuleID(this.moduleId);
        req.setAttribute("type", type);
        req.setAttribute("codes", ids);
        req.setAttribute("contentType", "application/pdf");
        return this.transferData.postDataGetBytes(req, this.user);
    }
}

