/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.plugin.bgbilling;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.bgerp.action.base.BaseAction;
import org.bgerp.app.cfg.Preferences;
import org.bgerp.app.exception.BGException;
import org.bgerp.app.exception.BGMessageException;
import org.bgerp.util.Log;
import org.bgerp.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import ru.bgcrm.model.user.User;
import ru.bgcrm.plugin.bgbilling.DBInfo;
import ru.bgcrm.plugin.bgbilling.DBInfoManager;
import ru.bgcrm.plugin.bgbilling.Request;
import ru.bgcrm.plugin.bgbilling.RequestJsonRpc;
import ru.bgcrm.plugin.bgbilling.proto.dao.PluginDAO;
import ru.bgcrm.plugin.bgbilling.proto.model.BGServerFile;
import ru.bgcrm.plugin.bgbilling.transfer.UserAccount;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.Utils;

public class TransferData {
    private static final Log log = Log.getLog();
    private static final String REQUEST_ENCODING = "UTF-8";
    private static final String RESPONSE_ENCODING = "UTF-8";
    private static final int LOGGING_REQUEST_TRIM_LENGTH = 3000;
    private static final int LOGGING_RESPONSE_TRIM_LENGTH = 5000;
    private static final Pattern CHARACTER_ENTITY_INVALID_REGEXP = Pattern.compile("&#0;|&#1;|&#2;|&#3;|&#4;|&#5;|&#6;|&#7;|&#8;|&#11;|&#12;|&#14;|&#15;|&#16;|&#17;|&#18;|&#19;|&#20;|&#21;|&#22;|&#23;|&#24;|&#25;|&#26;|&#27;|&#28;|&#29;|&#30;|&#31;");
    private final DBInfo dbInfo;
    private final URL url;
    private final int timeOut;
    private final ObjectMapper jsonMapper = new ObjectMapper();

    public TransferData(DBInfo dbInfo) {
        this.dbInfo = dbInfo;
        this.url = dbInfo.getServerUrl();
        this.jsonMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        TimeZone timezone = TimeZone.getDefault();
        try {
            timezone = TimeZone.getTimeZone(dbInfo.getSetup().get("timezone"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.jsonMapper.setDateFormat((DateFormat)((Object)new BitelJsonDateFormat(timezone)));
        this.timeOut = dbInfo.getSetup().getInt("requestTimeOut", 5000);
    }

    public ObjectMapper getObjectMapper() {
        return this.jsonMapper;
    }

    private Document getDocument(String str) throws Exception {
        int len = str.length();
        if (log.isDebugEnabled()) {
            log.debug(this.hashCode() + " [ length = " + len + " ] xml = " + (String)(len > 5000 ? str.substring(0, 5000) + "..." : str.toString()), new Object[0]);
        }
        str = CHARACTER_ENTITY_INVALID_REGEXP.matcher(str).replaceAll("?");
        return XMLUtils.parseDocument(new InputSource(new StringReader(str.toString())));
    }

    public Document postData(Request request, User user) {
        try {
            Document doc = this.getDocument(new String(this.postDataInternal(request, user), "UTF-8"));
            this.checkDocumentStatus(doc, user);
            return doc;
        }
        catch (Exception e) {
            throw new BGException(e);
        }
    }

    public JsonNode postData(RequestJsonRpc request, User user) {
        try {
            JsonNode rootNode = this.postDataInternal(request, user);
            this.checkDocumentStatus(rootNode, user);
            return rootNode.path("data");
        }
        catch (BGException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BGException(e);
        }
    }

    public JsonNode postDataReturn(RequestJsonRpc request, User user) {
        return this.postData(request, user).path("return");
    }

    public byte[] postDataGetBytes(Request request, User user) {
        try {
            return this.postDataInternal(request, user);
        }
        catch (Exception e) {
            throw new BGException(e);
        }
    }

    public String postDataGetString(Request request, User user) {
        try {
            return new String(this.postDataGetBytes(request, user), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new BGException(e);
        }
    }

    public int uploadFile(String handler, BGServerFile bgServerFile, InputStream inputStream, User user) throws IOException, URISyntaxException {
        UserAccount userAccount = UserAccount.getUserAccount(this.dbInfo.getId(), user);
        String userAndPswd = userAccount.getLogin() + ":" + userAccount.getPassword();
        HttpURLConnection con = (HttpURLConnection)new URI(this.url.toString() + "/upload").toURL().openConnection();
        con.setRequestMethod("POST");
        con.setRequestProperty("Content-Type", "application/octet-stream");
        con.setRequestProperty("Authorization", "Basic " + Base64.getEncoder().encodeToString(userAndPswd.getBytes(StandardCharsets.UTF_8)));
        con.setRequestProperty("bgbilling-handler", handler);
        String json = BaseAction.MAPPER.writeValueAsString((Object)bgServerFile);
        con.setRequestProperty("bgbilling-file-info", Base64.getEncoder().encodeToString(json.getBytes(StandardCharsets.UTF_8)));
        con.setDoOutput(true);
        con.setDoInput(true);
        OutputStream outputStream = con.getOutputStream();
        IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        int id = -1;
        if (con.getResponseCode() == 200) {
            id = Utils.parseInt(con.getHeaderField("bgbilling-file-id"), -1);
        }
        outputStream.close();
        con.disconnect();
        log.debug("{} {} => {}", handler, json, id);
        return id;
    }

    public void initSession(User user) {
        if (this.dbInfo.getPluginSet() == null) {
            HashSet<String> pluginSet = new HashSet<String>();
            this.dbInfo.setPluginSet(pluginSet);
            pluginSet.addAll(new PluginDAO(user, this.dbInfo).getInstalledPlugins());
        }
        if (this.dbInfo.getGuiConfigValues() == null) {
            Preferences prefs = new Preferences();
            this.dbInfo.setGuiConfigValues(prefs);
            Request request = new Request();
            request.setModule("admin");
            request.setAction("MenuAndToolBar");
            Document doc = this.postData(request, user);
            for (Element param : XMLUtils.selectElements(doc, "/data/params/param")) {
                prefs.put(param.getAttribute("key"), param.getAttribute("value"));
            }
            String version = doc.getDocumentElement().getAttribute("serverversion");
            if (Utils.notBlankString(version) && Utils.isBlankString(this.dbInfo.getVersion())) {
                for (String supported : DBInfoManager.SUPPORTED_VERSIONS) {
                    if (!version.startsWith(supported)) continue;
                    log.info("Using version: {}", version);
                    this.dbInfo.setVersion(version);
                    break;
                }
                if (Utils.isBlankString(this.dbInfo.getVersion())) {
                    throw new BGException("Can't define BGBilling server version", new Object[0]);
                }
            }
        }
    }

    private byte[] postDataInternal(Request request, User user) throws IOException {
        UserAccount userAccount = UserAccount.getUserAccount(this.dbInfo.getId(), user);
        try {
            return new RequestTask(request, userAccount.getLogin(), userAccount.getPassword()).call();
        }
        catch (SocketTimeoutException e) {
            throw new BGException("\u0412\u0440\u0435\u043c\u044f \u043e\u0436\u0438\u0434\u0430\u043d\u0438\u044f \u043e\u0442\u0432\u0435\u0442\u0430 \u043e\u0442 \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0430 \u0438\u0441\u0442\u0435\u043a\u043b\u043e! ({} \u043c\u0441).", this.timeOut);
        }
    }

    private JsonNode postDataInternal(RequestJsonRpc request, User user) throws IOException, URISyntaxException {
        try {
            return new RequestTaskJsonRpc(request, UserAccount.getUserAccount(this.dbInfo.getId(), user)).call();
        }
        catch (SocketTimeoutException e) {
            throw new BGException("\u0412\u0440\u0435\u043c\u044f \u043e\u0436\u0438\u0434\u0430\u043d\u0438\u044f \u043e\u0442\u0432\u0435\u0442\u0430 \u043e\u0442 \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0430 \u0438\u0441\u0442\u0435\u043a\u043b\u043e! ({} \u043c\u0441).", this.timeOut);
        }
    }

    private String encode(String inValue) {
        String outValue = "";
        try {
            outValue = URLEncoder.encode(inValue, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return outValue;
    }

    private void checkDocumentStatus(Document doc, User user) throws BGMessageException {
        String status = XMLUtils.selectText(doc, "/data/@status");
        if (!"ok".equals(status)) {
            throw new BGException("\u041d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f {} \u0431\u0438\u043b\u043b\u0438\u043d\u0433 {} \u0432\u0435\u0440\u043d\u0443\u043b \u043e\u0448\u0438\u0431\u043a\u0443 {}", user.getLogin(), this.dbInfo.getId(), XMLUtils.selectText(doc, "/data/text()"));
        }
    }

    private void checkDocumentStatus(JsonNode rootNode, User user) throws BGMessageException {
        String status = rootNode.path("status").textValue();
        if (!"ok".equals(status)) {
            String exceptionType = rootNode.path("exception").textValue();
            if (exceptionType != null && exceptionType.equals("ru.bitel.bgbilling.common.BGMessageException")) {
                throw new BGException("\u041d\u0430 \u0437\u0430\u043f\u0440\u043e\u0441 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f {} \u0431\u0438\u043b\u043b\u0438\u043d\u0433 {} \u0432\u0435\u0440\u043d\u0443\u043b \u043e\u0448\u0438\u0431\u043a\u0443 {}", user.getLogin(), this.dbInfo.getId(), rootNode.path("message").textValue());
            }
            throw new BGException(rootNode.path("message").textValue(), new Object[0]);
        }
    }

    public String toString() {
        return "url = " + String.valueOf(this.url);
    }

    private static class BitelJsonDateFormat
    extends StdDateFormat {
        private static final TimeZone CURRENT_TIMEZONE = TimeZone.getDefault();
        private static final String BITEL_FORMAT = "yyyy-MM-dd'T'HH:mm:ssXXX";

        private BitelJsonDateFormat(TimeZone tz) {
            super(tz, Locale.getDefault(), Boolean.valueOf(true));
        }

        protected Date _parseDate(String dateStr, ParsePosition pos) throws ParseException {
            Date result = this.getDateFormat().parse(dateStr, pos);
            if (result == null) {
                result = TimeUtils.parse(dateStr, "dd.MM.yyyy");
            }
            if (result == null) {
                result = super._parseDate(dateStr, pos);
            }
            return TimeUtils.timezoneChange(result, this._timezone, CURRENT_TIMEZONE);
        }

        public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
            return this.getDateFormat().format(TimeUtils.timezoneChange(date, CURRENT_TIMEZONE, this._timezone), toAppendTo, fieldPosition);
        }

        private SimpleDateFormat getDateFormat() {
            SimpleDateFormat df = new SimpleDateFormat(BITEL_FORMAT);
            df.setTimeZone(this._timezone);
            return df;
        }

        public BitelJsonDateFormat clone() {
            return new BitelJsonDateFormat(this._timezone);
        }
    }

    private class RequestTask
    implements Callable<byte[]> {
        private Request request;
        private String userName;
        private String userPswd;

        public RequestTask(Request request, String userName, String userPswd) {
            this.request = request;
            this.userName = userName;
            this.userPswd = userPswd;
        }

        @Override
        public byte[] call() throws IOException {
            return this.postData(this.request, this.userName, this.userPswd);
        }

        private byte[] postData(Request request, String userName, String userPswd) throws IOException {
            byte[] inBytes = null;
            byte[] userInfo = (userName + ":" + userPswd).getBytes();
            HttpURLConnection con = (HttpURLConnection)TransferData.this.url.openConnection();
            con.setRequestMethod("POST");
            con.setDoOutput(true);
            con.setDoInput(true);
            con.setReadTimeout(TransferData.this.timeOut);
            con.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
            con.setRequestProperty("Authorization", "Basic " + Base64.getEncoder().encodeToString(userInfo));
            String markerParam = TransferData.this.dbInfo.getSetup().get("markerRequestParam");
            if (Utils.notBlankString(markerParam)) {
                String param = StringUtils.substringBefore((String)markerParam, (String)":");
                String value = Utils.maskEmpty(StringUtils.substringAfter((String)markerParam, (String)":"), "BGERP");
                request.setAttribute(param, value);
            }
            request.setAttribute("authToSession", 0);
            PrintStream ps = new PrintStream(con.getOutputStream(), true);
            for (String key : request.keys()) {
                ps.print(key);
                ps.print('=');
                ps.print(TransferData.this.encode(request.getValue(key).toString()));
                ps.print('&');
            }
            if (log.isDebugEnabled()) {
                StringBuilder buf = new StringBuilder();
                for (String key : request.keys()) {
                    buf.append(key);
                    buf.append('=');
                    buf.append(TransferData.this.encode(request.getValue(key).toString()));
                    buf.append('&');
                }
                log.debug(this.hashCode() + " " + String.valueOf(TransferData.this.url) + "?" + (buf.length() < 3000 ? buf.toString() : buf.substring(0, 3000)), new Object[0]);
                buf = null;
            }
            if (con.getResponseCode() == 200) {
                inBytes = IOUtils.toByteArray((InputStream)con.getInputStream());
                con.disconnect();
            }
            return inBytes;
        }
    }

    private class RequestTaskJsonRpc
    implements Callable<JsonNode> {
        private final RequestJsonRpc request;
        private final UserAccount user;

        public RequestTaskJsonRpc(RequestJsonRpc request, UserAccount user) {
            this.request = request;
            this.user = user;
        }

        @Override
        public JsonNode call() throws IOException, URISyntaxException {
            return this.postData(this.request, this.user);
        }

        private JsonNode postData(RequestJsonRpc request, UserAccount user) throws IOException, URISyntaxException {
            JsonNode result = null;
            ObjectNode rootObject = TransferData.this.jsonMapper.createObjectNode();
            rootObject.put("method", request.getMethod());
            ObjectNode userObject = rootObject.putObject("user");
            userObject.put("user", user.getLogin());
            userObject.put("pswd", user.getPassword());
            ObjectNode paramsObject = rootObject.putObject("params");
            for (Map.Entry<String, Object> me : request.getParams().entrySet()) {
                paramsObject.putPOJO(me.getKey(), me.getValue());
            }
            URL fullUrl = new URI(TransferData.this.url.toString() + "/json/" + request.getUrl()).toURL();
            HttpURLConnection con = (HttpURLConnection)fullUrl.openConnection();
            con.setRequestMethod("POST");
            con.setDoOutput(true);
            con.setDoInput(true);
            con.setReadTimeout(TransferData.this.timeOut);
            con.setRequestProperty("Content-type", "application/json; charset=UTF-8");
            String serialized = TransferData.this.jsonMapper.writer().writeValueAsString((Object)rootObject);
            if (log.isDebugEnabled()) {
                log.debug(this.hashCode() + " " + String.valueOf(fullUrl), new Object[0]);
                log.debug(this.hashCode() + " " + (serialized.length() < 3000 ? serialized : serialized.substring(0, 3000)), new Object[0]);
            }
            try (PrintStream ps = new PrintStream(con.getOutputStream(), true, "UTF-8");){
                ps.print(serialized);
            }
            if (con.getResponseCode() == 200) {
                String response = new String(IOUtils.toByteArray((InputStream)con.getInputStream()), "UTF-8");
                if (log.isDebugEnabled()) {
                    int len = response.length();
                    log.debug(this.hashCode() + " [ length = " + len + " ] JSON = " + (String)(len > 5000 ? response.substring(0, 5000) + "..." : response), new Object[0]);
                }
                result = TransferData.this.jsonMapper.readTree(response);
                con.disconnect();
            }
            return result;
        }
    }
}

