/*
 * Decompiled with CFR 0.152.
 */
package ru.bgcrm.model.process;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bgerp.cache.ProcessTypeCache;
import org.bgerp.model.base.tree.TreeItem;
import ru.bgcrm.model.process.TypeProperties;

public class ProcessType
extends TreeItem<Integer, ProcessType>
implements Comparable<ProcessType> {
    private static final int MIN_TITLE_LENGTH = 15;
    private boolean useParentProperties;
    private TypeProperties properties;

    public ProcessType() {
    }

    public ProcessType(int id, String title) {
        this.id = id;
        this.title = title;
    }

    public String getTypeTitle() {
        Object result = super.getTitle();
        if (((String)result).length() < 15 && this.parentId != null && (Integer)this.parentId > 0) {
            result = ProcessTypeCache.getProcessTypeSafe((Integer)this.parentId).getTitle() + " / " + (String)result;
        }
        return result;
    }

    public TypeProperties getProperties() {
        return this.properties;
    }

    public void setProperties(TypeProperties properties) {
        this.properties = properties;
    }

    public boolean isUseParentProperties() {
        return this.useParentProperties;
    }

    public void setUseParentProperties(boolean useParentProperties) {
        this.useParentProperties = useParentProperties;
    }

    @JsonIgnore
    public List<ProcessType> getPath() {
        return ProcessTypeCache.getTypePath((Integer)this.id);
    }

    public Set<Integer> getSelectedChildIds(Set<Integer> typeSet) {
        HashSet<Integer> result = new HashSet<Integer>(typeSet.size());
        for (ProcessType childItem : this.children) {
            if (result.contains(childItem.getId())) continue;
            if (typeSet.contains(childItem.getId())) {
                result.addAll(childItem.getAllChildIds());
                continue;
            }
            result.addAll(childItem.getSelectedChildIds(typeSet));
        }
        return result;
    }

    @Override
    public int compareTo(ProcessType o) {
        return (Integer)this.id - (Integer)o.getId();
    }

    @Override
    protected boolean isRootNode() {
        return this.isRootNodeWithIntegerId((Integer)this.id, (Integer)this.parentId);
    }
}

