/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.util.sql.pool;

import java.sql.Connection;
import java.sql.SQLException;
import java.time.Duration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.sql.DataSource;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DriverManagerConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnection;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.app.exception.alarm.AlarmSender;
import org.bgerp.util.Log;
import org.bgerp.util.sql.pool.GuardSupportedPool;
import org.bgerp.util.sql.pool.TrashDatabaseSelector;
import org.bgerp.util.sql.pool.fakesql.FakeConnection;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.ConnectionSet;

public class ConnectionPool {
    private static final Log log = Log.getLog();
    private static final int MAX_IDLE_DEFAULT = 20;
    private static final int MAX_ACTIVE_DEFAULT = 300;
    private static final String PROPERTY_USER = "user";
    private static final String PROPERTY_CHAR_SET = "charSet";
    private static final String PROPERTY_PASSWORD = "password";
    public static final int RETURN_NULL = -1;
    public static final int RETURN_FAKE = 0;
    public static final int RETURN_SLAVE = 1;
    public static final int RETURN_MASTER = 2;
    private final String name;
    private boolean dbTrace;
    private boolean disablePreventionSlaveOverrun = false;
    private final ConcurrentMap<Object, StackTraceElement[]> trace = new ConcurrentHashMap<Object, StackTraceElement[]>();
    private GuardSupportedPool connectionPool;
    private DataSource dataSource;
    private final AtomicLong lastMasterErrorTime = new AtomicLong();
    private static final long MASTER_RETEST_INTERVAL = 5000L;
    private final ConcurrentHashMap<String, GuardSupportedPool> slavePools = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Long> slaveErrorTimes = new ConcurrentHashMap();
    private static final long MIN_TIME_FOR_SLAVE_USE = 10000L;
    private final ConcurrentHashMap<String, GuardSupportedPool> trashPools = new ConcurrentHashMap();
    private TrashDatabaseSelector trashSelector;
    private final Object repMutex = new Object();
    private final Set<String> behindMasterReplications = new TreeSet<String>();
    private final Set<String> notAvailableReplications = new TreeSet<String>();

    public ConnectionPool(String name, ConfigMap map) {
        this.name = name;
        try {
            log.info(name + "Init DB connection pools.", new Object[0]);
            this.dbTrace = map.getInt("db.trace", 0) > 0;
            this.disablePreventionSlaveOverrun = map.getInt("db.disable.prevention.slave.overrun", 0) > 0;
            this.connectionPool = this.initConnectionPool(map, "db.");
            for (String slaveId : map.subKeyed("db.slave.").keySet()) {
                log.info(name + "Init slave pool {}", slaveId);
                this.slavePools.put(slaveId, this.initConnectionPool(map, "db.slave." + slaveId + "."));
            }
            log.info(name + "Init trash pools..", new Object[0]);
            for (String trashId : map.subKeyed("db.trash.").keySet()) {
                log.info(name + "Init trash pool {}", trashId);
                this.trashPools.put(trashId, this.initConnectionPool(map, "db.trash." + trashId + "."));
            }
            this.trashSelector = new TrashDatabaseSelector(map);
            if (this.connectionPool != null) {
                this.dataSource = this.connectionPool.dataSource;
            }
        }
        catch (Exception ex) {
            log.error(name + ex.getMessage(), ex);
        }
    }

    private GuardSupportedPool initConnectionPool(ConfigMap prefs, String prefix) throws Exception {
        String dbURL = prefs.get(prefix + "url", null);
        log.info("url: " + dbURL, new Object[0]);
        if (Utils.notBlankString(dbURL)) {
            Properties properties = new Properties();
            properties.setProperty(PROPERTY_USER, prefs.get(prefix + PROPERTY_USER));
            properties.setProperty(PROPERTY_PASSWORD, prefs.get(prefix + "pswd"));
            properties.setProperty(PROPERTY_CHAR_SET, prefs.get(prefix + "charset", ""));
            properties.setProperty("jdbcCompliantTruncation", "false");
            properties.setProperty("useUnicode", "true");
            properties.setProperty("characterEncoding", "UTF-8");
            properties.setProperty("zeroDateTimeBehavior", "convertToNull");
            properties.setProperty("allowMultiQueries", "true");
            properties.setProperty("useLegacyDatetimeCode", "false");
            properties.setProperty("serverTimezone", TimeZone.getDefault().getID());
            DriverManagerConnectionFactory connectionFactory = new DriverManagerConnectionFactory(dbURL, properties);
            PoolableConnectionFactory poolableConFactory = new PoolableConnectionFactory((ConnectionFactory)connectionFactory, null);
            poolableConFactory.setValidationQuery("SELECT 1");
            poolableConFactory.setValidationQueryTimeout(prefs.getInt(prefix + "validationTimeout", -1));
            Object connectionPool = null;
            connectionPool = this.dbTrace ? new GenericObjectPool<PoolableConnection>((PooledObjectFactory)poolableConFactory){

                public PoolableConnection borrowObject() throws Exception {
                    PoolableConnection result = (PoolableConnection)super.borrowObject();
                    ConnectionPool.this.trace.put(result, Thread.currentThread().getStackTrace());
                    return result;
                }

                public void returnObject(PoolableConnection obj) {
                    ConnectionPool.this.trace.remove(obj);
                    super.returnObject((Object)obj);
                }
            } : new GenericObjectPool((PooledObjectFactory)poolableConFactory);
            connectionPool.setMaxIdle(prefs.getInt(prefix + "maxIdle", 20));
            connectionPool.setMaxTotal((int)prefs.getSokLong(300L, prefix + "maxTotal", prefix + "maxActive"));
            connectionPool.setTestOnBorrow(true);
            connectionPool.setTestOnReturn(true);
            connectionPool.setTimeBetweenEvictionRuns(Duration.ofMillis(prefs.getLong(prefix + "timeBetweenEvictionRunsMillis", 30L)));
            connectionPool.setMinEvictableIdle(Duration.ofMinutes(prefs.getLong(prefix + "minEvictableIdleTimeMillis", 30L)));
            connectionPool.setTestWhileIdle(prefs.getLong(prefix + "testWhileIdle", 1L) > 0L);
            connectionPool.setSoftMinEvictableIdle(Duration.ofMillis(prefs.getLong(prefix + "softMinEvictableIdleTimeMillis", -1L)));
            connectionPool.setNumTestsPerEvictionRun(prefs.getInt(prefix + "numTestsPerEvictionRun", 3));
            connectionPool.setLifo(prefs.getBoolean(prefix + "lifo", false));
            poolableConFactory.setPool((ObjectPool)connectionPool);
            return new GuardSupportedPool((GenericObjectPool<PoolableConnection>)connectionPool);
        }
        return null;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public ConnectionSet getConnectionSet() {
        return new ConnectionSet(this, false);
    }

    public ConnectionSet getConnectionSet(boolean autoCommit) {
        return new ConnectionSet(this, autoCommit);
    }

    public void close() {
        if (this.connectionPool != null) {
            try {
                this.connectionPool.pool.close();
            }
            catch (Exception e) {
                log.error(e.getMessage(), e);
            }
        }
    }

    public final Connection getDBConnectionFromPool() {
        if (this.connectionPool == null) {
            return null;
        }
        Connection con = null;
        long lastMasterErrorTime = this.lastMasterErrorTime.get();
        if (lastMasterErrorTime != 0L) {
            long now = System.currentTimeMillis();
            if (now - lastMasterErrorTime < 5000L) {
                return null;
            }
            this.lastMasterErrorTime.compareAndSet(lastMasterErrorTime, 0L);
        }
        try {
            if (this.connectionPool.isOverload()) {
                log.error("Master pool '{}' connections limit is over", this.name);
                AlarmSender.send("db.master.connection.limit.over", 30000L, "Master DB connections limit is over", () -> "That can slow down the app instance.\nSomething has to be done to speed up work of Master DB.\n\n" + this.poolStatus());
            }
            con = this.connectionPool.dataSource.getConnection();
            con.setAutoCommit(false);
        }
        catch (Exception ex) {
            log.error(this.name + " " + ex.getMessage(), ex);
            AlarmSender.send("db.master.connect.error", 10000L, "Master DB connection error", () -> "Commection to Master DB '" + this.name + "' must be urgently restored", ex, null);
            this.lastMasterErrorTime.set(System.currentTimeMillis());
        }
        return con;
    }

    private final GuardSupportedPool getSlaveConnectionPool() {
        if (this.slavePools.size() > 0) {
            try {
                GuardSupportedPool prefPool = null;
                String prefId = null;
                long now = System.currentTimeMillis();
                float minRatio = Float.MAX_VALUE;
                for (Map.Entry<String, GuardSupportedPool> me : this.slavePools.entrySet()) {
                    float ratio;
                    Long errorTime;
                    String key = me.getKey();
                    GuardSupportedPool pool = me.getValue();
                    if (!this.isReplicationNotBehindMaster(key) || (errorTime = this.slaveErrorTimes.get(key)) != null && now - errorTime < 10000L || !((ratio = pool.getLoadRatio()) < minRatio)) continue;
                    prefPool = pool;
                    prefId = key;
                    minRatio = ratio;
                }
                try {
                    if (prefPool != null) {
                        boolean slaveOk = true;
                        if (prefPool.isOverload()) {
                            log.error("Slave pool '{}' connections limit is over", prefId);
                            AlarmSender.send("db.slave.connection.limit.over", 30000L, "Slave DB connections limit is over", () -> "That can slow down the app instance.\nSomething has to be done to speed up work of Slave DB.\n\n" + this.poolStatus());
                            slaveOk = this.disablePreventionSlaveOverrun;
                            this.slaveErrorTimes.remove(prefId);
                        }
                        if (slaveOk) {
                            return prefPool;
                        }
                    }
                }
                catch (Exception ex) {
                    log.error(this.name + " " + ex.getMessage(), ex);
                    AlarmSender.send("db.slave.connect.error", 30000L, "Slave DB connection error", () -> "Commection to Slave DB '" + this.name + "' must be urgently restored", ex, null);
                    this.slaveErrorTimes.put(prefId, now);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), e);
            }
        }
        return this.connectionPool;
    }

    public final DataSource getSlaveDataSource() {
        GuardSupportedPool pool = this.getSlaveConnectionPool();
        if (pool != null) {
            return pool.dataSource;
        }
        return this.connectionPool.dataSource;
    }

    public final Connection getDBSlaveConnectionFromPool() {
        return this.getDBSlaveConnectionFromPool(null);
    }

    public final Connection getDBSlaveConnectionFromPool(Connection master) {
        Connection con = null;
        GuardSupportedPool pool = this.getSlaveConnectionPool();
        if (pool != null) {
            try {
                con = pool.dataSource.getConnection();
            }
            catch (SQLException e) {
                log.error(e.getMessage(), e);
            }
        }
        if (con == null) {
            log.warn("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435 \u043a slave \u0431\u0430\u0437\u0435 \u0434\u0430\u043d\u043d\u044b\u0445!\n" + this.poolStatus(), new Object[0]);
            con = master == null ? this.getDBConnectionFromPool() : master;
        }
        return con;
    }

    public final Connection getDBTrashConnectionFromPool(String tableName, int retType) {
        Connection result = null;
        try {
            GuardSupportedPool trashPool;
            String trashBase = this.trashSelector.getDatabaseName(tableName);
            if (trashBase != null && (trashPool = this.trashPools.get(trashBase)) != null) {
                if (trashPool.isOverload()) {
                    result = new FakeConnection();
                    log.error("Trash pool '{}' connections limit is over", trashBase);
                    AlarmSender.send("db.trash.connection.limit.over", 30000L, "Trash DB connections limit is over", () -> "That can cause missing of some data for users.\nSomething has to be done to speed up work of Trash DB.\n\n" + this.poolStatus());
                } else {
                    result = trashPool.dataSource.getConnection();
                    result.setAutoCommit(false);
                }
            }
            if (result == null) {
                switch (retType) {
                    case 0: {
                        result = new FakeConnection();
                        break;
                    }
                    case 2: {
                        result = this.getDBConnectionFromPool();
                        break;
                    }
                    case 1: {
                        result = this.getDBSlaveConnectionFromPool();
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            result = new FakeConnection();
            log.error(e.getMessage(), e);
        }
        return result;
    }

    public final Connection getDBTrashOrMasterConnectionFromPool(String tableName) {
        return this.getDBTrashConnectionFromPool(tableName, 2);
    }

    public final Connection getDBTrashOrSlaveConnectionFromPool(String tableName) {
        return this.getDBTrashConnectionFromPool(tableName, 1);
    }

    public final Set<String> getSlaveBaseId() {
        return this.slavePools.keySet();
    }

    public final Set<String> getTrashBaseId() {
        return this.trashPools.keySet();
    }

    public final Connection getTrashConnectionFromPool(String poolId) {
        Connection con = null;
        try {
            GuardSupportedPool pool;
            if (poolId != null && (pool = this.trashPools.get(poolId)) != null) {
                con = pool.dataSource.getConnection();
                con.setAutoCommit(false);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        return con;
    }

    public String poolStatus() {
        GenericObjectPool<PoolableConnection> pool;
        String name;
        if (this.connectionPool == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer("Connections pool to Master '" + this.name + "' status ");
        sb.append(this.poolStatus(this.connectionPool.pool));
        for (Map.Entry<String, GuardSupportedPool> me : this.slavePools.entrySet()) {
            name = me.getKey();
            pool = me.getValue().pool;
            sb.append("\n");
            sb.append("Connections pool to Slave '" + name + "' status ");
            sb.append(this.poolStatus(pool));
        }
        for (Map.Entry<String, GuardSupportedPool> me : this.trashPools.entrySet()) {
            name = me.getKey();
            pool = me.getValue().pool;
            sb.append("\n");
            sb.append("Connections pool to Trash '" + name + "' status ");
            sb.append(this.poolStatus(pool));
        }
        return sb.toString();
    }

    private String poolStatus(GenericObjectPool<?> connectionPool) {
        StringBuilder sb = new StringBuilder();
        sb.append("Idle: ");
        sb.append(connectionPool.getNumIdle());
        sb.append("; Active: ");
        sb.append(connectionPool.getNumActive());
        sb.append("; maxTotal: ");
        sb.append(connectionPool.getMaxTotal());
        sb.append("; maxIdle: ");
        sb.append(connectionPool.getMaxIdle());
        return sb.toString();
    }

    public String getDbTrace() {
        StringBuilder sb = new StringBuilder(100);
        if (this.dbTrace) {
            for (Map.Entry e : this.trace.entrySet()) {
                sb.append(e.getKey()).append('\n');
                StackTraceElement[] trace = (StackTraceElement[])e.getValue();
                for (int i = 2; i < trace.length; ++i) {
                    sb.append("\tat " + String.valueOf(trace[i])).append('\n');
                }
                sb.append('\n');
            }
            if (sb.isEmpty()) {
                sb.append("No connections to DB");
            }
        } else {
            sb.append("Pool trace is off. Check db.trace option");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void setReplicationNotBehindMaster(String slaveId, boolean isNotBehind) {
        Object object = this.repMutex;
        synchronized (object) {
            if (isNotBehind) {
                this.behindMasterReplications.remove(slaveId);
            } else {
                this.behindMasterReplications.add(slaveId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean isReplicationNotBehindMaster(String slaveId) {
        Object object = this.repMutex;
        synchronized (object) {
            return !this.behindMasterReplications.contains(slaveId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public boolean isReplicationAvailable(String slaveId) {
        Object object = this.repMutex;
        synchronized (object) {
            return !this.notAvailableReplications.contains(slaveId);
        }
    }
}

