/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.pln.grpl.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.DayOfWeek;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.bgerp.cache.UserCache;
import org.bgerp.plugin.pln.grpl.model.BoardConfig;
import org.bgerp.plugin.pln.grpl.model.Cell;
import org.bgerp.util.TimeConvert;

public class Row {
    private final BoardConfig board;
    private final Date date;
    private final Map<Integer, Cell> cells;

    public Row(BoardConfig board, Date date) {
        this.board = board;
        this.date = date;
        this.cells = new HashMap<Integer, Cell>(board.columnMapSize);
    }

    public Row(BoardConfig board, ResultSet rs) throws SQLException {
        this(board, rs.getDate("date"));
    }

    public BoardConfig getBoard() {
        return this.board;
    }

    public Date getDate() {
        return this.date;
    }

    public boolean isWorkingDay() {
        if (this.date == null) {
            return true;
        }
        DayOfWeek dw = TimeConvert.toLocalDate(this.date).getDayOfWeek();
        return dw != DayOfWeek.SATURDAY && dw != DayOfWeek.SUNDAY;
    }

    public Cell setCell(int columnId, int groupId) {
        Cell result = new Cell(this, columnId, UserCache.getUserGroup(groupId));
        this.cells.put(columnId, result);
        return result;
    }

    public Cell getCell(int columnId) {
        return this.cells.get(columnId);
    }

    public boolean hasCells() {
        return !this.cells.isEmpty();
    }

    public Set<Integer> getUsedColumnIds() {
        return this.cells.keySet();
    }

    Set<Integer> excludeGroupIds() {
        return this.cells.values().stream().filter(cell -> cell.getGroup() != null).map(cell -> cell.getGroup().getId()).collect(Collectors.toSet());
    }
}

