/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.clb.team.action.open;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.stream.Collectors;
import javassist.NotFoundException;
import org.apache.struts.action.ActionForward;
import org.bgerp.action.base.BaseAction;
import org.bgerp.plugin.clb.team.dao.PartyDAO;
import org.bgerp.plugin.clb.team.model.Party;
import org.bgerp.plugin.clb.team.model.PartyBalance;
import org.bgerp.plugin.clb.team.model.PartyMember;
import org.bgerp.plugin.clb.team.model.PartyPayment;
import ru.bgcrm.model.Pair;
import ru.bgcrm.servlet.ActionServlet;
import ru.bgcrm.struts.form.DynActionForm;
import ru.bgcrm.util.Utils;

@ActionServlet.Action(path="/open/plugin/team/party")
public class PartyAction
extends BaseAction {
    private static final String PATH_JSP = "/WEB-INF/jspf/open/plugin/team/party";

    @Override
    public ActionForward unspecified(DynActionForm form, Connection con) throws Exception {
        return this.show(form, con);
    }

    public ActionForward show(DynActionForm form, Connection con) throws Exception {
        PartyDAO dao;
        Party party;
        String secret = form.getParam("secret");
        if (Utils.notBlankString(secret) && (party = (dao = new PartyDAO(con)).get(secret)) != null) {
            List<PartyMember> members = dao.getMembersWithPayments(party.getId());
            form.setResponseData("party", party);
            form.setResponseData("members", members);
            List<Pair<Integer, BigDecimal>> amounts = members.stream().map(m -> new Pair<Integer, BigDecimal>(m.getId(), m.paymentsAmount())).collect(Collectors.toList());
            form.setResponseData("balance", new PartyBalance(amounts));
        }
        return this.html(con, form, "/WEB-INF/jspf/open/plugin/team/party/show.jsp");
    }

    public ActionForward update(DynActionForm form, Connection con) throws Exception {
        Party party = new Party();
        party.setTitle(form.getParam("title", Utils::notBlankString));
        party.setSecret(Utils.generateSecret());
        new PartyDAO(con).update(party);
        form.setResponseData("party", party);
        return this.json(con, form);
    }

    public ActionForward paymentUpdate(DynActionForm form, Connection con) throws Exception {
        PartyDAO dao = new PartyDAO(con);
        Party party = this.getPartyOrThrow(dao, form.getParam("secret", Utils::notBlankString));
        PartyMember member = dao.getOrCreateMember(party.getId(), form.getParam("member", Utils::notBlankString));
        PartyPayment payment = new PartyPayment();
        payment.setPartyId(party.getId());
        payment.setMemberId(member.getId());
        payment.setAmount(Utils.parseBigDecimal(form.getParam("amount", Utils::notBlankString)));
        payment.setDescription(form.getParam("description", ""));
        dao.paymentUpdate(payment);
        return this.json(con, form);
    }

    public ActionForward paymentDelete(DynActionForm form, Connection con) throws Exception {
        PartyDAO dao = new PartyDAO(con);
        this.getPartyOrThrow(dao, form.getParam("secret", Utils::notBlankString));
        dao.paymentDelete(form.getId());
        return this.json(con, form);
    }

    private Party getPartyOrThrow(PartyDAO dao, String secret) throws SQLException, NotFoundException {
        Party result = dao.get(secret);
        if (result == null) {
            throw new NotFoundException("Not found party by secret.");
        }
        return result;
    }
}

