/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.clb.calendar.model;

import java.time.LocalTime;
import org.bgerp.app.cfg.ConfigMap;
import org.bgerp.model.base.IdTitle;
import org.bgerp.plugin.clb.calendar.model.ConfigParser;
import org.bgerp.plugin.clb.calendar.model.Mode;

public class Calendar
extends IdTitle {
    private final Mode mode = Mode.WEEK;
    private final long unitMinutes;
    private final LocalTime dayTimeFrom;
    private final LocalTime dayTimeTo;

    public Calendar(int id, ConfigMap config) {
        super(id, config.get("title", "???"));
        this.unitMinutes = ConfigParser.parse(config.get("unit.minutes", "60"));
        this.dayTimeFrom = ConfigParser.timeFrom(config, "09:00");
        this.dayTimeTo = ConfigParser.timeTo(config, "18:00");
    }

    public Mode getMode() {
        return this.mode;
    }

    public long getUnitMinutes() {
        return this.unitMinutes;
    }

    public LocalTime getDayTimeFrom() {
        return this.dayTimeFrom;
    }

    public LocalTime getDayTimeTo() {
        return this.dayTimeTo;
    }
}

