/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.plugin.bil.invoice.model;

import java.math.BigDecimal;
import java.time.Month;
import java.time.format.TextStyle;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.bgerp.model.base.Id;
import org.bgerp.plugin.bil.invoice.model.Position;
import org.bgerp.util.Log;
import org.bgerp.util.TimeConvert;
import ru.bgcrm.util.TimeUtils;
import ru.bgcrm.util.Utils;

public class Invoice
extends Id {
    private static final Log log = Log.getLog();
    private int typeId;
    private int typeTitle;
    private int processId;
    private Date dateFrom;
    private Date dateTo;
    private int numberCnt;
    private String number;
    private Date createTime;
    private int createUserId;
    private Date sentTime;
    private int sentUserId;
    private Date paymentDate;
    private int paymentUserId;
    private BigDecimal amount = BigDecimal.ZERO;
    private List<Position> positions = new ArrayList<Position>();

    public int getTypeId() {
        return this.typeId;
    }

    public void setTypeId(int typeId) {
        this.typeId = typeId;
    }

    public int getTypeTitle() {
        return this.typeTitle;
    }

    public void setTypeTitle(int typeTitle) {
        this.typeTitle = typeTitle;
    }

    public int getProcessId() {
        return this.processId;
    }

    public void setProcessId(int processId) {
        this.processId = processId;
    }

    public int getNumberCnt() {
        return this.numberCnt;
    }

    public void setNumberCnt(int numberCnt) {
        this.numberCnt = numberCnt;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public Date getDateFrom() {
        return this.dateFrom;
    }

    public void setDateFrom(Date value) {
        this.dateFrom = value;
    }

    public Date getDateTo() {
        return this.dateTo == null ? TimeUtils.getEndMonth(this.dateFrom) : this.dateTo;
    }

    public void setDateTo(Date value) {
        this.dateTo = value;
    }

    public String dateFromMonthDisplayName(String lang) {
        return this.monthDisplayName(lang, this.dateFrom);
    }

    public int dateFromYear() {
        return TimeConvert.toYearMonth(this.dateFrom).getYear();
    }

    public String monthsPeriod(String lang) {
        StringBuilder result = new StringBuilder(40).append(this.dateFromMonthDisplayName(lang)).append(" ").append(this.dateFromYear());
        Date dateTo = this.getDateTo();
        if (!TimeConvert.toYearMonth(this.dateFrom).equals(TimeConvert.toYearMonth(dateTo))) {
            result.append(" - ").append(this.monthDisplayName(lang, dateTo)).append(" ").append(TimeConvert.toYearMonth(dateTo).getYear());
        }
        return result.toString();
    }

    private String monthDisplayName(String lang, Date date) {
        Month month = TimeConvert.toYearMonth(date).getMonth();
        return month.getDisplayName(TextStyle.FULL_STANDALONE, Locale.forLanguageTag(lang));
    }

    public long months() {
        return ChronoUnit.MONTHS.between(TimeConvert.toYearMonth(this.dateFrom), TimeConvert.toYearMonth(this.getDateTo())) + 1L;
    }

    @Deprecated
    public String getDateFromMonthDisplayName(String lang) {
        log.warndMethod("getDateFromMonthDisplayName", "dateFromMonthDisplayName");
        return this.dateFromMonthDisplayName(lang);
    }

    @Deprecated
    public int getDateFromYear() {
        log.warndMethod("getDateFromYear", "dateFromYear");
        return this.dateFromYear();
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date value) {
        this.createTime = value;
    }

    @Deprecated
    public Date getCreatedTime() {
        log.warndMethod("getCreatedTime", "getCreateTime");
        return this.getCreateTime();
    }

    @Deprecated
    public void setCreatedTime(Date value) {
        log.warndMethod("setCreatedTime", "setCreateTime");
        this.setCreateTime(value);
    }

    public int getCreateUserId() {
        return this.createUserId;
    }

    public void setCreateUserId(int value) {
        this.createUserId = value;
    }

    @Deprecated
    public int getCreatedUserId() {
        log.warndMethod("getCreatedUserId", "getCreateUserId");
        return this.getCreateUserId();
    }

    @Deprecated
    public void setCreatedUserId(int value) {
        log.warndMethod("setCreatedUserId", "setCreateUserId");
        this.setCreateUserId(value);
    }

    public Date getSentTime() {
        return this.sentTime;
    }

    public void setSentTime(Date value) {
        this.sentTime = value;
    }

    public int getSentUserId() {
        return this.sentUserId;
    }

    public void setSentUserId(int value) {
        this.sentUserId = value;
    }

    public Date getPaymentDate() {
        return this.paymentDate;
    }

    public void setPaymentDate(Date value) {
        this.paymentDate = value;
    }

    public int getPaymentUserId() {
        return this.paymentUserId;
    }

    public void setPaymentUserId(int value) {
        this.paymentUserId = value;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal value) {
        this.amount = value;
    }

    public BigDecimal amount() {
        this.amount = this.positions.stream().map(Position::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        return this.amount;
    }

    public List<Position> getPositions() {
        return this.positions;
    }

    public void setPositions(List<Position> positions) {
        this.positions = positions;
    }

    public void addPosition(String id, String title, BigDecimal amount, String unit, int quantity) {
        this.positions.add(new Position(id, title, amount, unit, quantity));
    }

    public void addPosition(String id, String title, String amount, String unit, int quantity) {
        this.positions.add(new Position(id, title, Utils.parseBigDecimal(amount), unit, quantity));
    }
}

