/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.exec;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.bgerp.app.cfg.Setup;
import org.bgerp.app.cfg.bean.annotation.Bean;
import org.bgerp.app.exec.scheduler.Task;
import org.bgerp.cache.UserNewsCache;
import org.bgerp.plugin.kernel.Plugin;
import org.bgerp.util.Log;

@Bean(oldClasses={"org.bgerp.scheduler.task.NewsManager"})
public class News
extends Task {
    private static final Log log = Log.getLog();

    public News() {
        super(null);
    }

    @Override
    public String getTitle() {
        return Plugin.INSTANCE.getLocalizer().l("Kernel News", new Object[0]);
    }

    @Override
    public void run() {
        try (Connection con = Setup.getSetup().getDBConnectionFromPool();){
            String query = " UPDATE  news_user  u  INNER JOIN  news  n ON u.news_id=n.id SET u.is_read=1  WHERE DATE_ADD(n.create_dt, INTERVAL n.read_time HOUR) < NOW() AND u.is_read=0 ";
            PreparedStatement ps = con.prepareStatement(query);
            ps.executeUpdate();
            ps.close();
            con.commit();
            query = " DELETE FROM  news  WHERE DATE_ADD(create_dt, INTERVAL life_time DAY) < NOW() ";
            ps = con.prepareStatement(query);
            ps.executeUpdate();
            ps.close();
            con.commit();
            query = " DELETE u.* FROM  news_user  u  LEFT JOIN  news  n ON u.news_id=n.id  WHERE n.id IS NULL ";
            ps = con.prepareStatement(query);
            ps.executeUpdate();
            ps.close();
            con.commit();
            query = " DELETE nu.* FROM  news_user  nu  LEFT JOIN  user  u ON nu.user_id=u.id  WHERE u.id IS NULL OR u.deleted=1 ";
            ps = con.prepareStatement(query);
            ps.executeUpdate();
            ps.close();
            con.commit();
            UserNewsCache.flush(con);
        }
        catch (SQLException e) {
            log.error(e);
        }
    }
}

