/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.dao.process;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.bgerp.dao.process.Order;
import org.bgerp.dao.process.SearchDAO;
import org.bgerp.model.Pageable;
import org.bgerp.util.sql.PreparedQuery;
import ru.bgcrm.dao.process.ProcessDAO;
import ru.bgcrm.model.Page;
import ru.bgcrm.model.process.Process;
import ru.bgcrm.struts.form.DynActionForm;

public class ProcessSearchDAO
extends SearchDAO {
    public ProcessSearchDAO(Connection con) {
        super(con);
    }

    public ProcessSearchDAO(Connection con, DynActionForm form) {
        super(con, form);
    }

    @Override
    public ProcessSearchDAO withOpen(Boolean value) {
        return (ProcessSearchDAO)super.withOpen(value);
    }

    @Override
    public ProcessSearchDAO withType(Set<Integer> value) {
        return (ProcessSearchDAO)super.withType(value);
    }

    @Override
    public ProcessSearchDAO withStatus(Set<Integer> values) {
        return (ProcessSearchDAO)super.withStatus(values);
    }

    @Override
    public ProcessSearchDAO withExecutor(Set<Integer> values) {
        return (ProcessSearchDAO)super.withExecutor(values);
    }

    @Override
    public ProcessSearchDAO withoutId(Set<Integer> values) {
        return (ProcessSearchDAO)super.withoutId(values);
    }

    @Override
    public ProcessSearchDAO withIdOrDescriptionLike(String value) {
        return (ProcessSearchDAO)super.withIdOrDescriptionLike(value);
    }

    @Override
    public ProcessSearchDAO order(Order value) {
        return (ProcessSearchDAO)super.order(value);
    }

    public void search(Pageable<Process> result) throws SQLException {
        try (PreparedQuery pq = new PreparedQuery(this.con);){
            Page page = result.getPage();
            List<Process> list = result.getList();
            pq.addQuery("SELECT SQL_CALC_FOUND_ROWS ");
            if (CollectionUtils.isNotEmpty((Collection)this.executorIds)) {
                pq.addQuery("DISTINCT ");
            }
            pq.addQuery("p.* FROM  process AS p");
            this.filterExecutor(pq);
            pq.addQuery(" WHERE 1>0 ");
            this.filterOpen(pq);
            this.filterType(pq);
            this.filterStatus(pq);
            this.filterId(pq);
            this.filterIdOrDescriptionLike(pq);
            this.order(pq);
            pq.addQuery(page.getLimitSql());
            ResultSet rs = pq.executeQuery();
            while (rs.next()) {
                list.add(ProcessDAO.getProcessFromRs(rs, "p."));
            }
            page.setRecordCount(pq.getPrepared());
        }
    }
}

