/*
 * Decompiled with CFR 0.152.
 */
package org.bgerp.cache;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bgerp.app.cfg.Setup;
import org.bgerp.cache.Cache;
import org.bgerp.cache.CacheHolder;
import org.bgerp.dao.param.ParamDAO;
import org.bgerp.model.base.Id;
import org.bgerp.model.base.IdTitle;
import org.bgerp.model.base.tree.IdStringTitleTreeItem;
import org.bgerp.model.param.Parameter;
import org.bgerp.util.Dynamic;
import org.bgerp.util.Log;
import org.bgerp.util.sql.TableChangeMonitor;
import ru.bgcrm.util.Utils;
import ru.bgcrm.util.sql.SQLUtils;

public class ParameterCache
extends Cache<ParameterCache> {
    private static final Log log = Log.getLog();
    public static final CacheHolder<ParameterCache> HOLDER = new CacheHolder<ParameterCache>(new ParameterCache());
    private Map<Integer, Parameter> parameterMap;
    private Map<String, List<Parameter>> objectTypeParameters;
    private Map<Integer, Set<Integer>> paramGroupParams;
    private Map<Integer, List<IdTitle>> listParamValues;
    private Map<Integer, List<IdTitle>> listParamValuesFromDir;
    private Map<Integer, IdStringTitleTreeItem> treeParamRootNodes;

    public static Parameter getParameter(int id) {
        return ParameterCache.HOLDER.getInstance().parameterMap.get(id);
    }

    @Dynamic
    public static List<Parameter> getObjectTypeParameterList(String objectType) {
        return ParameterCache.HOLDER.getInstance().objectTypeParameters.getOrDefault(objectType, List.of());
    }

    public static List<Parameter> getObjectTypeParameterList(String objectType, int parameterGroupId) {
        ArrayList<Parameter> result = new ArrayList<Parameter>();
        List<Parameter> paramList = ParameterCache.HOLDER.getInstance().objectTypeParameters.get(objectType);
        if (paramList != null) {
            Set<Integer> paramIds = ParameterCache.HOLDER.getInstance().paramGroupParams.get(parameterGroupId);
            if (paramIds != null) {
                for (Parameter p : paramList) {
                    if (!paramIds.contains(p.getId())) continue;
                    result.add(p);
                }
            } else {
                result.addAll(paramList);
            }
        }
        return result;
    }

    public static List<Integer> getObjectTypeParameterIds(String objectType) {
        List<Integer> result = Collections.emptyList();
        List<Parameter> paramList = ParameterCache.HOLDER.getInstance().objectTypeParameters.get(objectType);
        if (paramList != null) {
            result = paramList.stream().map(Id::getId).collect(Collectors.toList());
        }
        return result;
    }

    public static List<Parameter> getParameterList(List<Integer> pids) {
        ArrayList<Parameter> result = new ArrayList<Parameter>();
        for (Integer paramId : pids) {
            result.add(ParameterCache.HOLDER.getInstance().parameterMap.get(paramId));
        }
        return result;
    }

    public static Map<Integer, IdTitle> getListParamValuesMap(int paramId) {
        return ParameterCache.getListParamValues(paramId).stream().collect(Collectors.toMap(Id::getId, Function.identity()));
    }

    public static List<IdTitle> getListParamValues(int paramId) {
        Parameter param = ParameterCache.getParameter(paramId);
        if (param == null) {
            throw new IllegalArgumentException("Parameter not found: " + paramId);
        }
        return ParameterCache.getListParamValues(param);
    }

    public static List<IdTitle> getListParamValues(final Parameter param) {
        final ParameterCache instance = HOLDER.getInstance();
        List<IdTitle> listValues = null;
        final String tableName = param.getConfigMap().get("directory");
        if (tableName != null) {
            listValues = instance.listParamValuesFromDir.get(param.getId());
            if (listValues == null) {
                String innerJoinFilter = param.getConfigMap().get("availableValuesInnerJoinFilter", "");
                StringBuilder joinFilterTableName = new StringBuilder();
                final StringBuilder joinFilterQuery = new StringBuilder();
                if (Utils.notBlankString(innerJoinFilter)) {
                    String[] tokens = innerJoinFilter.split(";");
                    if (tokens.length != 3) {
                        log.error("Incorrect inner join filter: " + innerJoinFilter, new Object[0]);
                    } else {
                        joinFilterTableName.append(tokens[0]);
                        joinFilterQuery.append(" INNER JOIN " + String.valueOf(joinFilterTableName) + " ON dir.id=" + String.valueOf(joinFilterTableName) + "." + tokens[1] + " AND " + tokens[2]);
                    }
                }
                Runnable paramExtractor = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        log.debug("Extracting param values: {}", param.getId());
                        Connection con = Setup.getSetup().getDBConnectionFromPool();
                        try {
                            ArrayList<IdTitle> listValues = new ArrayList<IdTitle>();
                            Set<Integer> availableValues = Utils.toIntegerSet(param.getConfigMap().get("availableValues", ""));
                            StringBuilder query = new StringBuilder("SELECT DISTINCT dir.id, dir.title FROM " + tableName + " AS dir ");
                            if (joinFilterQuery.length() > 0) {
                                query.append((CharSequence)joinFilterQuery);
                            }
                            if (availableValues.size() > 0) {
                                query.append(" WHERE dir.id IN (" + Utils.toString(availableValues) + ")");
                            }
                            query.append(" ORDER BY title");
                            PreparedStatement ps = con.prepareStatement(query.toString());
                            ResultSet rs = ps.executeQuery();
                            while (rs.next()) {
                                listValues.add(new IdTitle(rs.getInt(1), rs.getString(2)));
                            }
                            ps.close();
                            instance.listParamValuesFromDir.put(param.getId(), listValues);
                        }
                        catch (Exception e) {
                            log.error(e.getMessage(), e);
                        }
                        finally {
                            SQLUtils.closeConnection(con);
                        }
                    }
                };
                paramExtractor.run();
                listValues = instance.listParamValuesFromDir.get(param.getId());
                TableChangeMonitor.subscribeOnChange("param-list:" + param.getId(), tableName, paramExtractor);
                if (joinFilterTableName.length() > 0) {
                    TableChangeMonitor.subscribeOnChange("param-list-jf:" + param.getId(), joinFilterTableName.toString(), paramExtractor);
                }
            }
        } else {
            listValues = instance.listParamValues.get(param.getId());
        }
        if (listValues == null) {
            listValues = new ArrayList<IdTitle>();
        }
        return listValues;
    }

    public static IdStringTitleTreeItem getTreeParamRootNode(Parameter param) {
        return ParameterCache.HOLDER.getInstance().treeParamRootNodes.get(param.getId());
    }

    public static Map<String, String> getTreeParamValues(int paramId) {
        Parameter param = ParameterCache.getParameter(paramId);
        if (param == null) {
            throw new IllegalArgumentException("Parameter not found: " + paramId);
        }
        ArrayList<IdStringTitleTreeItem> list = new ArrayList<IdStringTitleTreeItem>(100);
        IdStringTitleTreeItem node = ParameterCache.getTreeParamRootNode(param);
        if (node != null) {
            ParameterCache.treeValuesPut(list, node);
        }
        list.sort(IdStringTitleTreeItem.COMPARATOR);
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(list.size());
        for (IdStringTitleTreeItem item : list) {
            result.put((String)item.getId(), item.getTitle());
        }
        return Collections.unmodifiableMap(result);
    }

    private static void treeValuesPut(List<IdStringTitleTreeItem> result, IdStringTitleTreeItem node) {
        result.add(node);
        if (node.getChildren() != null) {
            for (IdStringTitleTreeItem child : node.getChildren()) {
                ParameterCache.treeValuesPut(result, child);
            }
        }
    }

    public static Map<Integer, Parameter> getParameterMap() {
        return ParameterCache.HOLDER.getInstance().parameterMap;
    }

    public static void flush(Connection con) {
        HOLDER.flush(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ParameterCache newInstance() {
        ParameterCache result = new ParameterCache();
        Connection con = Setup.getSetup().getDBConnectionFromPool();
        try {
            ParamDAO paramDAO = new ParamDAO(con);
            result.objectTypeParameters = paramDAO.getParameterMapByObjectType();
            result.paramGroupParams = paramDAO.getParameterIdsByGroupIds();
            result.parameterMap = new HashMap<Integer, Parameter>();
            for (List<Parameter> paramList : result.objectTypeParameters.values()) {
                for (Parameter p : paramList) {
                    result.parameterMap.put(p.getId(), p);
                }
            }
            result.listParamValues = paramDAO.getListParamValuesMap();
            result.listParamValuesFromDir = new ConcurrentHashMap<Integer, List<IdTitle>>();
            result.treeParamRootNodes = paramDAO.getTreeParamRootNodes();
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        finally {
            SQLUtils.closeConnection(con);
        }
        return result;
    }
}

